/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.lang.annotation.Annotation;
import springfox.documentation.RequestHandler;

public class RequestHandlerSelectors {
    private RequestHandlerSelectors() {
        throw new UnsupportedOperationException();
    }

    public static Predicate<RequestHandler> any() {
        return Predicates.alwaysTrue();
    }

    public static Predicate<RequestHandler> none() {
        return Predicates.alwaysFalse();
    }

    public static Predicate<RequestHandler> withMethodAnnotation(final Class<? extends Annotation> annotation) {
        return new Predicate<RequestHandler>(){

            @Override
            public boolean apply(RequestHandler input) {
                return input.isAnnotatedWith(annotation);
            }
        };
    }

    public static Predicate<RequestHandler> withClassAnnotation(final Class<? extends Annotation> annotation) {
        return new Predicate<RequestHandler>(){

            @Override
            public boolean apply(RequestHandler input) {
                return RequestHandlerSelectors.declaringClass(input).isAnnotationPresent(annotation);
            }
        };
    }

    public static Predicate<RequestHandler> basePackage(final String basePackage) {
        return new Predicate<RequestHandler>(){

            @Override
            public boolean apply(RequestHandler input) {
                return RequestHandlerSelectors.declaringClass(input).getPackage().getName().startsWith(basePackage);
            }
        };
    }

    private static Class<?> declaringClass(RequestHandler input) {
        return input.declaringClass();
    }
}

