/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.adapter.rxjava;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import retrofit2.CallAdapter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.Result;
import retrofit2.adapter.rxjava.RxJavaCallAdapter;
import rx.Completable;
import rx.Observable;
import rx.Scheduler;
import rx.Single;

public final class RxJavaCallAdapterFactory
extends CallAdapter.Factory {
    @Nullable
    private final Scheduler scheduler;
    private final boolean isAsync;

    public static RxJavaCallAdapterFactory create() {
        return new RxJavaCallAdapterFactory(null, false);
    }

    public static RxJavaCallAdapterFactory createAsync() {
        return new RxJavaCallAdapterFactory(null, true);
    }

    public static RxJavaCallAdapterFactory createWithScheduler(Scheduler scheduler) {
        if (scheduler == null) {
            throw new NullPointerException("scheduler == null");
        }
        return new RxJavaCallAdapterFactory(scheduler, false);
    }

    private RxJavaCallAdapterFactory(@Nullable Scheduler scheduler, boolean isAsync) {
        this.scheduler = scheduler;
        this.isAsync = isAsync;
    }

    @Override
    public CallAdapter<?, ?> get(Type returnType, Annotation[] annotations, Retrofit retrofit) {
        Type responseType;
        boolean isCompletable;
        Class<?> rawType = RxJavaCallAdapterFactory.getRawType(returnType);
        boolean isSingle = rawType == Single.class;
        boolean bl = isCompletable = rawType == Completable.class;
        if (rawType != Observable.class && !isSingle && !isCompletable) {
            return null;
        }
        if (isCompletable) {
            return new RxJavaCallAdapter((Type)((Object)Void.class), this.scheduler, this.isAsync, false, true, false, true);
        }
        boolean isResult = false;
        boolean isBody = false;
        if (!(returnType instanceof ParameterizedType)) {
            String name = isSingle ? "Single" : "Observable";
            throw new IllegalStateException(name + " return type must be parameterized as " + name + "<Foo> or " + name + "<? extends Foo>");
        }
        Type observableType = RxJavaCallAdapterFactory.getParameterUpperBound(0, (ParameterizedType)returnType);
        Class<?> rawObservableType = RxJavaCallAdapterFactory.getRawType(observableType);
        if (rawObservableType == Response.class) {
            if (!(observableType instanceof ParameterizedType)) {
                throw new IllegalStateException("Response must be parameterized as Response<Foo> or Response<? extends Foo>");
            }
            responseType = RxJavaCallAdapterFactory.getParameterUpperBound(0, (ParameterizedType)observableType);
        } else if (rawObservableType == Result.class) {
            if (!(observableType instanceof ParameterizedType)) {
                throw new IllegalStateException("Result must be parameterized as Result<Foo> or Result<? extends Foo>");
            }
            responseType = RxJavaCallAdapterFactory.getParameterUpperBound(0, (ParameterizedType)observableType);
            isResult = true;
        } else {
            responseType = observableType;
            isBody = true;
        }
        return new RxJavaCallAdapter(responseType, this.scheduler, this.isAsync, isResult, isBody, isSingle, false);
    }
}

