/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.adapter.rxjava;

import retrofit2.Response;
import retrofit2.adapter.rxjava.Result;
import rx.Observable;
import rx.Subscriber;
import rx.exceptions.CompositeException;
import rx.exceptions.Exceptions;
import rx.exceptions.OnCompletedFailedException;
import rx.exceptions.OnErrorFailedException;
import rx.exceptions.OnErrorNotImplementedException;
import rx.plugins.RxJavaPlugins;

final class ResultOnSubscribe<T>
implements Observable.OnSubscribe<Result<T>> {
    private final Observable.OnSubscribe<Response<T>> upstream;

    ResultOnSubscribe(Observable.OnSubscribe<Response<T>> upstream) {
        this.upstream = upstream;
    }

    @Override
    public void call(Subscriber<? super Result<T>> subscriber) {
        this.upstream.call(new ResultSubscriber(subscriber));
    }

    private static class ResultSubscriber<R>
    extends Subscriber<Response<R>> {
        private final Subscriber<? super Result<R>> subscriber;

        ResultSubscriber(Subscriber<? super Result<R>> subscriber) {
            super(subscriber);
            this.subscriber = subscriber;
        }

        @Override
        public void onNext(Response<R> response) {
            this.subscriber.onNext(Result.response(response));
        }

        @Override
        public void onError(Throwable throwable) {
            try {
                this.subscriber.onNext(Result.error(throwable));
            }
            catch (Throwable t) {
                try {
                    this.subscriber.onError(t);
                }
                catch (OnCompletedFailedException | OnErrorFailedException | OnErrorNotImplementedException e) {
                    RxJavaPlugins.getInstance().getErrorHandler().handleError(e);
                }
                catch (Throwable inner) {
                    Exceptions.throwIfFatal(inner);
                    CompositeException composite = new CompositeException(t, inner);
                    RxJavaPlugins.getInstance().getErrorHandler().handleError(composite);
                }
                return;
            }
            this.subscriber.onCompleted();
        }

        @Override
        public void onCompleted() {
            this.subscriber.onCompleted();
        }
    }
}

