/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.adapter.rxjava;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import retrofit2.adapter.rxjava.CallArbiter;
import rx.Observable;
import rx.Subscriber;
import rx.exceptions.Exceptions;

final class CallEnqueueOnSubscribe<T>
implements Observable.OnSubscribe<Response<T>> {
    private final Call<T> originalCall;

    CallEnqueueOnSubscribe(Call<T> originalCall) {
        this.originalCall = originalCall;
    }

    @Override
    public void call(Subscriber<? super Response<T>> subscriber) {
        Call<T> call = this.originalCall.clone();
        final CallArbiter<T> arbiter = new CallArbiter<T>(call, subscriber);
        subscriber.add(arbiter);
        subscriber.setProducer(arbiter);
        call.enqueue(new Callback<T>(){

            @Override
            public void onResponse(Call<T> call, Response<T> response) {
                arbiter.emitResponse(response);
            }

            @Override
            public void onFailure(Call<T> call, Throwable t) {
                Exceptions.throwIfFatal(t);
                arbiter.emitError(t);
            }
        });
    }
}

