/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.adapter.rxjava;

import retrofit2.Response;
import retrofit2.adapter.rxjava.HttpException;
import rx.Observable;
import rx.Subscriber;
import rx.exceptions.CompositeException;
import rx.exceptions.Exceptions;
import rx.exceptions.OnCompletedFailedException;
import rx.exceptions.OnErrorFailedException;
import rx.exceptions.OnErrorNotImplementedException;
import rx.plugins.RxJavaPlugins;

final class BodyOnSubscribe<T>
implements Observable.OnSubscribe<T> {
    private final Observable.OnSubscribe<Response<T>> upstream;

    BodyOnSubscribe(Observable.OnSubscribe<Response<T>> upstream) {
        this.upstream = upstream;
    }

    @Override
    public void call(Subscriber<? super T> subscriber) {
        this.upstream.call((Response<BodySubscriber<? super T>>)((Object)new BodySubscriber<T>(subscriber)));
    }

    private static class BodySubscriber<R>
    extends Subscriber<Response<R>> {
        private final Subscriber<? super R> subscriber;
        private boolean subscriberTerminated;

        BodySubscriber(Subscriber<? super R> subscriber) {
            super(subscriber);
            this.subscriber = subscriber;
        }

        @Override
        public void onNext(Response<R> response) {
            if (response.isSuccessful()) {
                this.subscriber.onNext(response.body());
            } else {
                this.subscriberTerminated = true;
                HttpException t = new HttpException(response);
                try {
                    this.subscriber.onError(t);
                }
                catch (OnCompletedFailedException | OnErrorFailedException | OnErrorNotImplementedException e) {
                    RxJavaPlugins.getInstance().getErrorHandler().handleError(e);
                }
                catch (Throwable inner) {
                    Exceptions.throwIfFatal(inner);
                    CompositeException composite = new CompositeException(t, inner);
                    RxJavaPlugins.getInstance().getErrorHandler().handleError(composite);
                }
            }
        }

        @Override
        public void onError(Throwable throwable) {
            if (!this.subscriberTerminated) {
                this.subscriber.onError(throwable);
            } else {
                AssertionError broken = new AssertionError((Object)"This should never happen! Report as a Retrofit bug with the full stacktrace.");
                ((Throwable)((Object)broken)).initCause(throwable);
                RxJavaPlugins.getInstance().getErrorHandler().handleError((Throwable)((Object)broken));
            }
        }

        @Override
        public void onCompleted() {
            if (!this.subscriberTerminated) {
                this.subscriber.onCompleted();
            }
        }
    }
}

