/*
 * Decompiled with CFR 0.152.
 */
package de.aipark.api.tile;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import de.aipark.api.tile.Tile;

public class TileMapper {
    public static Point getLatLngFromTileIndex(Tile tile) {
        double lat = Math.atan(Math.sinh(Math.PI - tile.getY() / Math.pow(2.0, tile.getZoom()) * 2.0 * Math.PI)) * 180.0 / Math.PI;
        double lng = tile.getX() / Math.pow(2.0, tile.getZoom()) * 360.0 - 180.0;
        return new Point(new CoordinateArraySequence(new Coordinate[]{new Coordinate(lng, lat)}), new GeometryFactory());
    }

    public static Tile getTileIndexFromLatLng(Point point, int zoom) {
        double xtile = (point.getX() + 180.0) / 360.0 * (double)(1 << zoom);
        double ytile = (1.0 - Math.log(Math.tan(Math.toRadians(point.getY())) + 1.0 / Math.cos(Math.toRadians(point.getY()))) / Math.PI) / 2.0 * (double)(1 << zoom);
        if (xtile < 0.0) {
            xtile = 0.0;
        }
        if (xtile >= (double)(1 << zoom)) {
            xtile = (1 << zoom) - 1;
        }
        if (ytile < 0.0) {
            ytile = 0.0;
        }
        if (ytile >= (double)(1 << zoom)) {
            ytile = (1 << zoom) - 1;
        }
        return new Tile(xtile, ytile, zoom);
    }
}

