/*
 * Decompiled with CFR 0.152.
 */
package de.aipark.api.parkingarea;

import io.swagger.annotations.ApiModelProperty;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TreeSet;

public class Schedule
implements Comparable<Schedule> {
    private static final int DEFAULT_PRIORITY = 0;
    @ApiModelProperty(value="priority of schedule (bigger = more important)", dataType="java.lang.Integer", required=true, example="1")
    private Integer priority;
    @ApiModelProperty(value="days of schedule (PH = holidays, SH = vacation) ", dataType="List<Days>", required=true, example="MO, TH, FR")
    private List<Days> days;
    @ApiModelProperty(value="start year of schedule", dataType="java.lang.Integer", required=true, example="2017")
    private Integer validFromYear;
    @ApiModelProperty(value="end year of schedule", dataType="java.lang.Integer", required=true, example="2018")
    private Integer validToYear;
    @ApiModelProperty(value="start month of schedule (1 = JAN, 2 = FEB, ...)", dataType="java.lang.Integer", required=true, example="3")
    private Integer validFromMonth;
    @ApiModelProperty(value="end month of schedule (1 = JAN, 2 = FEB, ...)", dataType="java.lang.Integer", required=true, example="3")
    private Integer validToMonth;
    @ApiModelProperty(value="start day in month of schedule (1 = first day of month)", dataType="java.lang.Integer", required=true, example="1")
    private Integer validFromDay;
    @ApiModelProperty(value="end day in month of schedule (1 = first day of month)", dataType="java.lang.Integer", required=true, example="1")
    private Integer validToDay;
    @ApiModelProperty(value="start time of schedule", dataType="java.sql.Time", required=true, example="{\"date\": 0,\"day\": 0,\"hours\": 0,\"minutes\": 0,\"month\": 0,\"seconds\": 0,\"time\": 0,\"timezoneOffset\": 0,\"year\": 0}")
    private Time validFromTime;
    @ApiModelProperty(value="end time of schedule", dataType="java.sql.Time", required=true, example="{\"date\": 0,\"day\": 0,\"hours\": 0,\"minutes\": 0,\"month\": 0,\"seconds\": 0,\"time\": 0,\"timezoneOffset\": 0,\"year\": 0}")
    private Time validToTime;
    @ApiModelProperty(value="textual description for special schedules", dataType="java.lang.String", required=true, example="sunrise-sunset")
    private String description;

    public Schedule() {
        this.priority = 0;
        this.days = new ArrayList<Days>();
    }

    public Schedule(Schedule other) {
        this.priority = other.priority;
        this.days = other.days;
        this.validFromYear = other.validFromYear;
        this.validToYear = other.validToYear;
        this.validFromMonth = other.validFromMonth;
        this.validToMonth = other.validToMonth;
        this.validFromDay = other.validFromDay;
        this.validToDay = other.validToDay;
        this.validFromTime = other.validFromTime;
        this.validToTime = other.validToTime;
        this.description = other.description;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public List<Days> getDays() {
        return this.days;
    }

    public void setDays(List<Days> days) {
        this.days = days;
        Collections.sort(days);
    }

    public Integer getValidFromYear() {
        return this.validFromYear;
    }

    public void setValidFromYear(Integer validFromYear) {
        this.validFromYear = validFromYear;
    }

    public Integer getValidToYear() {
        return this.validToYear;
    }

    public void setValidToYear(Integer validToYear) {
        this.validToYear = validToYear;
    }

    public Integer getValidFromMonth() {
        return this.validFromMonth;
    }

    public void setValidFromMonth(Integer validFromMonth) {
        this.validFromMonth = validFromMonth;
    }

    public Integer getValidToMonth() {
        return this.validToMonth;
    }

    public void setValidToMonth(Integer validToMonth) {
        this.validToMonth = validToMonth;
    }

    public Integer getValidFromDay() {
        return this.validFromDay;
    }

    public void setValidFromDay(Integer validFromDay) {
        this.validFromDay = validFromDay;
    }

    public Integer getValidToDay() {
        return this.validToDay;
    }

    public void setValidToDay(Integer validToDay) {
        this.validToDay = validToDay;
    }

    public Time getValidFromTime() {
        return this.validFromTime;
    }

    public void setValidFromTime(Time validFromTime) {
        this.validFromTime = validFromTime;
    }

    public Time getValidToTime() {
        return this.validToTime;
    }

    public void setValidToTime(Time validToTime) {
        this.validToTime = validToTime;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public int compareTo(Schedule o) {
        int result = 0;
        if (this.validFromYear != null && o.validFromYear != null && (result = this.validFromYear.compareTo(o.validFromYear)) != 0) {
            return result;
        }
        if (this.validToYear != null && o.validToYear != null && (result = this.validToYear.compareTo(o.validToYear)) != 0) {
            return result;
        }
        if (this.validFromMonth != null && o.validFromMonth != null && (result = this.validFromMonth.compareTo(o.validFromMonth)) != 0) {
            return result;
        }
        if (this.validToMonth != null && o.validToMonth != null && (result = this.validToMonth.compareTo(o.validToMonth)) != 0) {
            return result;
        }
        if (this.validFromDay != null && o.validFromDay != null && (result = this.validFromDay.compareTo(o.validFromDay)) != 0) {
            return result;
        }
        if (this.validToDay != null && o.validToDay != null && (result = this.validToDay.compareTo(o.validToDay)) != 0) {
            return result;
        }
        if (this.days != null && o.days != null) {
            TreeSet<Days> sortedSetL1 = new TreeSet<Days>(this.days);
            TreeSet<Days> sortedSetL2 = new TreeSet<Days>(o.days);
            Days l1Day = Days.MO;
            if (!sortedSetL1.isEmpty()) {
                l1Day = (Days)((Object)sortedSetL1.first());
            }
            Days l2Day = Days.MO;
            if (!sortedSetL2.isEmpty()) {
                l2Day = (Days)((Object)sortedSetL2.first());
            }
            if ((result = l1Day.compareTo(l2Day)) != 0) {
                return result;
            }
        }
        if (this.validFromTime != null && o.validFromTime != null && (result = this.validFromTime.compareTo(o.validFromTime)) != 0) {
            return result;
        }
        if (this.validToTime != null && o.validToTime != null && (result = this.validToTime.compareTo(o.validToTime)) != 0) {
            return result;
        }
        if (this.priority != null && o.priority != null && (result = this.priority.compareTo(o.priority)) != 0) {
            return result;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Schedule schedule = (Schedule)o;
        if (this.priority != null ? !this.priority.equals(schedule.priority) : schedule.priority != null) {
            return false;
        }
        if (this.days != null ? !this.days.equals(schedule.days) : schedule.days != null) {
            return false;
        }
        if (this.validFromYear != null ? !this.validFromYear.equals(schedule.validFromYear) : schedule.validFromYear != null) {
            return false;
        }
        if (this.validToYear != null ? !this.validToYear.equals(schedule.validToYear) : schedule.validToYear != null) {
            return false;
        }
        if (this.validFromMonth != null ? !this.validFromMonth.equals(schedule.validFromMonth) : schedule.validFromMonth != null) {
            return false;
        }
        if (this.validToMonth != null ? !this.validToMonth.equals(schedule.validToMonth) : schedule.validToMonth != null) {
            return false;
        }
        if (this.validFromDay != null ? !this.validFromDay.equals(schedule.validFromDay) : schedule.validFromDay != null) {
            return false;
        }
        if (this.validToDay != null ? !this.validToDay.equals(schedule.validToDay) : schedule.validToDay != null) {
            return false;
        }
        if (this.validFromTime != null ? !this.validFromTime.equals(schedule.validFromTime) : schedule.validFromTime != null) {
            return false;
        }
        if (this.validToTime != null ? !this.validToTime.equals(schedule.validToTime) : schedule.validToTime != null) {
            return false;
        }
        return this.description != null ? this.description.equals(schedule.description) : schedule.description == null;
    }

    public int hashCode() {
        int result = this.priority != null ? this.priority.hashCode() : 0;
        result = 31 * result + (this.days != null ? this.days.hashCode() : 0);
        result = 31 * result + (this.validFromYear != null ? this.validFromYear.hashCode() : 0);
        result = 31 * result + (this.validToYear != null ? this.validToYear.hashCode() : 0);
        result = 31 * result + (this.validFromMonth != null ? this.validFromMonth.hashCode() : 0);
        result = 31 * result + (this.validToMonth != null ? this.validToMonth.hashCode() : 0);
        result = 31 * result + (this.validFromDay != null ? this.validFromDay.hashCode() : 0);
        result = 31 * result + (this.validToDay != null ? this.validToDay.hashCode() : 0);
        result = 31 * result + (this.validFromTime != null ? this.validFromTime.hashCode() : 0);
        result = 31 * result + (this.validToTime != null ? this.validToTime.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }

    public String toString() {
        ResourceBundle bundle = ResourceBundle.getBundle("Api");
        Collections.sort(this.days);
        StringBuilder result = new StringBuilder();
        Enum dayBefore = null;
        for (Days day : this.days) {
            if (day.ordinal() > Days.SU.ordinal()) break;
            if (dayBefore == null) {
                result.append(bundle.getString(day.toString()));
            } else if (dayBefore.ordinal() + 1 == day.ordinal()) {
                if (!result.toString().endsWith("-")) {
                    result.append("-");
                }
            } else {
                if (result.toString().endsWith("-")) {
                    result.append(bundle.getString(dayBefore.toString()));
                }
                result.append(",").append(bundle.getString(day.toString()));
            }
            dayBefore = day;
        }
        if (result.toString().endsWith("-") && dayBefore != null) {
            result.append(bundle.getString(dayBefore.toString()));
        }
        if (this.days.contains((Object)Days.PH)) {
            if (!result.toString().equals("")) {
                result.append(" ");
            }
            result.append(bundle.getString(Days.PH.toString()));
        }
        if (this.days.contains((Object)Days.SH)) {
            if (!result.toString().equals("")) {
                result.append(" ");
            }
            result.append(bundle.getString(Days.SH.toString()));
        }
        if (!result.toString().endsWith(" ")) {
            result.append(" ");
        }
        if (this.validFromTime != null) {
            result.append(this.validFromTime.toString().substring(0, this.validFromTime.toString().lastIndexOf(":")));
        }
        if (this.validToTime != null) {
            result.append("-").append(this.validToTime.toString().substring(0, this.validToTime.toString().lastIndexOf(":")));
        }
        boolean fromValue = false;
        if (!result.toString().endsWith(" ")) {
            result.append(" ");
        }
        if (this.validFromDay != null) {
            result.append(this.validFromDay).append(".");
            fromValue = true;
        }
        if (this.validFromMonth != null) {
            result.append(bundle.getString(Month.values()[this.validFromMonth - 1].toString()));
            fromValue = true;
        }
        if (this.validFromYear != null) {
            if (!result.toString().endsWith(" ")) {
                result.append(" ");
            }
            result.append(this.validFromYear);
            fromValue = true;
        }
        if (fromValue) {
            result.append("-");
        }
        if (this.validToDay != null) {
            result.append(this.validToDay).append(".");
        }
        if (this.validToMonth != null) {
            result.append(bundle.getString(Month.values()[this.validToMonth - 1].toString()));
        }
        if (this.validToYear != null) {
            if (!result.toString().endsWith("-")) {
                result.append(" ");
            }
            result.append(this.validToYear);
        }
        result = new StringBuilder(result.toString().trim());
        if (this.description != null && !this.description.isEmpty()) {
            result.append(" ").append(this.description);
        }
        result = new StringBuilder(result.toString().trim());
        return result.toString();
    }

    public boolean match(Timestamp timestamp, boolean isVacation, boolean isHoliday) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(timestamp);
        if (!(this.days.isEmpty() || this.days.contains((Object)Days.values()[(cal.get(7) - 2 + 7) % 7]) || this.days.contains((Object)Days.PH) && isHoliday || this.days.contains((Object)Days.SH) && isVacation)) {
            return false;
        }
        if (this.validFromMonth != null && this.validToMonth != null || this.validFromDay != null && this.validToDay != null) {
            Integer fromMonthDayValue = 0;
            Integer toMonthDayValue = 0;
            Integer timestampMonthDayValue = 0;
            if (this.validFromMonth != null && this.validToMonth != null) {
                fromMonthDayValue = fromMonthDayValue + this.validFromMonth * 100;
                toMonthDayValue = toMonthDayValue + this.validToMonth * 100;
                timestampMonthDayValue = timestampMonthDayValue + (cal.get(2) + 1) * 100;
            }
            if (this.validFromDay != null && this.validToDay != null) {
                fromMonthDayValue = fromMonthDayValue + this.validFromDay;
                toMonthDayValue = toMonthDayValue + this.validToDay;
                timestampMonthDayValue = timestampMonthDayValue + cal.get(5);
            }
            if (this.checkTimestampOutOfMonthBoundaries(fromMonthDayValue, toMonthDayValue, timestampMonthDayValue)) {
                return false;
            }
        }
        if (this.validFromTime != null && this.validToTime != null) {
            Calendar fromTime = Calendar.getInstance();
            fromTime.setTime(this.validFromTime);
            Calendar toTime = Calendar.getInstance();
            toTime.setTime(this.validToTime);
            Integer timestampValue = cal.get(11) * 100 + cal.get(12);
            Integer fromTimeValue = fromTime.get(11) * 100 + fromTime.get(12);
            Integer toTimeValue = toTime.get(11) * 100 + toTime.get(12);
            if (this.checkTimestampOutOfMonthBoundaries(fromTimeValue, toTimeValue, timestampValue)) {
                return false;
            }
        }
        return !(this.validFromYear != null && this.validFromYear > cal.get(1) || this.validToYear != null && this.validToYear < cal.get(1));
    }

    private boolean checkTimestampOutOfMonthBoundaries(Integer fromMonthDayValue, Integer toMonthDayValue, Integer timestampMonthDayValue) {
        if (fromMonthDayValue < toMonthDayValue) {
            return fromMonthDayValue > timestampMonthDayValue || toMonthDayValue < timestampMonthDayValue;
        }
        return fromMonthDayValue > timestampMonthDayValue && toMonthDayValue < timestampMonthDayValue;
    }

    public static enum Month {
        JAN,
        FEB,
        MAR,
        APR,
        MAY,
        JUN,
        JUL,
        AUG,
        SEP,
        OCT,
        NOV,
        DEC;

    }

    public static enum Days {
        MO,
        TU,
        WE,
        TH,
        FR,
        SA,
        SU,
        PH,
        SH;

    }
}

