/*
 * Decompiled with CFR 0.152.
 */
package de.aipark.api.optimalTrip;

import com.vividsolutions.jts.geom.Point;
import de.aipark.api.occupancy.ParkingAreaWithOccupancy;
import de.aipark.api.parkingarea.ParkingAreaType;
import de.aipark.api.route.Route;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class OptimalTrip {
    private List<Point> stopoverPoints;
    private List<ParkingAreaWithOccupancy> parkingAreaResultsOptimalTrip;
    private Route route;
    private Point destination;
    private boolean free;
    private boolean handicapped;
    private boolean resident;
    private double probability;
    private Integer parkingSpaces;
    private List<ParkingAreaType> preferredType;
    @ApiModelProperty(value="estimated search duration for a parking spot in seconds")
    Integer estimatedSearchDuration;

    public OptimalTrip() {
        this.stopoverPoints = new ArrayList<Point>();
        this.parkingAreaResultsOptimalTrip = new ArrayList<ParkingAreaWithOccupancy>();
        this.free = false;
        this.handicapped = false;
        this.resident = false;
    }

    public OptimalTrip(List<Point> stopoverPoints, List<ParkingAreaWithOccupancy> parkingAreaResultsOptimalTrip, Route route, Point destination, boolean free, boolean handicapped, boolean resident, double probability, Integer parkingSpaces, List<ParkingAreaType> preferredType, Integer estimatedSearchDuration) {
        this.stopoverPoints = stopoverPoints;
        this.parkingAreaResultsOptimalTrip = parkingAreaResultsOptimalTrip;
        this.route = route;
        this.destination = destination;
        this.free = free;
        this.handicapped = handicapped;
        this.resident = resident;
        this.probability = probability;
        this.parkingSpaces = parkingSpaces;
        this.preferredType = preferredType;
        this.estimatedSearchDuration = estimatedSearchDuration;
    }

    public List<Point> getStopoverPoints() {
        return this.stopoverPoints;
    }

    public void setStopoverPoints(List<Point> stopoverPoints) {
        this.stopoverPoints = stopoverPoints;
    }

    public List<ParkingAreaWithOccupancy> getParkingAreaResultsOptimalTrip() {
        return this.parkingAreaResultsOptimalTrip;
    }

    public void setParkingAreaResultsOptimalTrip(List<ParkingAreaWithOccupancy> parkingAreaResultsOptimalTrip) {
        this.parkingAreaResultsOptimalTrip = parkingAreaResultsOptimalTrip;
    }

    public Route getRoute() {
        return this.route;
    }

    public void setRoute(Route route) {
        this.route = route;
    }

    public Point getDestination() {
        return this.destination;
    }

    public void setDestination(Point destination) {
        this.destination = destination;
    }

    public boolean isFree() {
        return this.free;
    }

    public void setFree(boolean free) {
        this.free = free;
    }

    public boolean isHandicapped() {
        return this.handicapped;
    }

    public void setHandicapped(boolean handicapped) {
        this.handicapped = handicapped;
    }

    public boolean isResident() {
        return this.resident;
    }

    public void setResident(boolean resident) {
        this.resident = resident;
    }

    public double getProbability() {
        return this.probability;
    }

    public void setProbability(double probability) {
        this.probability = probability;
    }

    public Integer getParkingSpaces() {
        return this.parkingSpaces;
    }

    public void setParkingSpaces(Integer parkingSpaces) {
        this.parkingSpaces = parkingSpaces;
    }

    public List<ParkingAreaType> getPreferredType() {
        return this.preferredType;
    }

    public void setPreferredType(List<ParkingAreaType> preferredType) {
        this.preferredType = preferredType;
    }

    public Integer getEstimatedSearchDuration() {
        return this.estimatedSearchDuration;
    }

    public void setEstimatedSearchDuration(Integer estimatedSearchDuration) {
        this.estimatedSearchDuration = estimatedSearchDuration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OptimalTrip)) {
            return false;
        }
        OptimalTrip that = (OptimalTrip)o;
        if (this.isFree() != that.isFree()) {
            return false;
        }
        if (this.isHandicapped() != that.isHandicapped()) {
            return false;
        }
        if (this.isResident() != that.isResident()) {
            return false;
        }
        if (Double.compare(that.getProbability(), this.getProbability()) != 0) {
            return false;
        }
        if (this.getStopoverPoints() != null ? !this.getStopoverPoints().equals(that.getStopoverPoints()) : that.getStopoverPoints() != null) {
            return false;
        }
        if (this.getParkingAreaResultsOptimalTrip() != null ? !this.getParkingAreaResultsOptimalTrip().equals(that.getParkingAreaResultsOptimalTrip()) : that.getParkingAreaResultsOptimalTrip() != null) {
            return false;
        }
        if (this.getRoute() != null ? !this.getRoute().equals(that.getRoute()) : that.getRoute() != null) {
            return false;
        }
        if (this.getDestination() != null ? !this.getDestination().equals(that.getDestination()) : that.getDestination() != null) {
            return false;
        }
        if (this.getParkingSpaces() != null ? !this.getParkingSpaces().equals(that.getParkingSpaces()) : that.getParkingSpaces() != null) {
            return false;
        }
        if (this.getPreferredType() != null ? !this.getPreferredType().equals(that.getPreferredType()) : that.getPreferredType() != null) {
            return false;
        }
        return this.getEstimatedSearchDuration() != null ? this.getEstimatedSearchDuration().equals(that.getEstimatedSearchDuration()) : that.getEstimatedSearchDuration() == null;
    }

    public int hashCode() {
        int result = this.getStopoverPoints() != null ? this.getStopoverPoints().hashCode() : 0;
        result = 31 * result + (this.getParkingAreaResultsOptimalTrip() != null ? this.getParkingAreaResultsOptimalTrip().hashCode() : 0);
        result = 31 * result + (this.getRoute() != null ? this.getRoute().hashCode() : 0);
        result = 31 * result + (this.getDestination() != null ? this.getDestination().hashCode() : 0);
        result = 31 * result + (this.isFree() ? 1 : 0);
        result = 31 * result + (this.isHandicapped() ? 1 : 0);
        result = 31 * result + (this.isResident() ? 1 : 0);
        long temp = Double.doubleToLongBits(this.getProbability());
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.getParkingSpaces() != null ? this.getParkingSpaces().hashCode() : 0);
        result = 31 * result + (this.getPreferredType() != null ? this.getPreferredType().hashCode() : 0);
        result = 31 * result + (this.getEstimatedSearchDuration() != null ? this.getEstimatedSearchDuration().hashCode() : 0);
        return result;
    }

    public String toString() {
        ResourceBundle bundle = ResourceBundle.getBundle("Api");
        String result = "";
        if (this.preferredType.size() > 0) {
            switch (this.preferredType.get(0)) {
                case CAR_PARK: {
                    result = result + bundle.getString("preferCarParks");
                    break;
                }
                case PARKINGAREA: 
                case ON_STREET: {
                    result = result + bundle.getString("preferFree");
                }
            }
        }
        return result;
    }
}

