/*
 * Decompiled with CFR 0.152.
 */
package de.aipark.api.chargingstation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.vividsolutions.jts.geom.Point;
import de.aipark.api.chargingstation.ChargingAuthentication;
import de.aipark.api.chargingstation.ChargingOperator;
import de.aipark.api.chargingstation.ChargingPlugTypeWithCapacity;
import de.aipark.api.chargingstation.ChargingPriceEntry;
import de.aipark.api.parkingarea.MapEntry;
import de.aipark.api.parkingarea.OpeningStatus;
import de.aipark.api.parkingarea.Schedule;
import de.aipark.api.payment.PaymentType;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class ChargingStation {
    @ApiModelProperty(value="unique id of charging station", dataType="java.lang.Long", required=true, example="504838")
    private Integer id;
    @ApiModelProperty(value="unique id of parking area the charging station belongs to", dataType="java.lang.Long", required=true, example="504838")
    private Long parkingAreaId;
    @ApiModelProperty(value="position of charging station", required=true)
    private Point position;
    @ApiModelProperty(value="name of charging station", dataType="java.lang.String", required=true, example="City")
    private String name;
    @ApiModelProperty(value="description of charging station", dataType="java.lang.String", required=true, example="Free charging station near to XY.")
    private String description;
    @ApiModelProperty(value="unique id of charging station", dataType="java.lang.Long", required=true, example="504838")
    private Integer capacity;
    @ApiModelProperty(value="operator of the charging station", required=true)
    private ChargingOperator operator;
    @ApiModelProperty(value="charging plug types with capacity", required=true)
    private List<ChargingPlugTypeWithCapacity> plugTypes;
    @ApiModelProperty(value="supported authentication types", required=true)
    private List<ChargingAuthentication> authentications;
    @ApiModelProperty(value="pricing", required=true)
    private List<ChargingPriceEntry> priceEntries;
    @ApiModelProperty(value="schedule when charging station is opened or closed", dataType="MapEntry<Schedule, Boolean>", required=true)
    private MapEntry<Schedule, OpeningStatus> scheduleOpen;
    @ApiModelProperty(value="schedule for charging station (value = allowed time in minutes)", dataType="MapEntry<Schedule, Boolean>", required=true)
    private MapEntry<Schedule, Integer> scheduleMaxStay;
    @ApiModelProperty(value="supported payment types", required=true)
    private List<PaymentType> paymentTypes;
    @ApiModelProperty(value="website", dataType="java.lang.String", required=true, example="https://www.enercity.de/privatkunden/mobilitaet/e-mobilitaet/formular-reg-e-tanken/index.jsx")
    private String website;

    public ChargingStation() {
        this.plugTypes = new ArrayList<ChargingPlugTypeWithCapacity>();
        this.authentications = new ArrayList<ChargingAuthentication>();
        this.priceEntries = new ArrayList<ChargingPriceEntry>();
        this.scheduleOpen = new MapEntry();
        this.scheduleMaxStay = new MapEntry();
        this.paymentTypes = new ArrayList<PaymentType>();
    }

    public ChargingStation(Integer id, Long parkingAreaId, Point position, String name, String description, Integer capacity, ChargingOperator operator, List<ChargingPlugTypeWithCapacity> plugTypes, List<ChargingAuthentication> authentications, List<ChargingPriceEntry> priceEntries, MapEntry<Schedule, OpeningStatus> scheduleOpen, MapEntry<Schedule, Integer> scheduleMaxStay, List<PaymentType> paymentTypes, String website) {
        this.id = id;
        this.parkingAreaId = parkingAreaId;
        this.position = position;
        this.name = name;
        this.description = description;
        this.capacity = capacity;
        this.operator = operator;
        this.plugTypes = plugTypes;
        this.authentications = authentications;
        this.priceEntries = priceEntries;
        this.scheduleOpen = scheduleOpen;
        this.scheduleMaxStay = scheduleMaxStay;
        this.paymentTypes = paymentTypes;
        this.website = website;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Long getParkingAreaId() {
        return this.parkingAreaId;
    }

    public void setParkingAreaId(Long parkingAreaId) {
        this.parkingAreaId = parkingAreaId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getCapacity() {
        return this.capacity;
    }

    public void setCapacity(Integer capacity) {
        this.capacity = capacity;
    }

    public ChargingOperator getOperator() {
        return this.operator;
    }

    public void setOperator(ChargingOperator operator) {
        this.operator = operator;
    }

    public List<ChargingPlugTypeWithCapacity> getPlugTypes() {
        return this.plugTypes;
    }

    public void setPlugTypes(List<ChargingPlugTypeWithCapacity> plugTypes) {
        this.plugTypes = plugTypes;
    }

    public List<ChargingAuthentication> getAuthentications() {
        return this.authentications;
    }

    public void setAuthentications(List<ChargingAuthentication> authentications) {
        this.authentications = authentications;
    }

    public List<ChargingPriceEntry> getPriceEntries() {
        return this.priceEntries;
    }

    public void setPriceEntries(List<ChargingPriceEntry> priceEntries) {
        this.priceEntries = priceEntries;
    }

    public Point getPosition() {
        return this.position;
    }

    public void setPosition(Point position) {
        this.position = position;
    }

    public MapEntry<Schedule, OpeningStatus> getScheduleOpen() {
        return this.scheduleOpen;
    }

    public void setScheduleOpen(MapEntry<Schedule, OpeningStatus> scheduleOpen) {
        this.scheduleOpen = scheduleOpen;
    }

    public MapEntry<Schedule, Integer> getScheduleMaxStay() {
        return this.scheduleMaxStay;
    }

    public void setScheduleMaxStay(MapEntry<Schedule, Integer> scheduleMaxStay) {
        this.scheduleMaxStay = scheduleMaxStay;
    }

    public List<PaymentType> getPaymentTypes() {
        return this.paymentTypes;
    }

    public void setPaymentTypes(List<PaymentType> paymentTypes) {
        this.paymentTypes = paymentTypes;
    }

    public String getWebsite() {
        return this.website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChargingStation)) {
            return false;
        }
        ChargingStation that = (ChargingStation)o;
        if (this.getId() != null ? !this.getId().equals(that.getId()) : that.getId() != null) {
            return false;
        }
        if (this.getParkingAreaId() != null ? !this.getParkingAreaId().equals(that.getParkingAreaId()) : that.getParkingAreaId() != null) {
            return false;
        }
        if (this.getPosition() != null ? !this.getPosition().equals(that.getPosition()) : that.getPosition() != null) {
            return false;
        }
        if (this.getName() != null ? !this.getName().equals(that.getName()) : that.getName() != null) {
            return false;
        }
        if (this.getDescription() != null ? !this.getDescription().equals(that.getDescription()) : that.getDescription() != null) {
            return false;
        }
        if (this.getCapacity() != null ? !this.getCapacity().equals(that.getCapacity()) : that.getCapacity() != null) {
            return false;
        }
        if (this.getOperator() != null ? !this.getOperator().equals(that.getOperator()) : that.getOperator() != null) {
            return false;
        }
        if (this.getPlugTypes() != null ? !this.getPlugTypes().equals(that.getPlugTypes()) : that.getPlugTypes() != null) {
            return false;
        }
        if (this.getAuthentications() != null ? !this.getAuthentications().equals(that.getAuthentications()) : that.getAuthentications() != null) {
            return false;
        }
        if (this.getPriceEntries() != null ? !this.getPriceEntries().equals(that.getPriceEntries()) : that.getPriceEntries() != null) {
            return false;
        }
        if (this.getScheduleOpen() != null ? !this.getScheduleOpen().equals(that.getScheduleOpen()) : that.getScheduleOpen() != null) {
            return false;
        }
        if (this.getScheduleMaxStay() != null ? !this.getScheduleMaxStay().equals(that.getScheduleMaxStay()) : that.getScheduleMaxStay() != null) {
            return false;
        }
        if (this.getPaymentTypes() != null ? !this.getPaymentTypes().equals(that.getPaymentTypes()) : that.getPaymentTypes() != null) {
            return false;
        }
        return this.getWebsite() != null ? this.getWebsite().equals(that.getWebsite()) : that.getWebsite() == null;
    }

    public int hashCode() {
        int result = this.getId() != null ? this.getId().hashCode() : 0;
        result = 31 * result + (this.getParkingAreaId() != null ? this.getParkingAreaId().hashCode() : 0);
        result = 31 * result + (this.getPosition() != null ? this.getPosition().hashCode() : 0);
        result = 31 * result + (this.getName() != null ? this.getName().hashCode() : 0);
        result = 31 * result + (this.getDescription() != null ? this.getDescription().hashCode() : 0);
        result = 31 * result + (this.getCapacity() != null ? this.getCapacity().hashCode() : 0);
        result = 31 * result + (this.getOperator() != null ? this.getOperator().hashCode() : 0);
        result = 31 * result + (this.getPlugTypes() != null ? this.getPlugTypes().hashCode() : 0);
        result = 31 * result + (this.getAuthentications() != null ? this.getAuthentications().hashCode() : 0);
        result = 31 * result + (this.getPriceEntries() != null ? this.getPriceEntries().hashCode() : 0);
        result = 31 * result + (this.getScheduleOpen() != null ? this.getScheduleOpen().hashCode() : 0);
        result = 31 * result + (this.getScheduleMaxStay() != null ? this.getScheduleMaxStay().hashCode() : 0);
        result = 31 * result + (this.getPaymentTypes() != null ? this.getPaymentTypes().hashCode() : 0);
        result = 31 * result + (this.getWebsite() != null ? this.getWebsite().hashCode() : 0);
        return result;
    }

    public String toString() {
        String result = "ChargingStation{id=" + this.id + ", parkingAreaId=" + this.parkingAreaId + ", position=" + this.position + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", capacity=" + this.capacity + ", operator=" + this.operator + ", website='" + this.website + '\'' + '}';
        for (ChargingPlugTypeWithCapacity chargingPlugTypeWithCapacity : this.getPlugTypes()) {
            result = result + "\n" + chargingPlugTypeWithCapacity;
        }
        for (ChargingAuthentication chargingAuthentication : this.getAuthentications()) {
            result = result + "\n" + chargingAuthentication;
        }
        for (ChargingPriceEntry chargingPriceEntry : this.getPriceEntries()) {
            result = result + "\n" + chargingPriceEntry;
        }
        for (MapEntry.Entry entry : this.getScheduleOpen().getEntryList()) {
            result = result + "\n" + entry.getKey() + " : " + entry.getValue();
        }
        for (MapEntry.Entry entry : this.getScheduleMaxStay().getEntryList()) {
            result = result + "\n" + entry.getKey() + " : " + entry.getValue();
        }
        for (PaymentType paymentType : this.getPaymentTypes()) {
            result = result + "\n" + paymentType;
        }
        return result;
    }

    @JsonIgnore
    public String getMaxStayString() {
        ResourceBundle bundle = ResourceBundle.getBundle("Api");
        String result = "";
        for (MapEntry.Entry<Schedule, Integer> entry : this.scheduleMaxStay.getEntryList()) {
            if (!result.isEmpty()) {
                result = result + "\n";
            }
            result = result + entry.getKey().toString() + " " + bundle.getString("maximal") + " " + entry.getValue() + " " + bundle.getString("minutes");
        }
        return result;
    }
}

