/*
 * Decompiled with CFR 0.152.
 */
package com.bedatadriven.jackson.datatype.jts.parsers;

import com.bedatadriven.jackson.datatype.jts.parsers.BaseParser;
import com.bedatadriven.jackson.datatype.jts.parsers.GeometryParser;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;

public class PointParser
extends BaseParser
implements GeometryParser<Point> {
    public PointParser(GeometryFactory geometryFactory) {
        super(geometryFactory);
    }

    public static Coordinate coordinateFromJson(JsonNode array) {
        assert (array.isArray() && array.size() == 2) : "expecting coordinate array with single point [ x, y ]";
        return new Coordinate(array.get(0).asDouble(), array.get(1).asDouble());
    }

    public static Coordinate[] coordinatesFromJson(JsonNode array) {
        Coordinate[] points = new Coordinate[array.size()];
        for (int i = 0; i != array.size(); ++i) {
            points[i] = PointParser.coordinateFromJson(array.get(i));
        }
        return points;
    }

    public Point pointFromJson(JsonNode node) {
        return this.geometryFactory.createPoint(PointParser.coordinateFromJson(node.get("coordinates")));
    }

    @Override
    public Point geometryFromJson(JsonNode node) throws JsonMappingException {
        return this.pointFromJson(node);
    }
}

