/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.internal;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.JTextPane;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.beanfabrics.View;
import org.beanfabrics.event.WeakPropertyChangeListener;
import org.beanfabrics.model.ITextPM;
import org.beanfabrics.swing.ErrorIconPainter;
import org.beanfabrics.swing.internal.BnStyledDocument;
import org.beanfabrics.swing.internal.BnStyledEditorKit;

public class TextPMTextPane
extends JTextPane
implements View<ITextPM> {
    private static final long serialVersionUID = 1L;
    private boolean selectAllOnFocusGainedEnabled = false;
    private boolean reformatOnFocusLostEnabled = false;
    private final PropertyChangeListener listener = new MyWeakPropertyChangeListener();
    private ErrorIconPainter errorIconPainter = this.createDefaultErrorIconPainter();

    public TextPMTextPane() {
        this.init();
    }

    public TextPMTextPane(StyledDocument doc) {
        super(doc);
        this.init();
    }

    public TextPMTextPane(ITextPM pModel) {
        this.init();
        this.setPresentationModel(pModel);
    }

    public boolean isSelectAllOnFocusGainedEnabled() {
        return this.selectAllOnFocusGainedEnabled;
    }

    public void setSelectAllOnFocusGainedEnabled(boolean selectAllOnFocusGainedEnabled) {
        this.selectAllOnFocusGainedEnabled = selectAllOnFocusGainedEnabled;
    }

    public boolean isReformatOnFocusLostEnabled() {
        return this.reformatOnFocusLostEnabled;
    }

    public void setReformatOnFocusLostEnabled(boolean reformatOnFocusLostEnabled) {
        this.reformatOnFocusLostEnabled = reformatOnFocusLostEnabled;
    }

    private void init() {
        this.setEnabled(false);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                TextPMTextPane.this.onFocusGained();
            }

            @Override
            public void focusLost(FocusEvent e) {
                TextPMTextPane.this.onFocusLost();
            }
        });
    }

    protected void onFocusGained() {
        this.repaint();
        if (this.isSelectAllOnFocusGainedEnabled()) {
            this.selectAll();
        }
    }

    protected void onFocusLost() {
        this.repaint();
        if (this.isReformatOnFocusLostEnabled() && this.isConnected()) {
            this.getDocument().getPresentationModel().reformat();
        }
    }

    @Override
    protected EditorKit createDefaultEditorKit() {
        return new BnStyledEditorKit();
    }

    @Override
    public BnStyledDocument getDocument() {
        return (BnStyledDocument)super.getDocument();
    }

    @Override
    public void setDocument(Document doc) {
        if (!(doc instanceof BnStyledDocument)) {
            throw new IllegalArgumentException("Model must be BnStyledDocument");
        }
        super.setDocument(doc);
    }

    @Override
    public BnStyledDocument getStyledDocument() {
        return this.getDocument();
    }

    @Override
    public void setStyledDocument(StyledDocument doc) {
        this.setDocument(doc);
    }

    public ITextPM getPresentationModel() {
        if (this.getDocument() == null) {
            return null;
        }
        return this.getDocument().getPresentationModel();
    }

    public void setPresentationModel(ITextPM newModel) {
        ITextPM oldModel = this.getDocument().getPresentationModel();
        if (oldModel != null) {
            oldModel.removePropertyChangeListener(this.listener);
        }
        this.getDocument().setPresentationModel(newModel);
        if (newModel != null) {
            newModel.addPropertyChangeListener(this.listener);
        }
        this.refresh();
        this.firePropertyChange("presentationModel", oldModel, newModel);
    }

    protected boolean isConnected() {
        return this.getDocument() != null && this.getDocument().getPresentationModel() != null;
    }

    protected void refresh() {
        ITextPM pModel = this.getPresentationModel();
        if (pModel != null) {
            this.setEnabled(true);
            this.setToolTipText(!pModel.isValid() ? pModel.getValidationState().getMessage() : pModel.getDescription());
            this.setEditable(pModel.isEditable());
        } else {
            this.setEnabled(false);
        }
        this.repaint();
    }

    private ErrorIconPainter createDefaultErrorIconPainter() {
        ErrorIconPainter result = new ErrorIconPainter();
        result.setVerticalAlignment(1);
        return result;
    }

    public ErrorIconPainter getErrorIconPainter() {
        return this.errorIconPainter;
    }

    public void setErrorIconPainter(ErrorIconPainter aErrorIconPainter) {
        if (aErrorIconPainter == null) {
            throw new IllegalArgumentException("aErrorIconPainter == null");
        }
        this.errorIconPainter = aErrorIconPainter;
    }

    @Override
    public void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.shouldPaintErrorIcon()) {
            this.errorIconPainter.paint(g, (Component)this);
        }
    }

    private boolean shouldPaintErrorIcon() {
        ITextPM pModel = this.getPresentationModel();
        if (pModel == null) {
            return false;
        }
        return !pModel.isValid();
    }

    private class MyWeakPropertyChangeListener
    implements WeakPropertyChangeListener,
    Serializable {
        private static final long serialVersionUID = 1L;

        private MyWeakPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            TextPMTextPane.this.refresh();
        }
    }
}

