/*
 * Decompiled with CFR 0.152.
 */
package de.adrodoc55.minecraft.mpl.ide.gui.editor;

import com.google.common.base.Preconditions;
import de.adrodoc55.minecraft.mpl.ide.gui.editor.UndoableBnStyledDocument;
import java.lang.reflect.Field;
import java.lang.reflect.UndeclaredThrowableException;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.undo.AbstractUndoableEdit;

public abstract class AbstractUndoableBnEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    protected final UndoableBnStyledDocument doc;

    public AbstractUndoableBnEdit(UndoableBnStyledDocument doc) {
        this.doc = (UndoableBnStyledDocument)Preconditions.checkNotNull((Object)doc, (Object)"doc == null!");
        try {
            Field hasBeenDone = AbstractUndoableEdit.class.getDeclaredField("hasBeenDone");
            hasBeenDone.setAccessible(true);
            hasBeenDone.setBoolean(this, false);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException ex) {
            throw new UndeclaredThrowableException(ex);
        }
    }

    protected void remove(int offs, int len) throws BadLocationException {
        this.doc.removeSilent(offs, len);
        UndoableBnStyledDocument undoableBnStyledDocument = this.doc;
        undoableBnStyledDocument.getClass();
        this.doc.fireRemoveUpdate(new UndoableBnStyledDocument.MyCaretUpdateEvent(undoableBnStyledDocument, offs, len, DocumentEvent.EventType.REMOVE));
    }

    protected void replace(int offs, int len, String text, AttributeSet attrs) throws BadLocationException {
        this.doc.replaceSilent(offs, len, text, attrs);
        UndoableBnStyledDocument undoableBnStyledDocument = this.doc;
        undoableBnStyledDocument.getClass();
        this.doc.fireChangedUpdate(new UndoableBnStyledDocument.MyCaretUpdateEvent(undoableBnStyledDocument, offs, text.length(), DocumentEvent.EventType.CHANGE));
    }

    protected void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        this.doc.insertStringSilent(offs, str, a);
        UndoableBnStyledDocument undoableBnStyledDocument = this.doc;
        undoableBnStyledDocument.getClass();
        this.doc.fireInsertUpdate(new UndoableBnStyledDocument.MyCaretUpdateEvent(undoableBnStyledDocument, offs, str.length(), DocumentEvent.EventType.INSERT));
    }
}

