/*
 * Decompiled with CFR 0.152.
 */
package de.adrodoc55.minecraft.mpl.ide.gui;

import de.adrodoc55.minecraft.mpl.antlr.MplLexer;
import de.adrodoc55.minecraft.mpl.ide.gui.MplSyntaxFilterPM;
import de.adrodoc55.minecraft.mpl.ide.gui.utils.BnJaggedEditorKit;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.util.EventObject;
import java.util.List;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.Token;
import org.beanfabrics.BnModelObserver;
import org.beanfabrics.IModelProvider;
import org.beanfabrics.Link;
import org.beanfabrics.ModelProvider;
import org.beanfabrics.Path;
import org.beanfabrics.View;
import org.beanfabrics.event.BnPropertyChangeEvent;
import org.beanfabrics.model.PresentationModel;

public class MplSyntaxFilter
extends DocumentFilter
implements View<MplSyntaxFilterPM> {
    private final Link link = new Link((View)this);
    private ModelProvider localModelProvider;
    private BnModelObserver modelObserver = this.getModelObserver();
    private StyledDocument doc;

    public BnModelObserver getModelObserver() {
        if (this.modelObserver == null) {
            this.modelObserver = new BnModelObserver();
            this.modelObserver.setPath(new Path());
            this.modelObserver.setModelProvider((IModelProvider)this.getLocalModelProvider());
            this.modelObserver.addPropertyChangeListener(e -> {
                if (!(e instanceof BnPropertyChangeEvent)) {
                    return;
                }
                EventObject cause = ((BnPropertyChangeEvent)e).getCause();
                if (!(cause instanceof PropertyChangeEvent)) {
                    return;
                }
                String propertyName = ((PropertyChangeEvent)cause).getPropertyName();
                if (!"errors".equals(propertyName) && !"warnings".equals(propertyName)) {
                    return;
                }
                this.recolor();
            });
        }
        return this.modelObserver;
    }

    @Override
    public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
        super.remove(fb, offset, length);
        this.correctExceptionIndicies(offset, -length);
        Document document = fb.getDocument();
        if (document instanceof StyledDocument) {
            this.recolor((StyledDocument)document);
        }
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
        super.insertString(fb, offset, string, attr);
        this.correctExceptionIndicies(offset, string.length());
        Document document = fb.getDocument();
        if (document instanceof StyledDocument) {
            this.recolor((StyledDocument)document);
        }
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        super.replace(fb, offset, length, text, attrs);
        this.correctExceptionIndicies(offset, text.length() - length);
        Document document = fb.getDocument();
        if (document instanceof StyledDocument) {
            this.recolor((StyledDocument)document);
        }
    }

    private void recolor(StyledDocument doc) {
        this.doc = doc;
        this.recolor();
    }

    public void recolor() {
        String text;
        if (this.doc == null) {
            return;
        }
        try {
            text = this.doc.getText(0, this.doc.getLength());
        }
        catch (BadLocationException ex) {
            throw new RuntimeException("Encountered unexpected BadLocationException in MplSyntaxFilter", ex);
        }
        this.resetStyling();
        this.colorTokens(text);
        this.colorWarnings();
        this.colorErrors();
    }

    private void resetStyling() {
        this.doc.setCharacterAttributes(0, this.doc.getLength(), this.getDefaultStyle(), true);
    }

    private void correctExceptionIndicies(int startIndex, int offset) {
        MplSyntaxFilterPM pModel = this.getPresentationModel();
        if (pModel == null) {
            return;
        }
        List<MplSyntaxFilterPM.CompilerExceptionWrapper> exceptions = pModel.getErrors();
        if (exceptions == null) {
            return;
        }
        for (MplSyntaxFilterPM.CompilerExceptionWrapper ex : exceptions) {
            if (ex.getStartIndex() >= startIndex) {
                ex.addStartOffset(offset);
            }
            if (ex.getStopIndex() < startIndex) continue;
            ex.addStopOffset(offset);
        }
    }

    private void colorErrors() {
        MplSyntaxFilterPM pModel = this.getPresentationModel();
        if (pModel != null) {
            List<MplSyntaxFilterPM.CompilerExceptionWrapper> errors = pModel.getErrors();
            for (MplSyntaxFilterPM.CompilerExceptionWrapper ex : errors) {
                this.styleToken(ex.getStartIndex(), ex.getStopIndex(), this.getErrorAttributes(), false);
            }
        }
    }

    private void colorWarnings() {
        MplSyntaxFilterPM pModel = this.getPresentationModel();
        if (pModel != null) {
            List<MplSyntaxFilterPM.CompilerExceptionWrapper> warnings = pModel.getWarnings();
            for (MplSyntaxFilterPM.CompilerExceptionWrapper ex : warnings) {
                this.styleToken(ex.getStartIndex(), ex.getStopIndex(), this.getWarningAttributes(), false);
            }
        }
    }

    public void colorTokens(String text) {
        MplLexer lexer = new MplLexer((CharStream)new ANTLRInputStream(text));
        block13: while (true) {
            Token token = lexer.nextToken();
            switch (token.getType()) {
                case -1: {
                    break block13;
                }
                case 23: 
                case 26: {
                    this.styleToken(token, this.getLowFocusKeywordStyle());
                    continue block13;
                }
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 24: 
                case 25: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 43: 
                case 44: {
                    this.styleToken(token, this.getHighFocusKeywordStyle());
                    continue block13;
                }
                case 20: {
                    this.styleToken(token, this.getImpulseStyle());
                    continue block13;
                }
                case 21: {
                    this.styleToken(token, this.getChainStyle());
                    continue block13;
                }
                case 22: 
                case 39: 
                case 40: 
                case 41: 
                case 42: {
                    this.styleToken(token, this.getRepeatStyle());
                    continue block13;
                }
                case 27: {
                    this.styleToken(token, this.getNeedsRedstoneStyle());
                    continue block13;
                }
                case 51: {
                    this.styleToken(token, this.getIdentifierStyle());
                    continue block13;
                }
                case 1: 
                case 45: 
                case 47: 
                case 48: 
                case 49: 
                case 52: {
                    this.styleToken(token, this.getDefaultStyle());
                    continue block13;
                }
                case 54: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: {
                    this.styleToken(token, this.getInsertStyle());
                    continue block13;
                }
                case 8: 
                case 9: {
                    this.styleToken(token, this.getCommentStyle());
                    continue block13;
                }
                default: {
                    this.styleToken(token, this.getDefaultStyle());
                    continue block13;
                }
            }
            break;
        }
    }

    private void styleToken(Token token, AttributeSet style) {
        this.styleToken(token, style, true);
    }

    private void styleToken(Token token, AttributeSet style, boolean replace) {
        this.styleToken(token.getStartIndex(), token.getStopIndex() + 1, style, replace);
    }

    private void styleToken(int start, int stop, AttributeSet style, boolean replace) {
        int length = stop - start;
        this.doc.setCharacterAttributes(start, length, style, replace);
    }

    private Style getDefaultStyle() {
        return this.doc.getStyle("default");
    }

    private Style getLowFocusKeywordStyle() {
        Style lowFocusKeywordStyle = this.doc.getStyle("lowFocusKeyword");
        if (lowFocusKeywordStyle == null) {
            lowFocusKeywordStyle = this.doc.addStyle("lowFocusKeyword", this.getDefaultStyle());
            StyleConstants.setBold(lowFocusKeywordStyle, true);
            StyleConstants.setForeground(lowFocusKeywordStyle, new Color(128, 128, 128));
        }
        return lowFocusKeywordStyle;
    }

    private Style getHighFocusKeywordStyle() {
        Style highFocusKeywordStyle = this.doc.getStyle("highFocusKeyword");
        if (highFocusKeywordStyle == null) {
            highFocusKeywordStyle = this.doc.addStyle("highFocusKeyword", this.getDefaultStyle());
            StyleConstants.setBold(highFocusKeywordStyle, true);
            StyleConstants.setForeground(highFocusKeywordStyle, new Color(128, 0, 0));
        }
        return highFocusKeywordStyle;
    }

    private Style getImpulseStyle() {
        Style impulseStyle = this.doc.getStyle("impulse");
        if (impulseStyle == null) {
            impulseStyle = this.doc.addStyle("impulse", this.getDefaultStyle());
            StyleConstants.setBold(impulseStyle, true);
            StyleConstants.setForeground(impulseStyle, new Color(255, 127, 80));
        }
        return impulseStyle;
    }

    private Style getChainStyle() {
        Style chainStyle = this.doc.getStyle("chain");
        if (chainStyle == null) {
            chainStyle = this.doc.addStyle("chain", this.getDefaultStyle());
            StyleConstants.setBold(chainStyle, true);
            StyleConstants.setForeground(chainStyle, new Color(60, 179, 113));
        }
        return chainStyle;
    }

    private Style getRepeatStyle() {
        Style repeatStyle = this.doc.getStyle("repeat");
        if (repeatStyle == null) {
            repeatStyle = this.doc.addStyle("repeat", this.getDefaultStyle());
            StyleConstants.setBold(repeatStyle, true);
            StyleConstants.setForeground(repeatStyle, new Color(106, 90, 205));
        }
        return repeatStyle;
    }

    private Style getNeedsRedstoneStyle() {
        Style needsRedstoneStyle = this.doc.getStyle("needsRedstone");
        if (needsRedstoneStyle == null) {
            needsRedstoneStyle = this.doc.addStyle("needsRedstone", this.getDefaultStyle());
            StyleConstants.setBold(needsRedstoneStyle, true);
            StyleConstants.setForeground(needsRedstoneStyle, Color.RED);
        }
        return needsRedstoneStyle;
    }

    private Style getIdentifierStyle() {
        Style identifierStyle = this.doc.getStyle("identifier");
        if (identifierStyle == null) {
            identifierStyle = this.doc.addStyle("identifier", this.getDefaultStyle());
            StyleConstants.setBold(identifierStyle, true);
            StyleConstants.setForeground(identifierStyle, new Color(128, 128, 0));
        }
        return identifierStyle;
    }

    private Style getCommentStyle() {
        Style commentStyle = this.doc.getStyle("comment");
        if (commentStyle == null) {
            commentStyle = this.doc.addStyle("comment", this.getDefaultStyle());
            StyleConstants.setForeground(commentStyle, new Color(0, 128, 0));
        }
        return commentStyle;
    }

    private Style getInsertStyle() {
        Style insertStyle = this.doc.getStyle("insert");
        if (insertStyle == null) {
            insertStyle = this.doc.addStyle("insert", this.getDefaultStyle());
            StyleConstants.setForeground(insertStyle, new Color(128, 0, 0));
            StyleConstants.setBackground(insertStyle, new Color(240, 230, 140));
        }
        return insertStyle;
    }

    private Style getErrorAttributes() {
        Style errorStyle = this.doc.getStyle("error");
        if (errorStyle == null) {
            errorStyle = this.doc.addStyle("error", this.getDefaultStyle());
            StyleConstants.setUnderline(errorStyle, true);
            errorStyle.addAttribute(BnJaggedEditorKit.JaggedLabelView.UnderlineColor, Color.RED);
        }
        return errorStyle;
    }

    private Style getWarningAttributes() {
        Style warningStyle = this.doc.getStyle("warning");
        if (warningStyle == null) {
            warningStyle = this.doc.addStyle("warning", this.getDefaultStyle());
            StyleConstants.setUnderline(warningStyle, true);
            warningStyle.addAttribute(BnJaggedEditorKit.JaggedLabelView.UnderlineColor, new Color(255, 215, 0));
        }
        return warningStyle;
    }

    protected ModelProvider getLocalModelProvider() {
        if (this.localModelProvider == null) {
            this.localModelProvider = new ModelProvider();
            this.localModelProvider.setPresentationModelType(MplSyntaxFilterPM.class);
        }
        return this.localModelProvider;
    }

    public MplSyntaxFilterPM getPresentationModel() {
        return (MplSyntaxFilterPM)this.getLocalModelProvider().getPresentationModel();
    }

    public void setPresentationModel(MplSyntaxFilterPM pModel) {
        this.getLocalModelProvider().setPresentationModel((PresentationModel)pModel);
    }

    public IModelProvider getModelProvider() {
        return this.link.getModelProvider();
    }

    public void setModelProvider(IModelProvider modelProvider) {
        this.link.setModelProvider(modelProvider);
    }

    public Path getPath() {
        return this.link.getPath();
    }

    public void setPath(Path path) {
        this.link.setPath(path);
    }
}

