/*
 * Decompiled with CFR 0.152.
 */
package de.adrodoc55.minecraft.mpl.ide.gui;

import com.google.common.collect.ImmutableListMultimap;
import de.adrodoc55.commons.FileUtils;
import de.adrodoc55.minecraft.mpl.compilation.CompilationFailedException;
import de.adrodoc55.minecraft.mpl.compilation.CompilerException;
import de.adrodoc55.minecraft.mpl.compilation.CompilerOptions;
import de.adrodoc55.minecraft.mpl.compilation.MplCompilationResult;
import de.adrodoc55.minecraft.mpl.conversion.CbseConverter;
import de.adrodoc55.minecraft.mpl.conversion.CommandConverter;
import de.adrodoc55.minecraft.mpl.conversion.MplConverter;
import de.adrodoc55.minecraft.mpl.conversion.PythonConverter;
import de.adrodoc55.minecraft.mpl.conversion.SchematicConverter;
import de.adrodoc55.minecraft.mpl.conversion.StructureConverter;
import de.adrodoc55.minecraft.mpl.ide.gui.MplEditor;
import de.adrodoc55.minecraft.mpl.ide.gui.MplEditorPM;
import de.adrodoc55.minecraft.mpl.ide.gui.dialog.compilerexception.ExceptionDialog;
import de.adrodoc55.minecraft.mpl.ide.gui.dialog.compileroptions.CompilerOptionsDialog;
import de.adrodoc55.minecraft.mpl.ide.gui.dialog.compileroptions.CompilerOptionsDialogController;
import de.adrodoc55.minecraft.mpl.ide.gui.dialog.compileroptions.CompilerOptionsDialogPM;
import de.adrodoc55.minecraft.mpl.ide.gui.dialog.content.MultiContentDialog;
import de.adrodoc55.minecraft.mpl.ide.gui.dialog.content.MultiContentDialogController;
import de.adrodoc55.minecraft.mpl.ide.gui.dialog.content.MultiContentDialogPM;
import de.adrodoc55.minecraft.mpl.ide.gui.dialog.searchandreplace.SearchAndReplaceDialogController;
import de.adrodoc55.minecraft.mpl.ide.gui.dialog.searchandreplace.SearchAndReplaceDialogPM;
import de.adrodoc55.minecraft.mpl.ide.gui.dialog.unsaved.UnsavedResourcesDialog;
import de.adrodoc55.minecraft.mpl.ide.gui.dialog.unsaved.UnsavedResourcesDialogPM;
import de.adrodoc55.minecraft.mpl.version.MinecraftVersion;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.text.JTextComponent;
import org.beanfabrics.model.AbstractPM;
import org.beanfabrics.model.ListPM;
import org.beanfabrics.model.OperationPM;
import org.beanfabrics.model.PMManager;
import org.beanfabrics.model.PresentationModel;
import org.beanfabrics.model.Selection;
import org.beanfabrics.support.Operation;

public class MplFramePM
extends AbstractPM {
    public static final String COMPILE_TO_COMMAND = "Compile to Command";
    public static final String COMPILE_TO_STRUCTURE = "Compile to Structure";
    public static final String COMPILE_TO_SCHEMATIC = "Compile to Schematic";
    public static final String COMPILE_TO_CBSE = "Compile to Command Block Structure Editor File";
    public static final String COMPILE_TO_FILTER = "Compile to MCEdit Filter";
    final ListPM<MplEditorPM> editors = new ListPM();
    final OperationPM newFile = new OperationPM();
    final OperationPM openFile = new OperationPM();
    final OperationPM saveFile = new OperationPM();
    final OperationPM saveFileUnder = new OperationPM();
    final OperationPM compileToCommand = new OperationPM();
    final OperationPM compileToStructure = new OperationPM();
    final OperationPM compileToStructureUnder = new OperationPM();
    final OperationPM compileToSchematic = new OperationPM();
    final OperationPM compileToSchematicUnder = new OperationPM();
    final OperationPM compileToCbse = new OperationPM();
    final OperationPM compileToFilter = new OperationPM();
    final OperationPM compileToFilterUnder = new OperationPM();
    final OperationPM openOptionsDialog = new OperationPM();
    private final CompilerOptionsDialogController optionCtrl = new CompilerOptionsDialogController();
    SearchAndReplaceDialogController sarController = new SearchAndReplaceDialogController(new SearchAndReplaceDialogPM.Context(){

        @Override
        public JTextComponent getComponent() {
            MplEditorPM selected = (MplEditorPM)MplFramePM.this.editors.getSelection().getFirst();
            MplEditor view = selected.getView();
            if (view == null) {
                return null;
            }
            return view.getTextPane();
        }
    });
    private File compilationDir;

    public MplFramePM() {
        this.newFile.setDescription("Create a new file");
        this.openFile.setDescription("Open a file");
        this.saveFile.setDescription("Save the current file");
        this.compileToCommand.setDescription(COMPILE_TO_COMMAND);
        this.compileToStructure.setDescription(COMPILE_TO_STRUCTURE);
        this.compileToStructureUnder.setDescription(COMPILE_TO_STRUCTURE);
        this.compileToSchematic.setDescription(COMPILE_TO_SCHEMATIC);
        this.compileToSchematicUnder.setDescription(COMPILE_TO_SCHEMATIC);
        this.compileToCbse.setDescription(COMPILE_TO_CBSE);
        this.compileToFilter.setDescription(COMPILE_TO_FILTER);
        this.compileToFilterUnder.setDescription(COMPILE_TO_FILTER);
        PMManager.setup((PresentationModel)this);
    }

    @Operation
    public void newFile() {
        MplEditorPM editorPm = new MplEditorPM(this.createEditorContext());
        this.addMplEditorPm(editorPm);
    }

    @Operation
    public void openFile() {
        Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        JFileChooser chooser = MplEditor.getMplChooser();
        int userAction = chooser.showOpenDialog(activeWindow);
        if (userAction != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        if (!file.exists()) {
            String message = "The File '" + file.getPath() + "' couldn't be found!";
            JOptionPane.showMessageDialog(chooser, message, "Error", 0);
            this.openFile();
            return;
        }
        if (!file.isFile()) {
            String message = file.getPath() + " is not a File!";
            JOptionPane.showMessageDialog(chooser, message, "Error", 0);
            this.openFile();
            return;
        }
        if (!file.canRead()) {
            String message = "The File '" + file.getPath() + "' couldn't be opened!";
            JOptionPane.showMessageDialog(chooser, message, "Error", 0);
            this.openFile();
            return;
        }
        for (MplEditorPM editorPm : this.editors) {
            if (!file.equals(editorPm.getFile())) continue;
            Selection selection = this.editors.getSelection();
            selection.clear();
            selection.add((Object)editorPm);
            return;
        }
        try {
            MplEditorPM editorPm = new MplEditorPM(this.createEditorContext());
            editorPm.setFile(file);
            editorPm.load();
            this.addMplEditorPm(editorPm);
            editorPm.setUnsavedChanges(false);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            String message = "The File '" + file.getPath() + "' couldn't be loaded!\n" + ex.getMessage();
            String title = ex.getClass().getSimpleName();
            JOptionPane.showMessageDialog(chooser, message, title, 0);
            this.openFile();
        }
    }

    private void addMplEditorPm(MplEditorPM editorPm) {
        this.editors.add((PresentationModel)editorPm);
        this.editors.getSelection().clear();
        this.editors.getSelection().add((Object)editorPm);
    }

    @Operation
    public void saveFile() {
        MplEditorPM selected = (MplEditorPM)this.editors.getSelection().getFirst();
        if (selected == null) {
            return;
        }
        selected.save();
    }

    @Operation
    public void saveFileUnder() {
        MplEditorPM selected = (MplEditorPM)this.editors.getSelection().getFirst();
        if (selected == null) {
            return;
        }
        selected.saveUnder();
    }

    @Operation
    public void compileToCommand() {
        MplCompilationResult result = this.compile();
        if (result == null) {
            return;
        }
        CompilerOptionsDialogPM optionPm = (CompilerOptionsDialogPM)((Object)this.optionCtrl.getPresentationModel());
        MinecraftVersion version = optionPm.getSavedVersion();
        List commands = CommandConverter.convert((MplCompilationResult)result, (MinecraftVersion)version);
        MultiContentDialogController ctrl = new MultiContentDialogController("Import Commands");
        MultiContentDialogPM pm = (MultiContentDialogPM)((Object)ctrl.getPresentationModel());
        MultiContentDialog view = (MultiContentDialog)ctrl.getView();
        pm.setContents(commands);
        view.setVisible(true);
    }

    @Operation
    public void compileToStructure() {
        File dir = this.getCompilationDir(COMPILE_TO_STRUCTURE);
        if (dir == null) {
            return;
        }
        this.compileTo((MplConverter)new StructureConverter(), dir, ".nbt");
    }

    @Operation
    public void compileToStructureUnder() {
        this.chooseCompilationDir(COMPILE_TO_STRUCTURE);
        this.compileToSchematic();
    }

    @Operation
    public void compileToSchematic() {
        File dir = this.getCompilationDir(COMPILE_TO_SCHEMATIC);
        if (dir == null) {
            return;
        }
        this.compileTo((MplConverter)new SchematicConverter(), dir, ".schematic");
    }

    @Operation
    public void compileToSchematicUnder() {
        this.chooseCompilationDir(COMPILE_TO_SCHEMATIC);
        this.compileToSchematic();
    }

    @Operation
    public void compileToCbse() {
        MplCompilationResult result = this.compile();
        if (result == null) {
            return;
        }
        String cbse = CbseConverter.convert((MplCompilationResult)result);
        MultiContentDialogController ctrl = new MultiContentDialogController("Command block structure editor");
        MultiContentDialogPM pm = (MultiContentDialogPM)((Object)ctrl.getPresentationModel());
        MultiContentDialog view = (MultiContentDialog)ctrl.getView();
        pm.setContents(Arrays.asList(cbse));
        view.setVisible(true);
    }

    @Operation
    public void compileToFilter() {
        File dir = this.getCompilationDir(COMPILE_TO_FILTER);
        if (dir == null) {
            return;
        }
        this.compileTo((MplConverter)new PythonConverter(), dir, ".py");
    }

    @Operation
    public void compileToFilterUnder() {
        this.chooseCompilationDir(COMPILE_TO_FILTER);
        this.compileToFilter();
    }

    public void compileTo(MplConverter converter, File dir, String fileEnding) {
        try {
            MplCompilationResult result = this.compile();
            if (result == null) {
                return;
            }
            MplEditorPM selected = (MplEditorPM)this.editors.getSelection().getFirst();
            if (selected == null) {
                return;
            }
            String name = FileUtils.getFilenameWithoutExtension((String)selected.getTitle());
            String targetFileName = name + fileEnding;
            File outputFile = new File(dir, targetFileName);
            outputFile.getParentFile().mkdirs();
            outputFile.createNewFile();
            try (FileOutputStream out = new FileOutputStream(outputFile);){
                CompilerOptionsDialogPM optionPm = (CompilerOptionsDialogPM)((Object)this.optionCtrl.getPresentationModel());
                MinecraftVersion version = optionPm.getSavedVersion();
                converter.write(result, name, (OutputStream)out, version);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            JOptionPane.showMessageDialog(activeWindow, ex.getMessage(), ex.getClass().getSimpleName(), 0);
        }
    }

    private MplCompilationResult compile() {
        if (this.warnAboutUnsavedResources()) {
            return null;
        }
        MplEditorPM selected = (MplEditorPM)this.editors.getSelection().getFirst();
        if (selected == null) {
            return null;
        }
        try {
            return this.compile(selected);
        }
        catch (CompilationFailedException ex) {
            ExceptionDialog dialog = ExceptionDialog.create("Compilation Failed!", "The Compiler encountered Errors!", ex.toString());
            dialog.setVisible(true);
            return null;
        }
    }

    private MplCompilationResult compile(MplEditorPM selected) throws CompilationFailedException {
        try {
            CompilerOptionsDialogPM optionPm = (CompilerOptionsDialogPM)((Object)this.optionCtrl.getPresentationModel());
            MinecraftVersion version = optionPm.getSavedVersion();
            CompilerOptions options = optionPm.getSavedOptions();
            MplCompilationResult result = selected.compile(version, options);
            for (MplEditorPM editor : this.editors) {
                editor.setErrors(Collections.emptyList());
                editor.setWarnings(Collections.emptyList());
            }
            ImmutableListMultimap warnings = result.getWarnings();
            for (File programFile : warnings.keySet()) {
                for (MplEditorPM editor : this.editors) {
                    if (!programFile.equals(editor.getFile())) continue;
                    editor.setWarnings((List<CompilerException>)warnings.get((Object)programFile));
                }
            }
            return result;
        }
        catch (CompilationFailedException ex) {
            ImmutableListMultimap errors = ex.getErrors();
            for (File programFile : errors.keySet()) {
                for (MplEditorPM editor : this.editors) {
                    if (!programFile.equals(editor.getFile())) continue;
                    editor.setErrors((List<CompilerException>)errors.get((Object)programFile));
                }
            }
            throw ex;
        }
    }

    private File getCompilationDir(String title) {
        if (this.compilationDir == null) {
            this.chooseCompilationDir(title);
        }
        return this.compilationDir;
    }

    private void chooseCompilationDir(String title) {
        Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        JFileChooser chooser = MplEditor.getDirChooser();
        int userAction = chooser.showDialog(activeWindow, title);
        if (userAction == 0) {
            this.compilationDir = chooser.getSelectedFile();
        }
    }

    private boolean warnAboutUnsavedResources() {
        this.checkFiles();
        LinkedList<MplEditorPM> unsaved = new LinkedList<MplEditorPM>();
        for (MplEditorPM editorPm : this.editors) {
            if (!editorPm.hasUnsavedChanges() || !MplFramePM.isRelevant(editorPm)) continue;
            unsaved.add(editorPm);
        }
        if (!unsaved.isEmpty()) {
            return this.showUnsavedResourcesDialog(unsaved);
        }
        return false;
    }

    void checkFiles() {
        for (MplEditorPM editorPm : this.editors) {
            editorPm.checkFile();
        }
    }

    private MplEditorPM.Context createEditorContext() {
        return new MplEditorPM.Context(){

            @Override
            public void close(MplEditorPM editorPm) {
                if (editorPm.hasUnsavedChanges() && MplFramePM.isRelevant(editorPm)) {
                    ArrayList<MplEditorPM> unsaved = new ArrayList<MplEditorPM>(1);
                    unsaved.add(editorPm);
                    if (MplFramePM.this.showUnsavedResourcesDialog(unsaved)) {
                        return;
                    }
                }
                MplFramePM.this.editors.remove((PresentationModel)editorPm);
            }

            @Override
            public SearchAndReplaceDialogController getSearchAndReplaceController() {
                return MplFramePM.this.sarController;
            }

            @Override
            public void compile(MplEditorPM mplEditorPM) {
                try {
                    MplFramePM.this.compile(mplEditorPM);
                }
                catch (CompilationFailedException compilationFailedException) {
                    // empty catch block
                }
            }
        };
    }

    private static boolean isRelevant(MplEditorPM editorPm) {
        return !editorPm.code.isEmpty() || editorPm.getFile() != null;
    }

    private boolean showUnsavedResourcesDialog(Collection<MplEditorPM> unsaved) {
        Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        UnsavedResourcesDialog dialog = new UnsavedResourcesDialog(activeWindow);
        UnsavedResourcesDialogPM dialogPm = new UnsavedResourcesDialogPM(unsaved);
        dialog.setPresentationModel(dialogPm);
        dialog.setVisible(true);
        return dialogPm.isCanceled();
    }

    @Operation
    public void openOptionsDialog() {
        ((CompilerOptionsDialog)this.optionCtrl.getView()).setVisible(true);
    }

    public void terminate() {
        if (this.warnAboutUnsavedResources()) {
            return;
        }
        System.exit(0);
    }
}

