/*
 * Decompiled with CFR 0.152.
 */
package de.adrodoc55.minecraft.mpl.ide.gui;

import de.adrodoc55.commons.FileUtils;
import de.adrodoc55.minecraft.mpl.compilation.CompilationFailedException;
import de.adrodoc55.minecraft.mpl.compilation.CompilerException;
import de.adrodoc55.minecraft.mpl.compilation.CompilerOptions;
import de.adrodoc55.minecraft.mpl.compilation.MplCompilationResult;
import de.adrodoc55.minecraft.mpl.compilation.MplCompiler;
import de.adrodoc55.minecraft.mpl.ide.gui.MplEditor;
import de.adrodoc55.minecraft.mpl.ide.gui.MplSyntaxFilterPM;
import de.adrodoc55.minecraft.mpl.ide.gui.dialog.searchandreplace.SearchAndReplaceDialog;
import de.adrodoc55.minecraft.mpl.ide.gui.dialog.searchandreplace.SearchAndReplaceDialogController;
import de.adrodoc55.minecraft.mpl.ide.gui.dialog.searchandreplace.SearchAndReplaceDialogPM;
import de.adrodoc55.minecraft.mpl.ide.gui.editor.EditorPM;
import de.adrodoc55.minecraft.mpl.version.MinecraftVersion;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.JTextComponent;
import org.beanfabrics.model.AbstractPM;
import org.beanfabrics.model.BooleanPM;
import org.beanfabrics.model.OperationPM;
import org.beanfabrics.model.PMManager;
import org.beanfabrics.model.PresentationModel;
import org.beanfabrics.model.TextPM;
import org.beanfabrics.support.Operation;

public class MplEditorPM
extends AbstractPM
implements EditorPM {
    private static JFileChooser chooser;
    private static FileFilter filter;
    final TextPM title = new TextPM();
    final OperationPM close = new OperationPM();
    final BooleanPM unsavedChanges = new BooleanPM();
    final MplSyntaxFilterPM syntaxFilter = new MplSyntaxFilterPM();
    final TextPM code = new TextPM();
    private File file;
    private final Context context;
    private MplEditor view;
    private static int i;

    private static JFileChooser getFileChooser() {
        if (chooser == null) {
            chooser = new JFileChooser();
        }
        return chooser;
    }

    public static JFileChooser getDirChooser() {
        JFileChooser chooser = MplEditorPM.getFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setFileFilter(null);
        FileFilter filter = MplEditorPM.getFileFilter();
        chooser.removeChoosableFileFilter(filter);
        return chooser;
    }

    public static JFileChooser getMplChooser() {
        JFileChooser chooser = MplEditorPM.getFileChooser();
        chooser.setFileSelectionMode(0);
        FileFilter filter = MplEditorPM.getFileFilter();
        chooser.setFileFilter(filter);
        chooser.addChoosableFileFilter(filter);
        return chooser;
    }

    private static FileFilter getFileFilter() {
        if (filter == null) {
            filter = new FileNameExtensionFilter("Minecraft Programming Language", "mpl");
        }
        return filter;
    }

    public MplEditorPM(Context context) throws NullPointerException {
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        this.context = context;
        this.title.setEditable(false);
        this.title.setText("new" + i++ + ".mpl");
        this.code.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MplEditorPM.this.setUnsavedChanges(true);
            }
        });
        this.setUnsavedChanges(true);
        PMManager.setup((PresentationModel)this);
    }

    @Operation
    private void close() {
        this.context.close(this);
    }

    public String getTitle() {
        return this.title.getText();
    }

    public void setTitle(String title) {
        this.title.setText(title);
    }

    public boolean hasUnsavedChanges() {
        return this.unsavedChanges.getBoolean();
    }

    public void setUnsavedChanges(boolean unsavedChanges) {
        this.unsavedChanges.setBoolean(Boolean.valueOf(unsavedChanges));
    }

    public void setErrors(List<CompilerException> errors) {
        this.syntaxFilter.setErrors(errors);
    }

    public void setWarnings(List<CompilerException> warnings) {
        this.syntaxFilter.setWarnings(warnings);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
        this.setTitle(file.getName());
    }

    public void checkFile() {
        if (this.file == null) {
            return;
        }
        if (this.hasUnsavedChanges()) {
            return;
        }
        if (!this.file.exists()) {
            this.setUnsavedChanges(true);
        }
    }

    public void load() throws IOException {
        if (this.file == null) {
            return;
        }
        byte[] bytes = Files.readAllBytes(this.file.toPath());
        String content = FileUtils.toUnixLineEnding((String)new String(bytes));
        this.code.setText(content);
        this.setUnsavedChanges(false);
    }

    @Override
    public void save() {
        if (this.file == null) {
            this.saveUnder();
        } else {
            try {
                this.file.getParentFile().mkdirs();
                byte[] bytes = this.code.getText().getBytes();
                Files.write(this.file.toPath(), bytes, new OpenOption[0]);
                this.setUnsavedChanges(false);
                this.context.compile(this);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
                String path = this.file != null ? this.file.getPath() : null;
                JOptionPane.showMessageDialog(activeWindow, "An Exception occured while trying to save to '" + path + "'. Exception: " + ex.getMessage(), "Error", 0);
            }
        }
    }

    public void saveUnder() {
        int overwrite;
        Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        JFileChooser chooser = MplEditorPM.getMplChooser();
        chooser.setSelectedFile(new File(chooser.getCurrentDirectory(), this.getTitle()));
        int userAction = chooser.showSaveDialog(activeWindow);
        if (userAction != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        if (!file.getName().endsWith(".mpl")) {
            file = new File(file.getAbsolutePath() + ".mpl");
        }
        if (file.exists() && (overwrite = JOptionPane.showOptionDialog(activeWindow, "The File '" + file.getName() + "' already exists and will be overwritten.", "Save...", 2, 2, null, null, null)) != 0) {
            this.saveUnder();
            return;
        }
        this.setFile(file);
        this.save();
    }

    public MplCompilationResult compile(MinecraftVersion version, CompilerOptions options) throws CompilationFailedException {
        File file = this.getFile();
        if (file == null || !file.exists()) {
            Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            JOptionPane.showMessageDialog(activeWindow, "You need to save this File before it can be compiled!", "Compilation Failed!", 0);
            return null;
        }
        try {
            return MplCompiler.compile((File)file, (MinecraftVersion)version, (CompilerOptions)options);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            JOptionPane.showMessageDialog(activeWindow, ex.getMessage(), ex.getClass().getSimpleName(), 0);
            return null;
        }
    }

    public void searchAndReplace() {
        String selected;
        SearchAndReplaceDialogController ctrl = this.context.getSearchAndReplaceController();
        SearchAndReplaceDialogPM pm = (SearchAndReplaceDialogPM)((Object)ctrl.getPresentationModel());
        JTextComponent component = pm.getComponent();
        if (component != null && (selected = component.getSelectedText()) != null) {
            pm.setSearch(selected);
        }
        ((SearchAndReplaceDialog)ctrl.getView()).setVisible(true);
    }

    MplEditor getView() {
        return this.view;
    }

    void setView(MplEditor view) {
        this.view = view;
    }

    public static interface Context {
        public void close(MplEditorPM var1);

        public SearchAndReplaceDialogController getSearchAndReplaceController();

        public void compile(MplEditorPM var1);
    }
}

