/*
 * Decompiled with CFR 0.152.
 */
package de.adrodoc55.minecraft.mpl.ide.autocompletion;

import de.adrodoc55.minecraft.mpl.antlr.MplParser;
import de.adrodoc55.minecraft.mpl.antlr.MplParserBaseListener;
import de.adrodoc55.minecraft.mpl.ide.autocompletion.AutoCompletionContext;
import de.adrodoc55.minecraft.mpl.ide.autocompletion.ResultException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.TerminalNode;

public class AutoCompletionListener
extends MplParserBaseListener {
    private final int index;
    private final AutoCompletionContext result = new AutoCompletionContext();

    public AutoCompletionListener(int index) {
        this.index = index;
    }

    public void enterProjectFile(MplParser.ProjectFileContext ctx) {
        this.result.setProject(true);
    }

    public void enterScriptFile(MplParser.ScriptFileContext ctx) {
        this.result.setProject(false);
    }

    public void enterProject(MplParser.ProjectContext ctx) {
        this.result.setInProject(true);
    }

    public void exitProject(MplParser.ProjectContext ctx) {
        this.result.setInProject(false);
    }

    public void enterProcess(MplParser.ProcessContext ctx) {
        this.result.setInProcess(true);
    }

    public void exitProcess(MplParser.ProcessContext ctx) {
        this.result.setInProcess(false);
    }

    public void visitErrorNode(ErrorNode node) {
        this.visitNode((TerminalNode)node);
    }

    public void visitTerminal(TerminalNode node) {
        this.visitNode(node);
    }

    protected void visitNode(TerminalNode node) {
        Token token = node.getSymbol();
        if (token == null || this.index > token.getStopIndex() + 1) {
            return;
        }
        if (this.index < token.getStartIndex() || token.getType() == -1) {
            token = null;
        }
        this.result.setToken(token);
        throw new ResultException(this.result);
    }
}

