/*
 * Decompiled with CFR 0.152.
 */
package de.adrodoc55.commons;

import java.util.Arrays;

public class TabToSpaceConverter {
    protected TabToSpaceConverter() throws Exception {
        throw new Exception("Utils Classes cannot be instantiated!");
    }

    public static String convertTabsToSpaces(String text) {
        return TabToSpaceConverter.convertTabsToSpaces(0, 4, text);
    }

    public static String convertTabsToSpaces(int tabWidth, String text) {
        return TabToSpaceConverter.convertTabsToSpaces(0, tabWidth, text);
    }

    public static String convertTabsToSpaces(int offset, int tabWidth, String text) {
        StringBuilder sb = new StringBuilder(text.length());
        int afterLastNlIndex = -offset;
        int afterLastTabIndex = 0;
        char[] textArray = text.toCharArray();
        for (int i = 0; i < textArray.length; ++i) {
            int spaceCount;
            if (textArray[i] == '\r' || textArray[i] == '\n') {
                afterLastNlIndex = i + 1;
                continue;
            }
            if (textArray[i] != '\t') continue;
            sb.append(Arrays.copyOfRange(textArray, afterLastTabIndex, i));
            for (int s = spaceCount = tabWidth - (i - afterLastNlIndex) % tabWidth; s > 0; --s) {
                sb.append(' ');
            }
            afterLastTabIndex = i + 1;
            afterLastNlIndex -= spaceCount - 1;
        }
        sb.append(Arrays.copyOfRange(textArray, afterLastTabIndex, textArray.length));
        return sb.toString();
    }
}

