/*
 * Decompiled with CFR 0.152.
 */
package de.adrodoc55.commons;

public class StringUnescaper {
    protected StringUnescaper() throws Exception {
        throw new Exception("Utils Classes cannot be instantiated!");
    }

    public static final String unescape_perl_string(String oldstr) {
        StringBuffer newstr = new StringBuffer(oldstr.length());
        boolean saw_backslash = false;
        for (int i = 0; i < oldstr.length(); ++i) {
            int cp = oldstr.codePointAt(i);
            if (oldstr.codePointAt(i) > 65535) {
                ++i;
            }
            if (!saw_backslash) {
                if (cp == 92) {
                    saw_backslash = true;
                    continue;
                }
                newstr.append(Character.toChars(cp));
                continue;
            }
            if (cp == 92) {
                saw_backslash = false;
                newstr.append('\\');
                newstr.append('\\');
                continue;
            }
            switch (cp) {
                case 114: {
                    newstr.append('\r');
                    break;
                }
                case 110: {
                    newstr.append('\n');
                    break;
                }
                case 102: {
                    newstr.append('\f');
                    break;
                }
                case 98: {
                    newstr.append("\\b");
                    break;
                }
                case 116: {
                    newstr.append('\t');
                    break;
                }
                case 97: {
                    newstr.append('\u0007');
                    break;
                }
                case 101: {
                    newstr.append('\u001b');
                    break;
                }
                case 99: {
                    if (++i == oldstr.length()) {
                        StringUnescaper.die("trailing \\c");
                    }
                    if ((cp = oldstr.codePointAt(i)) > 127) {
                        StringUnescaper.die("expected ASCII after \\c");
                    }
                    newstr.append(Character.toChars(cp ^ 0x40));
                    break;
                }
                case 56: 
                case 57: {
                    StringUnescaper.die("illegal octal digit");
                }
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    --i;
                }
                case 48: {
                    char ch;
                    int j;
                    if (i + 1 == oldstr.length()) {
                        newstr.append(Character.toChars(0));
                        break;
                    }
                    ++i;
                    int digits = 0;
                    for (j = 0; j <= 2 && i + j != oldstr.length() && (ch = oldstr.charAt(i + j)) >= '0' && ch <= '7'; ++j) {
                        ++digits;
                    }
                    if (digits == 0) {
                        --i;
                        newstr.append('\u0000');
                        break;
                    }
                    int value = 0;
                    try {
                        value = Integer.parseInt(oldstr.substring(i, i + digits), 8);
                    }
                    catch (NumberFormatException nfe) {
                        StringUnescaper.die("invalid octal value for \\0 escape");
                    }
                    newstr.append(Character.toChars(value));
                    i += digits - 1;
                    break;
                }
                case 120: {
                    int j;
                    if (i + 2 > oldstr.length()) {
                        StringUnescaper.die("string too short for \\x escape");
                    }
                    boolean saw_brace = false;
                    if (oldstr.charAt(++i) == '{') {
                        ++i;
                        saw_brace = true;
                    }
                    for (j = 0; j < 8 && (saw_brace || j != 2); ++j) {
                        char ch = oldstr.charAt(i + j);
                        if (ch > '\u007f') {
                            StringUnescaper.die("illegal non-ASCII hex digit in \\x escape");
                        }
                        if (saw_brace && ch == '}') break;
                        if (ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F') continue;
                        StringUnescaper.die(String.format("illegal hex digit #%d '%c' in \\x", ch, (int)ch));
                    }
                    if (j == 0) {
                        StringUnescaper.die("empty braces in \\x{} escape");
                    }
                    int value = 0;
                    try {
                        value = Integer.parseInt(oldstr.substring(i, i + j), 16);
                    }
                    catch (NumberFormatException nfe) {
                        StringUnescaper.die("invalid hex value for \\x escape");
                    }
                    newstr.append(Character.toChars(value));
                    if (saw_brace) {
                        ++j;
                    }
                    i += j - 1;
                    break;
                }
                case 117: {
                    int j;
                    if (++i + 4 > oldstr.length()) {
                        StringUnescaper.die("string too short for \\u escape");
                    }
                    for (j = 0; j < 4; ++j) {
                        if (oldstr.charAt(i + j) <= '\u007f') continue;
                        StringUnescaper.die("illegal non-ASCII hex digit in \\u escape");
                    }
                    int value = 0;
                    try {
                        value = Integer.parseInt(oldstr.substring(i, i + j), 16);
                    }
                    catch (NumberFormatException nfe) {
                        StringUnescaper.die("invalid hex value for \\u escape");
                    }
                    newstr.append(Character.toChars(value));
                    i += j - 1;
                    break;
                }
                case 85: {
                    int j;
                    if (i + 8 > oldstr.length()) {
                        StringUnescaper.die("string too short for \\U escape");
                    }
                    ++i;
                    for (j = 0; j < 8; ++j) {
                        if (oldstr.charAt(i + j) <= '\u007f') continue;
                        StringUnescaper.die("illegal non-ASCII hex digit in \\U escape");
                    }
                    int value = 0;
                    try {
                        value = Integer.parseInt(oldstr.substring(i, i + j), 16);
                    }
                    catch (NumberFormatException nfe) {
                        StringUnescaper.die("invalid hex value for \\U escape");
                    }
                    newstr.append(Character.toChars(value));
                    i += j - 1;
                    break;
                }
                default: {
                    newstr.append('\\');
                    newstr.append(Character.toChars(cp));
                }
            }
            saw_backslash = false;
        }
        if (saw_backslash) {
            newstr.append('\\');
        }
        return newstr.toString();
    }

    public static final String uniplus(String s) {
        if (s.length() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(2 + 3 * s.length());
        sb.append("U+");
        for (int i = 0; i < s.length(); ++i) {
            sb.append(String.format("%X", s.codePointAt(i)));
            if (s.codePointAt(i) > 65535) {
                ++i;
            }
            if (i + 1 >= s.length()) continue;
            sb.append(".");
        }
        return sb.toString();
    }

    private static final void die(String foa) {
        throw new IllegalArgumentException(foa);
    }
}

