/*
 * Decompiled with CFR 0.152.
 */
package de.adrodoc55.minecraft.mpl.ide.gui.utils;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Shape;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.beanfabrics.swing.internal.BnStyledEditorKit;

public class BnJaggedEditorKit
extends BnStyledEditorKit {
    private static final long serialVersionUID = 1L;

    @Override
    public JaggedViewFactory getViewFactory() {
        return new JaggedViewFactory();
    }

    public static class JaggedLabelView
    extends LabelView {
        public static final Object UnderlineColor = "UnderlineColor";

        public JaggedLabelView(Element elem) {
            super(elem);
        }

        @Override
        public void paint(Graphics g, Shape allocation) {
            boolean underline = this.isUnderline();
            if (underline) {
                this.setUnderline(false);
            }
            super.paint(g, allocation);
            if (underline) {
                Object attribute = this.getAttributes().getAttribute(UnderlineColor);
                Color color = attribute instanceof Color ? (Color)attribute : Color.BLACK;
                this.paintJaggedLine(g, allocation, color);
                this.setUnderline(true);
            }
        }

        public void paintJaggedLine(Graphics g, Shape a, Color color) {
            int y = (int)(a.getBounds().getY() + a.getBounds().getHeight());
            int x1 = (int)a.getBounds().getX();
            int x2 = (int)(a.getBounds().getX() + a.getBounds().getWidth());
            Color old = g.getColor();
            g.setColor(color);
            for (int x = x1; x <= x2; ++x) {
                if (x % 2 == 0) {
                    g.drawLine(x, y - 1, x, y - 1);
                    continue;
                }
                if (x % 4 == 1) {
                    g.drawLine(x, y - 2, x, y - 2);
                    continue;
                }
                g.drawLine(x, y, x, y);
            }
            g.setColor(old);
        }
    }

    public static class JaggedViewFactory
    implements ViewFactory {
        @Override
        public View create(Element elem) {
            String kind = elem.getName();
            if (kind != null) {
                if (kind.equals("content")) {
                    return this.createLabelView(elem);
                }
                if (kind.equals("paragraph")) {
                    return new ParagraphView(elem);
                }
                if (kind.equals("section")) {
                    return new BoxView(elem, 1);
                }
                if (kind.equals("component")) {
                    return new ComponentView(elem);
                }
                if (kind.equals("icon")) {
                    return new IconView(elem);
                }
            }
            return new LabelView(elem);
        }

        protected JaggedLabelView createLabelView(Element elem) {
            return new JaggedLabelView(elem);
        }
    }
}

