/*
 * Decompiled with CFR 0.152.
 */
package de.adrodoc55.minecraft.mpl.ide.gui.editor;

import de.adrodoc55.commons.TabToSpaceConverter;
import de.adrodoc55.minecraft.mpl.ide.gui.editor.CaretUpdateEvent;
import de.adrodoc55.minecraft.mpl.ide.gui.editor.ChangeUndoableEdit;
import de.adrodoc55.minecraft.mpl.ide.gui.editor.InsertUndoableEdit;
import de.adrodoc55.minecraft.mpl.ide.gui.editor.RemoveUndoableEdit;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.undo.UndoableEdit;
import org.beanfabrics.swing.internal.BnStyledDocument;

public class UndoableBnStyledDocument
extends BnStyledDocument {
    private static final long serialVersionUID = 1L;
    private final List<UndoableEditListener> listeners = new ArrayList<UndoableEditListener>();
    private int tabWidth;

    public UndoableBnStyledDocument() {
        this(2);
    }

    public UndoableBnStyledDocument(int tabWidth) {
        this.tabWidth = tabWidth;
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public UndoableEditListener[] getUndoableEditListeners() {
        return this.listeners.toArray(new UndoableEditListener[0]);
    }

    protected void fireUndoableEditEvent(UndoableEditEvent e) {
        for (UndoableEditListener listener : this.listeners) {
            listener.undoableEditHappened(e);
        }
    }

    protected void fireUndoableEditEvent(UndoableEdit edit) {
        this.fireUndoableEditEvent(new UndoableEditEvent(this, edit));
    }

    public void submit(UndoableEdit edit) {
        edit.redo();
        this.fireUndoableEditEvent(edit);
    }

    private int getOffsetInLine(int offset) {
        Element root = this.getDefaultRootElement();
        int elementIndex = root.getElementIndex(offset);
        int startOffset = root.getElement(elementIndex).getStartOffset();
        int lineOffset = offset - startOffset;
        return lineOffset;
    }

    @Override
    public void remove(int offset, int length) throws BadLocationException {
        String text = this.getText(offset, length);
        this.submit(new RemoveUndoableEdit(this, offset, text));
    }

    @Override
    public void replace(int offset, int length, String newText, AttributeSet attrs) throws BadLocationException {
        String oldText = this.getText(offset, length);
        int lineOffset = this.getOffsetInLine(offset);
        newText = TabToSpaceConverter.convertTabsToSpaces(lineOffset, this.tabWidth, newText);
        this.submit(new ChangeUndoableEdit(this, offset, oldText, newText, attrs));
    }

    @Override
    public void insertString(int offset, String text, AttributeSet a) throws BadLocationException {
        int lineOffset = this.getOffsetInLine(offset);
        text = TabToSpaceConverter.convertTabsToSpaces(lineOffset, this.tabWidth, text);
        this.submit(new InsertUndoableEdit(this, offset, text, a));
    }

    public void removeSilent(int offs, int len) throws BadLocationException {
        super.remove(offs, len);
    }

    public void replaceSilent(int offs, int len, String text, AttributeSet attrs) throws BadLocationException {
        super.replace(offs, len, text, attrs);
    }

    public void insertStringSilent(int offs, String str, AttributeSet a) throws BadLocationException {
        super.insertString(offs, str, a);
    }

    @Override
    protected void fireRemoveUpdate(DocumentEvent e) {
        super.fireRemoveUpdate(e);
    }

    @Override
    protected void fireChangedUpdate(DocumentEvent e) {
        super.fireChangedUpdate(e);
    }

    @Override
    protected void fireInsertUpdate(DocumentEvent e) {
        super.fireInsertUpdate(e);
    }

    public class MyCaretUpdateEvent
    extends AbstractDocument.DefaultDocumentEvent
    implements CaretUpdateEvent {
        private static final long serialVersionUID = 1L;

        public MyCaretUpdateEvent(int offs, int len, DocumentEvent.EventType type) {
            super(UndoableBnStyledDocument.this, offs, len, type);
        }
    }
}

