/*
 * Decompiled with CFR 0.152.
 */
package de.adrodoc55.minecraft.mpl.ide.gui.editor;

import com.google.common.base.Preconditions;
import de.adrodoc55.minecraft.mpl.ide.gui.editor.AbstractUndoableBnEdit;
import de.adrodoc55.minecraft.mpl.ide.gui.editor.UndoableBnStyledDocument;
import javax.swing.text.BadLocationException;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class RemoveUndoableEdit
extends AbstractUndoableBnEdit {
    private static final long serialVersionUID = 1L;
    protected final int offset;
    protected final String text;

    public RemoveUndoableEdit(UndoableBnStyledDocument doc, int offset, String text) {
        super(doc);
        this.offset = offset;
        this.text = (String)Preconditions.checkNotNull((Object)text, (Object)"text == null!");
    }

    @Override
    public boolean canUndo() {
        return super.canUndo() && this.offset <= this.doc.getLength();
    }

    @Override
    public void undo() throws CannotRedoException {
        super.undo();
        try {
            this.insertString(this.offset, this.text, null);
        }
        catch (BadLocationException ex) {
            throw new CannotRedoException();
        }
    }

    @Override
    public boolean canRedo() {
        return super.canRedo() && this.offset + this.text.length() <= this.doc.getLength();
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        try {
            this.remove(this.offset, this.text.length());
        }
        catch (BadLocationException ex) {
            throw new CannotUndoException();
        }
    }

    @Override
    public String getPresentationName() {
        return "remove";
    }
}

