/*
 * Decompiled with CFR 0.152.
 */
package de.adrodoc55.minecraft.mpl.ide.gui.editor;

import com.google.common.base.Preconditions;
import de.adrodoc55.minecraft.mpl.ide.gui.editor.AbstractUndoableBnEdit;
import de.adrodoc55.minecraft.mpl.ide.gui.editor.UndoableBnStyledDocument;
import javax.annotation.Nullable;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class ChangeUndoableEdit
extends AbstractUndoableBnEdit {
    private static final long serialVersionUID = 1L;
    protected final int offset;
    protected final String oldText;
    protected final String newText;
    protected final AttributeSet attrs;

    public ChangeUndoableEdit(UndoableBnStyledDocument doc, int offset, String oldText, String newText, @Nullable AttributeSet attrs) {
        super(doc);
        this.offset = offset;
        this.oldText = (String)Preconditions.checkNotNull((Object)oldText, (Object)"oldText == null!");
        this.newText = (String)Preconditions.checkNotNull((Object)newText, (Object)"newText == null!");
        this.attrs = attrs;
    }

    @Override
    public boolean canUndo() {
        return super.canUndo() && this.offset + this.newText.length() <= this.doc.getLength();
    }

    @Override
    public void undo() throws CannotRedoException {
        super.undo();
        try {
            this.replace(this.offset, this.newText.length(), this.oldText, this.attrs);
        }
        catch (BadLocationException ex) {
            throw new CannotRedoException();
        }
    }

    @Override
    public boolean canRedo() {
        return super.canRedo() && this.offset + this.oldText.length() <= this.doc.getLength();
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        try {
            this.replace(this.offset, this.oldText.length(), this.newText, this.attrs);
        }
        catch (BadLocationException ex) {
            throw new CannotUndoException();
        }
    }

    @Override
    public String getPresentationName() {
        return "change";
    }
}

