/*
 * Decompiled with CFR 0.152.
 */
package de.adrodoc55.minecraft.mpl.ide.gui.dialog.content;

import de.adrodoc55.minecraft.mpl.ide.gui.dialog.WindowView;
import de.adrodoc55.minecraft.mpl.ide.gui.dialog.content.ContentPM;
import de.adrodoc55.minecraft.mpl.ide.gui.dialog.content.ContentPanel;
import de.adrodoc55.minecraft.mpl.ide.gui.dialog.content.MultiContentDialogPM;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.beanfabrics.IModelProvider;
import org.beanfabrics.Link;
import org.beanfabrics.ModelProvider;
import org.beanfabrics.ModelSubscriber;
import org.beanfabrics.Path;
import org.beanfabrics.View;
import org.beanfabrics.event.ElementChangedEvent;
import org.beanfabrics.event.ElementsAddedEvent;
import org.beanfabrics.event.ElementsDeselectedEvent;
import org.beanfabrics.event.ElementsRemovedEvent;
import org.beanfabrics.event.ElementsReplacedEvent;
import org.beanfabrics.event.ElementsSelectedEvent;
import org.beanfabrics.event.ListListener;
import org.beanfabrics.model.IListPM;
import org.beanfabrics.model.PresentationModel;

public class MultiContentDialog
extends JDialog
implements WindowView<MultiContentDialogPM>,
ModelSubscriber {
    private final Link link = new Link((View)this);
    private ModelProvider localModelProvider;
    private JScrollPane scrollPane;
    private JPanel contentsPanel;

    public MultiContentDialog(Window parent, String title) {
        super(parent, title);
        this.init();
        this.setModal(true);
        this.setResizable(false);
        this.setSize(500, 500);
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getScrollPane(), "Center");
        InputMap inputMap = this.getRootPane().getInputMap(2);
        ActionMap actionMap = this.getRootPane().getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "close");
        actionMap.put("close", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiContentDialog.this.dispose();
            }
        });
    }

    protected ModelProvider getLocalModelProvider() {
        if (this.localModelProvider == null) {
            this.localModelProvider = new ModelProvider();
            this.localModelProvider.setPresentationModelType(MultiContentDialogPM.class);
        }
        return this.localModelProvider;
    }

    public MultiContentDialogPM getPresentationModel() {
        return (MultiContentDialogPM)this.getLocalModelProvider().getPresentationModel();
    }

    public void setPresentationModel(MultiContentDialogPM pModel) {
        ListListener l = new ListListener(){

            public void elementsSelected(ElementsSelectedEvent evt) {
            }

            public void elementsReplaced(ElementsReplacedEvent evt) {
                int beginIndex = evt.getBeginIndex();
                int length = evt.getLength();
                this.remove(beginIndex, length);
                IListPM list = (IListPM)evt.getSource();
                this.add((IListPM<ContentPM>)list, beginIndex, length);
            }

            public void elementsRemoved(ElementsRemovedEvent evt) {
                int beginIndex = evt.getBeginIndex();
                int length = evt.getLength();
                this.remove(beginIndex, length);
            }

            public void elementsDeselected(ElementsDeselectedEvent evt) {
            }

            public void elementsAdded(ElementsAddedEvent evt) {
                int beginIndex = evt.getBeginIndex();
                int length = evt.getLength();
                IListPM list = (IListPM)evt.getSource();
                this.add((IListPM<ContentPM>)list, beginIndex, length);
            }

            public void elementChanged(ElementChangedEvent evt) {
            }

            private void remove(int beginIndex, int length) {
                for (int i = 0; i < length; ++i) {
                    int index = beginIndex + i;
                    MultiContentDialog.this.getContentsPanel().remove(index);
                }
                MultiContentDialog.this.revalidate();
                MultiContentDialog.this.repaint();
                this.setDefaultButton();
            }

            private void add(IListPM<ContentPM> list, int beginIndex, int length) {
                for (int i = 0; i < length; ++i) {
                    int index = beginIndex + i;
                    ContentPM contentPm = (ContentPM)list.getAt(index);
                    this.addContent(index, contentPm);
                }
                MultiContentDialog.this.revalidate();
                MultiContentDialog.this.repaint();
                this.setDefaultButton();
            }

            private void addContent(int i, ContentPM contentPm) {
                ContentPanel panel = new ContentPanel();
                panel.setPresentationModel(contentPm);
                MultiContentDialog.this.getContentsPanel().add((Component)panel, i);
            }

            private void setDefaultButton() {
                try {
                    ContentPanel first = (ContentPanel)MultiContentDialog.this.getContentsPanel().getComponent(0);
                    MultiContentDialog.this.getRootPane().setDefaultButton((JButton)first.getBnbtnCopyAndClose());
                }
                catch (ArrayIndexOutOfBoundsException | ClassCastException runtimeException) {
                    // empty catch block
                }
            }
        };
        pModel.contents.addListListener(l);
        this.getLocalModelProvider().setPresentationModel((PresentationModel)pModel);
    }

    public IModelProvider getModelProvider() {
        return this.link.getModelProvider();
    }

    public void setModelProvider(IModelProvider modelProvider) {
        this.link.setModelProvider(modelProvider);
    }

    public Path getPath() {
        return this.link.getPath();
    }

    public void setPath(Path path) {
        this.link.setPath(path);
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setViewportView(this.getContentsPanel());
        }
        return this.scrollPane;
    }

    private JPanel getContentsPanel() {
        if (this.contentsPanel == null) {
            this.contentsPanel = new JPanel();
            this.contentsPanel.setLayout(new BoxLayout(this.contentsPanel, 1));
        }
        return this.contentsPanel;
    }
}

