/*
 * Decompiled with CFR 0.152.
 */
package de.adrodoc55.minecraft.mpl.ide.gui.dialog.compileroptions;

import de.adrodoc55.minecraft.mpl.compilation.CompilerOptions;
import de.adrodoc55.minecraft.mpl.version.MinecraftVersion;
import java.util.ArrayList;
import org.beanfabrics.model.AbstractPM;
import org.beanfabrics.model.BooleanPM;
import org.beanfabrics.model.OperationPM;
import org.beanfabrics.model.Options;
import org.beanfabrics.model.PMManager;
import org.beanfabrics.model.PresentationModel;
import org.beanfabrics.model.TextPM;
import org.beanfabrics.support.Operation;

public class CompilerOptionsDialogPM
extends AbstractPM {
    final BooleanPM debug = new BooleanPM();
    final BooleanPM deleteOnUninstall = new BooleanPM();
    final BooleanPM transmitter = new BooleanPM();
    final TextPM version = new TextPM();
    final OperationPM ok = new OperationPM();
    private MinecraftVersion savedVersion = MinecraftVersion.getDefault();
    private CompilerOptions savedOptions = new CompilerOptions(new CompilerOptions.CompilerOption[]{CompilerOptions.CompilerOption.DELETE_ON_UNINSTALL, CompilerOptions.CompilerOption.TRANSMITTER});

    public CompilerOptionsDialogPM() {
        Options versions = new Options();
        for (MinecraftVersion mv : MinecraftVersion.getValues()) {
            versions.put((Object)mv, mv.toString());
        }
        this.version.setOptions(versions);
        this.version.setRestrictedToOptions(true);
        this.resetProperties();
        PMManager.setup((PresentationModel)this);
    }

    public void resetProperties() {
        this.version.setText(this.savedVersion.toString());
        this.debug.setBoolean(Boolean.valueOf(this.savedOptions.hasOption(CompilerOptions.CompilerOption.DEBUG)));
        this.deleteOnUninstall.setBoolean(Boolean.valueOf(this.savedOptions.hasOption(CompilerOptions.CompilerOption.DELETE_ON_UNINSTALL)));
        this.transmitter.setBoolean(Boolean.valueOf(this.savedOptions.hasOption(CompilerOptions.CompilerOption.TRANSMITTER)));
    }

    public void save() {
        this.savedVersion = MinecraftVersion.getVersion((String)this.version.getText());
        this.savedOptions = this.toCompilerOptions();
    }

    private CompilerOptions toCompilerOptions() {
        ArrayList<CompilerOptions.CompilerOption> options = new ArrayList<CompilerOptions.CompilerOption>(3);
        if (this.debug.getBoolean().booleanValue()) {
            options.add(CompilerOptions.CompilerOption.DEBUG);
        }
        if (this.deleteOnUninstall.getBoolean().booleanValue()) {
            options.add(CompilerOptions.CompilerOption.DELETE_ON_UNINSTALL);
        }
        if (this.transmitter.getBoolean().booleanValue()) {
            options.add(CompilerOptions.CompilerOption.TRANSMITTER);
        }
        return new CompilerOptions(options);
    }

    public MinecraftVersion getSavedVersion() {
        return this.savedVersion;
    }

    public CompilerOptions getSavedOptions() {
        return this.savedOptions;
    }

    @Operation
    public void ok() {
        this.ok.check();
        this.save();
    }
}

