/*
 * Decompiled with CFR 0.152.
 */
package de.adrodoc55.minecraft.mpl.ide.gui;

import de.adrodoc55.minecraft.mpl.ide.gui.MplEditor;
import de.adrodoc55.minecraft.mpl.ide.gui.MplEditorPM;
import de.adrodoc55.minecraft.mpl.ide.gui.MplFramePM;
import de.adrodoc55.minecraft.mpl.ide.gui.TabCloseComponent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.beanfabrics.IModelProvider;
import org.beanfabrics.Link;
import org.beanfabrics.ModelProvider;
import org.beanfabrics.ModelSubscriber;
import org.beanfabrics.Path;
import org.beanfabrics.View;
import org.beanfabrics.event.ElementChangedEvent;
import org.beanfabrics.event.ElementsAddedEvent;
import org.beanfabrics.event.ElementsDeselectedEvent;
import org.beanfabrics.event.ElementsRemovedEvent;
import org.beanfabrics.event.ElementsReplacedEvent;
import org.beanfabrics.event.ElementsSelectedEvent;
import org.beanfabrics.event.ListListener;
import org.beanfabrics.model.IListPM;
import org.beanfabrics.model.ListPM;
import org.beanfabrics.model.PresentationModel;
import org.beanfabrics.swing.BnButton;
import org.beanfabrics.swing.BnMenuItem;

public class MplFrame
extends JFrame
implements View<MplFramePM>,
ModelSubscriber {
    private static final long serialVersionUID = 1L;
    private final Link link = new Link((View)this);
    private ModelProvider localModelProvider;
    private JMenuBar menuBar;
    private JMenu mnFile;
    private BnMenuItem bnmntmNew;
    private BnMenuItem bnmntmOpen;
    private BnMenuItem bnmntmSave;
    private BnMenuItem bnmntmSaveUnder;
    private BnMenuItem bnmntmCompileToCommand;
    private BnMenuItem bnmntmCompileToStructure;
    private BnMenuItem bnmntmCompileToStructureUnder;
    private BnMenuItem bnmntmCompileToSchematic;
    private BnMenuItem bnmntmCompileToSchematicUnder;
    private BnMenuItem bnmntmCompileToCbse;
    private BnMenuItem bnmntmCompileToFilter;
    private BnMenuItem bnmntmCompileToFilterUnder;
    private JMenu mnOptions;
    private BnMenuItem bnmntmCompilerOptions;
    private JToolBar toolBar;
    private BnButton bnbtnNew;
    private BnButton bnbtnOpen;
    private BnButton bnbtnSave;
    private BnButton bnbtnCompileToCommand;
    private BnButton bnbtnCompilerToStructure;
    private BnButton bnbtnCompileToSchematic;
    private BnButton bnbtnCompileToCbse;
    private BnButton bnbtnCompileToFilter;
    private JTabbedPane tabbedPane;

    public MplFrame() {
        super("Minecraft Programming Language - " + MplFrame.getVersion());
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(MplFrame.class.getResource("/icons/command_block_icon.png")));
        this.init();
        this.setSize(1000, 500);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MplFramePM pModel = MplFrame.this.getPresentationModel();
                if (pModel == null) {
                    System.exit(0);
                }
                pModel.terminate();
            }
        });
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                MplFramePM pModel = MplFrame.this.getPresentationModel();
                if (pModel != null) {
                    pModel.checkFiles();
                }
            }
        });
    }

    private static String getVersion() {
        String version = MplFrame.class.getPackage().getImplementationVersion();
        if (version != null) {
            return version;
        }
        return "local build";
    }

    private void init() {
        this.setJMenuBar(this.getMenuBar_1());
        this.getContentPane().add((Component)this.getToolBar(), "North");
        this.getContentPane().add((Component)this.getTabbedPane(), "Center");
    }

    protected ModelProvider getLocalModelProvider() {
        if (this.localModelProvider == null) {
            this.localModelProvider = new ModelProvider();
            this.localModelProvider.setPresentationModelType(MplFramePM.class);
        }
        return this.localModelProvider;
    }

    public MplFramePM getPresentationModel() {
        return (MplFramePM)this.getLocalModelProvider().getPresentationModel();
    }

    public void setPresentationModel(MplFramePM pModel) {
        ListListener l = new ListListener(){

            public void elementsSelected(ElementsSelectedEvent evt) {
                MplFrame.this.getTabbedPane().setSelectedIndex(evt.getBeginIndex());
            }

            public void elementsReplaced(ElementsReplacedEvent evt) {
                int beginIndex = evt.getBeginIndex();
                int length = evt.getLength();
                this.remove(beginIndex, length);
                IListPM list = (IListPM)evt.getSource();
                this.add((IListPM<MplEditorPM>)list, beginIndex, length);
            }

            public void elementsRemoved(ElementsRemovedEvent evt) {
                int beginIndex = evt.getBeginIndex();
                int length = evt.getLength();
                this.remove(beginIndex, length);
            }

            public void elementsDeselected(ElementsDeselectedEvent evt) {
            }

            public void elementsAdded(ElementsAddedEvent evt) {
                int beginIndex = evt.getBeginIndex();
                int length = evt.getLength();
                IListPM list = (IListPM)evt.getSource();
                this.add((IListPM<MplEditorPM>)list, beginIndex, length);
            }

            public void elementChanged(ElementChangedEvent evt) {
            }

            private void remove(int beginIndex, int length) {
                for (int i = 0; i < length; ++i) {
                    int index = beginIndex + i;
                    MplFrame.this.getTabbedPane().remove(index);
                }
            }

            private void add(IListPM<MplEditorPM> list, int beginIndex, int length) {
                for (int i = 0; i < length; ++i) {
                    int index = beginIndex + i;
                    MplEditorPM editorPm = (MplEditorPM)list.getAt(index);
                    this.addMplEditor(index, editorPm);
                }
            }

            private void addMplEditor(int i, MplEditorPM editorPm) {
                MplEditor editor = new MplEditor();
                editor.setPresentationModel(editorPm);
                editor.getTextPane().getCaret().setDot(0);
                editor.discardAllEdits();
                editorPm.setView(editor);
                MplFrame.this.getTabbedPane().insertTab(editorPm.getTitle(), null, editor, null, i);
                TabCloseComponent tabComponent = new TabCloseComponent();
                tabComponent.setPresentationModel(editorPm);
                MplFrame.this.getTabbedPane().setTabComponentAt(i, tabComponent);
            }
        };
        pModel.editors.addListListener(l);
        this.getLocalModelProvider().setPresentationModel((PresentationModel)pModel);
    }

    public IModelProvider getModelProvider() {
        return this.link.getModelProvider();
    }

    public void setModelProvider(IModelProvider modelProvider) {
        this.link.setModelProvider(modelProvider);
    }

    public Path getPath() {
        return this.link.getPath();
    }

    public void setPath(Path path) {
        this.link.setPath(path);
    }

    private JMenuBar getMenuBar_1() {
        if (this.menuBar == null) {
            this.menuBar = new JMenuBar();
            this.menuBar.add(this.getMnFile());
            this.menuBar.add(this.getMnOptions());
        }
        return this.menuBar;
    }

    private JMenu getMnFile() {
        if (this.mnFile == null) {
            this.mnFile = new JMenu("File");
            this.mnFile.add((JMenuItem)this.getBnmntmNew());
            this.mnFile.add((JMenuItem)this.getBnmntmOpen());
            this.mnFile.add((JMenuItem)this.getBnmntmSave());
            this.mnFile.add((JMenuItem)this.getBnmntmSaveUnder());
            this.mnFile.add((JMenuItem)this.getBnmntmCompileToCommand());
            this.mnFile.add((JMenuItem)this.getBnmntmCompileToStructure());
            this.mnFile.add((JMenuItem)this.getBnmntmCompileToStructureUnder());
            this.mnFile.add((JMenuItem)this.getBnmntmCompileToSchematic());
            this.mnFile.add((JMenuItem)this.getBnmntmCompileToSchematicUnder());
            this.mnFile.add((JMenuItem)this.getBnmntmCompileToCbse());
            this.mnFile.add((JMenuItem)this.getBnmntmCompileToFilter());
            this.mnFile.add((JMenuItem)this.getBnmntmCompileToFilterUnder());
        }
        return this.mnFile;
    }

    private BnMenuItem getBnmntmNew() {
        if (this.bnmntmNew == null) {
            this.bnmntmNew = new BnMenuItem();
            this.bnmntmNew.setPath(new Path("this.newFile"));
            this.bnmntmNew.setModelProvider((IModelProvider)this.getLocalModelProvider());
            this.bnmntmNew.setText("New");
        }
        return this.bnmntmNew;
    }

    private BnMenuItem getBnmntmOpen() {
        if (this.bnmntmOpen == null) {
            this.bnmntmOpen = new BnMenuItem();
            this.bnmntmOpen.setPath(new Path("this.openFile"));
            this.bnmntmOpen.setModelProvider((IModelProvider)this.getLocalModelProvider());
            this.bnmntmOpen.setText("Open");
        }
        return this.bnmntmOpen;
    }

    private BnMenuItem getBnmntmSave() {
        if (this.bnmntmSave == null) {
            this.bnmntmSave = new BnMenuItem();
            this.bnmntmSave.setPath(new Path("this.saveFile"));
            this.bnmntmSave.setModelProvider((IModelProvider)this.getLocalModelProvider());
            this.bnmntmSave.setText("Save");
        }
        return this.bnmntmSave;
    }

    private BnMenuItem getBnmntmSaveUnder() {
        if (this.bnmntmSaveUnder == null) {
            this.bnmntmSaveUnder = new BnMenuItem();
            this.bnmntmSaveUnder.setPath(new Path("this.saveFileUnder"));
            this.bnmntmSaveUnder.setModelProvider((IModelProvider)this.getLocalModelProvider());
            this.bnmntmSaveUnder.setText("Save under...");
        }
        return this.bnmntmSaveUnder;
    }

    private BnMenuItem getBnmntmCompileToCommand() {
        if (this.bnmntmCompileToCommand == null) {
            this.bnmntmCompileToCommand = new BnMenuItem();
            this.bnmntmCompileToCommand.setPath(new Path("this.compileToCommand"));
            this.bnmntmCompileToCommand.setModelProvider((IModelProvider)this.getLocalModelProvider());
            this.bnmntmCompileToCommand.setText("Compile to Command");
        }
        return this.bnmntmCompileToCommand;
    }

    private BnMenuItem getBnmntmCompileToStructure() {
        if (this.bnmntmCompileToStructure == null) {
            this.bnmntmCompileToStructure = new BnMenuItem();
            this.bnmntmCompileToStructure.setPath(new Path("this.compileToStructure"));
            this.bnmntmCompileToStructure.setModelProvider((IModelProvider)this.getLocalModelProvider());
            this.bnmntmCompileToStructure.setText("Compile to Structure");
        }
        return this.bnmntmCompileToStructure;
    }

    private BnMenuItem getBnmntmCompileToStructureUnder() {
        if (this.bnmntmCompileToStructureUnder == null) {
            this.bnmntmCompileToStructureUnder = new BnMenuItem();
            this.bnmntmCompileToStructureUnder.setPath(new Path("this.compileToStructureUnder"));
            this.bnmntmCompileToStructureUnder.setModelProvider((IModelProvider)this.getLocalModelProvider());
            this.bnmntmCompileToStructureUnder.setText("Compile to Structure under ...");
        }
        return this.bnmntmCompileToStructureUnder;
    }

    private BnMenuItem getBnmntmCompileToSchematic() {
        if (this.bnmntmCompileToSchematic == null) {
            this.bnmntmCompileToSchematic = new BnMenuItem();
            this.bnmntmCompileToSchematic.setPath(new Path("this.compileToSchematic"));
            this.bnmntmCompileToSchematic.setModelProvider((IModelProvider)this.getLocalModelProvider());
            this.bnmntmCompileToSchematic.setText("Compile to Schematic");
        }
        return this.bnmntmCompileToSchematic;
    }

    private BnMenuItem getBnmntmCompileToSchematicUnder() {
        if (this.bnmntmCompileToSchematicUnder == null) {
            this.bnmntmCompileToSchematicUnder = new BnMenuItem();
            this.bnmntmCompileToSchematicUnder.setPath(new Path("this.compileToSchematicUnder"));
            this.bnmntmCompileToSchematicUnder.setModelProvider((IModelProvider)this.getLocalModelProvider());
            this.bnmntmCompileToSchematicUnder.setText("Compile to Schematic under ...");
        }
        return this.bnmntmCompileToSchematicUnder;
    }

    private BnMenuItem getBnmntmCompileToCbse() {
        if (this.bnmntmCompileToCbse == null) {
            this.bnmntmCompileToCbse = new BnMenuItem();
            this.bnmntmCompileToCbse.setPath(new Path("this.compileToCbse"));
            this.bnmntmCompileToCbse.setModelProvider((IModelProvider)this.getLocalModelProvider());
            this.bnmntmCompileToCbse.setText("Compile to Command Block Structure Editor File");
        }
        return this.bnmntmCompileToCbse;
    }

    private BnMenuItem getBnmntmCompileToFilter() {
        if (this.bnmntmCompileToFilter == null) {
            this.bnmntmCompileToFilter = new BnMenuItem();
            this.bnmntmCompileToFilter.setPath(new Path("this.compileToFilter"));
            this.bnmntmCompileToFilter.setModelProvider((IModelProvider)this.getLocalModelProvider());
            this.bnmntmCompileToFilter.setText("Compile to MCEdit Filter");
        }
        return this.bnmntmCompileToFilter;
    }

    private BnMenuItem getBnmntmCompileToFilterUnder() {
        if (this.bnmntmCompileToFilterUnder == null) {
            this.bnmntmCompileToFilterUnder = new BnMenuItem();
            this.bnmntmCompileToFilterUnder.setPath(new Path("this.compileToFilterUnder"));
            this.bnmntmCompileToFilterUnder.setModelProvider((IModelProvider)this.getLocalModelProvider());
            this.bnmntmCompileToFilterUnder.setText("Compile to MCEdit Filter under ...");
        }
        return this.bnmntmCompileToFilterUnder;
    }

    private JMenu getMnOptions() {
        if (this.mnOptions == null) {
            this.mnOptions = new JMenu("Options");
            this.mnOptions.add((JMenuItem)this.getBnmntmCompilerOptions());
        }
        return this.mnOptions;
    }

    private BnMenuItem getBnmntmCompilerOptions() {
        if (this.bnmntmCompilerOptions == null) {
            this.bnmntmCompilerOptions = new BnMenuItem();
            this.bnmntmCompilerOptions.setPath(new Path("this.openOptionsDialog"));
            this.bnmntmCompilerOptions.setModelProvider((IModelProvider)this.getLocalModelProvider());
            this.bnmntmCompilerOptions.setText("Compiler Options");
        }
        return this.bnmntmCompilerOptions;
    }

    private JToolBar getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = new JToolBar();
            this.toolBar.add((Component)this.getBnbtnNew());
            this.toolBar.add((Component)this.getBnbtnOpen());
            this.toolBar.add((Component)this.getBnbtnSave());
            this.toolBar.add((Component)this.getBnbtnCompileToCommand());
            this.toolBar.add((Component)this.getBnbtnCompilerToStructure());
            this.toolBar.add((Component)this.getBnbtnCompileToSchematic());
            this.toolBar.add((Component)this.getBnbtnCompileToCbse());
            this.toolBar.add((Component)this.getBnbtnCompileToFilter());
        }
        return this.toolBar;
    }

    private BnButton getBnbtnNew() {
        if (this.bnbtnNew == null) {
            this.bnbtnNew = new BnButton();
            this.bnbtnNew.setIcon((Icon)new ImageIcon(MplFrame.class.getResource("/icons/new_file_icon_16.png")));
            this.bnbtnNew.setModelProvider((IModelProvider)this.getLocalModelProvider());
            this.bnbtnNew.setPath(new Path("this.newFile"));
        }
        return this.bnbtnNew;
    }

    private BnButton getBnbtnOpen() {
        if (this.bnbtnOpen == null) {
            this.bnbtnOpen = new BnButton();
            this.bnbtnOpen.setIcon((Icon)new ImageIcon(MplFrame.class.getResource("/icons/folder_icon_16.png")));
            this.bnbtnOpen.setPath(new Path("this.openFile"));
            this.bnbtnOpen.setModelProvider((IModelProvider)this.getLocalModelProvider());
        }
        return this.bnbtnOpen;
    }

    private BnButton getBnbtnSave() {
        if (this.bnbtnSave == null) {
            this.bnbtnSave = new BnButton();
            this.bnbtnSave.setIcon((Icon)new ImageIcon(MplFrame.class.getResource("/icons/disk_icon_16.png")));
            this.bnbtnSave.setPath(new Path("this.saveFile"));
            this.bnbtnSave.setModelProvider((IModelProvider)this.getLocalModelProvider());
        }
        return this.bnbtnSave;
    }

    private BnButton getBnbtnCompileToCommand() {
        if (this.bnbtnCompileToCommand == null) {
            this.bnbtnCompileToCommand = new BnButton();
            this.bnbtnCompileToCommand.setIcon((Icon)new ImageIcon(MplFrame.class.getResource("/icons/command_block_icon_16.png")));
            this.bnbtnCompileToCommand.setPath(new Path("this.compileToCommand"));
            this.bnbtnCompileToCommand.setModelProvider((IModelProvider)this.getLocalModelProvider());
        }
        return this.bnbtnCompileToCommand;
    }

    private BnButton getBnbtnCompilerToStructure() {
        if (this.bnbtnCompilerToStructure == null) {
            this.bnbtnCompilerToStructure = new BnButton();
            this.bnbtnCompilerToStructure.setIcon((Icon)new ImageIcon(MplFrame.class.getResource("/icons/structure_block_load_16.png")));
            this.bnbtnCompilerToStructure.setPath(new Path("this.compileToStructure"));
            this.bnbtnCompilerToStructure.setModelProvider((IModelProvider)this.getLocalModelProvider());
        }
        return this.bnbtnCompilerToStructure;
    }

    private BnButton getBnbtnCompileToSchematic() {
        if (this.bnbtnCompileToSchematic == null) {
            this.bnbtnCompileToSchematic = new BnButton();
            this.bnbtnCompileToSchematic.setIcon((Icon)new ImageIcon(MplFrame.class.getResource("/icons/schematic_16.png")));
            this.bnbtnCompileToSchematic.setPath(new Path("this.compileToSchematic"));
            this.bnbtnCompileToSchematic.setModelProvider((IModelProvider)this.getLocalModelProvider());
        }
        return this.bnbtnCompileToSchematic;
    }

    private BnButton getBnbtnCompileToCbse() {
        if (this.bnbtnCompileToCbse == null) {
            this.bnbtnCompileToCbse = new BnButton();
            this.bnbtnCompileToCbse.setIcon((Icon)new ImageIcon(MplFrame.class.getResource("/icons/cbse_16.png")));
            this.bnbtnCompileToCbse.setPath(new Path("this.compileToCbse"));
            this.bnbtnCompileToCbse.setModelProvider((IModelProvider)this.getLocalModelProvider());
        }
        return this.bnbtnCompileToCbse;
    }

    private BnButton getBnbtnCompileToFilter() {
        if (this.bnbtnCompileToFilter == null) {
            this.bnbtnCompileToFilter = new BnButton();
            this.bnbtnCompileToFilter.setIcon((Icon)new ImageIcon(MplFrame.class.getResource("/icons/mcedit_16.png")));
            this.bnbtnCompileToFilter.setPath(new Path("this.compileToFilter"));
            this.bnbtnCompileToFilter.setModelProvider((IModelProvider)this.getLocalModelProvider());
        }
        return this.bnbtnCompileToFilter;
    }

    private JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane(1);
            this.tabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    MplFramePM presentationModel = MplFrame.this.getPresentationModel();
                    if (presentationModel == null) {
                        return;
                    }
                    ListPM<MplEditorPM> editors = presentationModel.editors;
                    int selectedIndex = MplFrame.this.tabbedPane.getSelectedIndex();
                    editors.getSelection().setInterval(selectedIndex, selectedIndex);
                }
            });
        }
        return this.tabbedPane;
    }
}

