/*
 * Decompiled with CFR 0.152.
 */
package de.adrodoc55.minecraft.mpl.ide.gui;

import de.adrodoc55.commons.AncestorAdapter;
import de.adrodoc55.commons.FileUtils;
import de.adrodoc55.minecraft.mpl.ide.autocompletion.AutoCompletion;
import de.adrodoc55.minecraft.mpl.ide.autocompletion.AutoCompletionAction;
import de.adrodoc55.minecraft.mpl.ide.gui.CommentUndoableEdit;
import de.adrodoc55.minecraft.mpl.ide.gui.MplEditorPM;
import de.adrodoc55.minecraft.mpl.ide.gui.MplSyntaxFilter;
import de.adrodoc55.minecraft.mpl.ide.gui.MplSyntaxFilterPM;
import de.adrodoc55.minecraft.mpl.ide.gui.dialog.WindowController;
import de.adrodoc55.minecraft.mpl.ide.gui.dialog.autocompletion.AutoCompletionDialog;
import de.adrodoc55.minecraft.mpl.ide.gui.dialog.autocompletion.AutoCompletionDialogController;
import de.adrodoc55.minecraft.mpl.ide.gui.dialog.autocompletion.AutoCompletionDialogPM;
import de.adrodoc55.minecraft.mpl.ide.gui.dialog.hover.HoverDialog;
import de.adrodoc55.minecraft.mpl.ide.gui.dialog.hover.HoverDialogController;
import de.adrodoc55.minecraft.mpl.ide.gui.editor.BnEditorTextPane;
import de.adrodoc55.minecraft.mpl.ide.gui.editor.EditorPM;
import de.adrodoc55.minecraft.mpl.ide.gui.editor.UndoableBnStyledDocument;
import de.adrodoc55.minecraft.mpl.ide.gui.utils.TextLineNumber;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.AncestorEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import org.beanfabrics.IModelProvider;
import org.beanfabrics.Link;
import org.beanfabrics.ModelProvider;
import org.beanfabrics.ModelSubscriber;
import org.beanfabrics.Path;
import org.beanfabrics.View;
import org.beanfabrics.model.PresentationModel;

public class MplEditor
extends JComponent
implements View<MplEditorPM>,
ModelSubscriber {
    private static final long serialVersionUID = 1L;
    private static JFileChooser chooser;
    private static FileFilter filter;
    private final Link link = new Link((View)this);
    private ModelProvider localModelProvider;
    private JScrollPane scrollPane;
    private BnEditorTextPane textPane;
    private MplSyntaxFilter mplSyntaxFilter;
    private TextLineNumber textLineNumber;
    private List<WindowController<?, ?>> ctrl = new ArrayList();
    private HoverDialogController hoverCtrl = new HoverDialogController();
    private AutoCompletionDialogController autoCtrl = new AutoCompletionDialogController(new AutoCompletionDialogPM.Context(){

        @Override
        public void choose(AutoCompletionAction action) {
            action.performOn(MplEditor.this.getTextPane());
        }
    });

    private static JFileChooser getFileChooser() {
        if (chooser == null) {
            chooser = new JFileChooser();
        }
        return chooser;
    }

    public static JFileChooser getDirChooser() {
        JFileChooser chooser = MplEditor.getFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setFileFilter(null);
        FileFilter filter = MplEditor.getFileFilter();
        chooser.removeChoosableFileFilter(filter);
        return chooser;
    }

    public static JFileChooser getMplChooser() {
        JFileChooser chooser = MplEditor.getFileChooser();
        chooser.setFileSelectionMode(0);
        FileFilter filter = MplEditor.getFileFilter();
        chooser.setFileFilter(filter);
        chooser.addChoosableFileFilter(filter);
        return chooser;
    }

    private static FileFilter getFileFilter() {
        if (filter == null) {
            filter = new FileNameExtensionFilter("Minecraft Programming Language", "mpl");
        }
        return filter;
    }

    public MplEditor() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getScrollPane(), "Center");
        this.ctrl.add(this.autoCtrl);
        this.ctrl.add(this.hoverCtrl);
        for (final WindowController<?, ?> controler : this.ctrl) {
            this.addAncestorListener(new AncestorAdapter(){

                @Override
                public void ancestorMoved(AncestorEvent event) {
                    controler.dispose();
                }
            });
            this.getTextPane().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    controler.dispose();
                }
            });
            this.getTextPane().addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (!controler.hasView()) {
                        return;
                    }
                    Object view = controler.getView();
                    Component opposite = e.getOppositeComponent();
                    if (opposite == null || !view.equals(opposite) && !view.equals(SwingUtilities.getWindowAncestor(opposite))) {
                        controler.dispose();
                    }
                }
            });
        }
    }

    protected ModelProvider getLocalModelProvider() {
        if (this.localModelProvider == null) {
            this.localModelProvider = new ModelProvider();
            this.localModelProvider.setPresentationModelType(MplEditorPM.class);
        }
        return this.localModelProvider;
    }

    public MplEditorPM getPresentationModel() {
        return (MplEditorPM)this.getLocalModelProvider().getPresentationModel();
    }

    public void setPresentationModel(MplEditorPM pModel) {
        this.getLocalModelProvider().setPresentationModel((PresentationModel)pModel);
    }

    public IModelProvider getModelProvider() {
        return this.link.getModelProvider();
    }

    public void setModelProvider(IModelProvider modelProvider) {
        this.link.setModelProvider(modelProvider);
    }

    public Path getPath() {
        return this.link.getPath();
    }

    public void setPath(Path path) {
        this.link.setPath(path);
    }

    public boolean isConnected() {
        return this.getPresentationModel() != null;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setRowHeaderView(this.getTextLineNumber());
            JPanel viewPortView = new JPanel(new BorderLayout());
            viewPortView.add((Component)this.getTextPane(), "Center");
            this.scrollPane.setViewportView(viewPortView);
            this.scrollPane.getVerticalScrollBar().setUnitIncrement(10);
        }
        return this.scrollPane;
    }

    private TextLineNumber getTextLineNumber() {
        if (this.textLineNumber == null) {
            this.textLineNumber = new TextLineNumber(this.getTextPane());
        }
        return this.textLineNumber;
    }

    BnEditorTextPane getTextPane() {
        if (this.textPane == null) {
            this.textPane = new BnEditorTextPane(new BnEditorTextPane.Context(){

                @Override
                public EditorPM getPresentationModel() {
                    return MplEditor.this.getPresentationModel();
                }
            });
            this.textPane.setPath(new Path("this.code"));
            this.textPane.setModelProvider((IModelProvider)this.getLocalModelProvider());
            final UndoableBnStyledDocument doc = this.textPane.getDocument();
            doc.setDocumentFilter(this.getMplSyntaxFilter());
            int ctrl = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            this.textPane.getInputMap().put(KeyStroke.getKeyStroke(75, ctrl), "comment");
            this.textPane.getActionMap().put("comment", new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    int dot = MplEditor.this.textPane.getCaret().getDot();
                    int mark = MplEditor.this.textPane.getCaret().getMark();
                    doc.submit(new CommentUndoableEdit(doc, dot, mark));
                }
            });
            this.textPane.getInputMap().put(KeyStroke.getKeyStroke(70, ctrl), "search and replace");
            this.textPane.getActionMap().put("search and replace", new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MplEditor.this.isConnected()) {
                        MplEditor.this.getPresentationModel().searchAndReplace();
                    }
                }
            });
            this.textPane.getInputMap().put(KeyStroke.getKeyStroke(32, ctrl), "auto complete");
            this.textPane.getActionMap().put("auto complete", new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    Caret caret = MplEditor.this.textPane.getCaret();
                    Point caretPos = caret.getMagicCaretPosition();
                    if (caretPos == null) {
                        return;
                    }
                    MplEditor.this.autoCtrl.setOptions(MplEditor.this.getAutoCompletionOptions());
                    MplEditor.this.autoCtrl.setLocation(MplEditor.this.textPane, caretPos.getLocation());
                    ((AutoCompletionDialog)MplEditor.this.autoCtrl.getView()).setVisible(true);
                    MplEditor.this.textPane.requestFocus();
                }
            });
            this.textPane.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent evt) {
                    AutoCompletionDialog view = (AutoCompletionDialog)MplEditor.this.autoCtrl.getView();
                    if (view.isVisible()) {
                        switch (evt.getKeyCode()) {
                            case 10: 
                            case 27: 
                            case 38: 
                            case 40: {
                                view.getBnList().dispatchEvent((AWTEvent)evt);
                                evt.consume();
                                break;
                            }
                            default: {
                                SwingUtilities.invokeLater(() -> MplEditor.this.autoCtrl.setOptions(MplEditor.this.getAutoCompletionOptions()));
                            }
                        }
                    }
                }
            });
            this.textPane.addMouseMotionListener(new MouseMotionAdapter(){
                MplSyntaxFilterPM.CompilerExceptionWrapper lastEx;

                @Override
                public void mouseMoved(MouseEvent e) {
                    Point point = e.getPoint();
                    MplSyntaxFilterPM.CompilerExceptionWrapper ex = this.getEx(point);
                    if (this.lastEx == ex) {
                        return;
                    }
                    if (this.lastEx != null) {
                        this.lastEx = null;
                        MplEditor.this.hoverCtrl.dispose();
                    }
                    if (ex == null) {
                        return;
                    }
                    Timer t = new Timer(200, a -> {
                        Point secondPoint = MplEditor.this.textPane.getMousePosition();
                        if (secondPoint != null && secondPoint.equals(point)) {
                            this.lastEx = ex;
                            this.showHoverDialog();
                        }
                    });
                    t.setRepeats(false);
                    t.start();
                }

                private MplSyntaxFilterPM.CompilerExceptionWrapper getEx(Point point) {
                    int offset = MplEditor.this.getTextPane().viewToModel(point);
                    MplSyntaxFilterPM pm = MplEditor.this.getMplSyntaxFilter().getPresentationModel();
                    if (pm != null) {
                        ArrayList<MplSyntaxFilterPM.CompilerExceptionWrapper> exs = new ArrayList<MplSyntaxFilterPM.CompilerExceptionWrapper>(pm.getErrors());
                        exs.addAll(pm.getWarnings());
                        for (MplSyntaxFilterPM.CompilerExceptionWrapper ex : exs) {
                            if (ex.getStartIndex() > offset || offset >= ex.getStopIndex()) continue;
                            return ex;
                        }
                    }
                    return null;
                }

                private void showHoverDialog() {
                    Rectangle pos;
                    MplEditor.this.hoverCtrl.setMessage(this.lastEx.getMessage());
                    try {
                        pos = MplEditor.this.getTextPane().modelToView(this.lastEx.getStartIndex());
                    }
                    catch (BadLocationException blex) {
                        throw new UndeclaredThrowableException(blex);
                    }
                    Point location = new Point(pos.x, pos.y);
                    MplEditor.this.hoverCtrl.setLocation(MplEditor.this.textPane, location);
                    ((HoverDialog)MplEditor.this.hoverCtrl.getView()).setVisible(true);
                    MplEditor.this.textPane.requestFocus();
                }
            });
        }
        return this.textPane;
    }

    public List<AutoCompletionAction> getAutoCompletionOptions() {
        BnEditorTextPane textPane = this.getTextPane();
        Caret caret = textPane.getCaret();
        int index = Math.min(caret.getDot(), caret.getMark());
        String text = FileUtils.toUnixLineEnding((String)textPane.getText());
        return AutoCompletion.getOptions(index, text);
    }

    private MplSyntaxFilter getMplSyntaxFilter() {
        if (this.mplSyntaxFilter == null) {
            this.mplSyntaxFilter = new MplSyntaxFilter();
            Path path = new Path("this.syntaxFilter");
            this.mplSyntaxFilter.setPath(path);
            this.mplSyntaxFilter.setModelProvider((IModelProvider)this.getLocalModelProvider());
        }
        return this.mplSyntaxFilter;
    }

    public void discardAllEdits() {
        this.getTextPane().getUndoManager().discardAllEdits();
    }
}

