/*
 * Decompiled with CFR 0.152.
 */
package de.adrodoc55.minecraft.mpl.ide.gui;

import de.adrodoc55.minecraft.mpl.ide.gui.editor.AbstractUndoableBnEdit;
import de.adrodoc55.minecraft.mpl.ide.gui.editor.UndoableBnStyledDocument;
import java.lang.reflect.UndeclaredThrowableException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class CommentUndoableEdit
extends AbstractUndoableBnEdit {
    private static final long serialVersionUID = 1L;
    private int firstLine;
    private int lastLine;

    public CommentUndoableEdit(UndoableBnStyledDocument doc, int dot, int mark) {
        super(doc);
        Element root = doc.getDefaultRootElement();
        this.firstLine = root.getElementIndex(Math.min(dot, mark));
        this.lastLine = root.getElementIndex(Math.max(dot, mark));
    }

    @Override
    public void undo() throws CannotRedoException {
        super.undo();
        this.perform();
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        this.perform();
    }

    public void perform() {
        Element line;
        int l;
        Element root = this.doc.getDefaultRootElement();
        boolean uncomment = true;
        for (l = this.firstLine; l <= this.lastLine; ++l) {
            line = root.getElement(l);
            if (this.isComment(line)) continue;
            uncomment = false;
            break;
        }
        for (l = this.firstLine; l <= this.lastLine; ++l) {
            line = root.getElement(l);
            int start = line.getStartOffset();
            try {
                if (uncomment) {
                    this.doc.removeSilent(start, 2);
                    continue;
                }
                this.doc.insertStringSilent(start, "//", null);
                continue;
            }
            catch (BadLocationException ex) {
                throw new CannotRedoException();
            }
        }
    }

    public boolean isComment(Element line) {
        int start = line.getStartOffset();
        try {
            String text;
            return start + 1 < this.doc.getLength() && "//".equals(text = this.doc.getText(start, 2));
        }
        catch (BadLocationException ex) {
            throw new UndeclaredThrowableException(ex);
        }
    }

    @Override
    public String getPresentationName() {
        return "comment";
    }
}

