/*
 * Decompiled with CFR 0.152.
 */
package de.adrodoc55.minecraft.mpl.ide.gui.editor;

import com.google.common.base.Preconditions;
import de.adrodoc55.minecraft.mpl.ide.gui.editor.AbstractUndoableBnEdit;
import de.adrodoc55.minecraft.mpl.ide.gui.editor.UndoableBnStyledDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class InsertUndoableEdit
extends AbstractUndoableBnEdit {
    private static final long serialVersionUID = 1L;
    protected final int offset;
    protected final String text;
    protected final AttributeSet a;

    public InsertUndoableEdit(UndoableBnStyledDocument doc, int offset, String text, AttributeSet a) {
        super(doc);
        this.offset = offset;
        this.text = (String)Preconditions.checkNotNull((Object)text, (Object)"text == null!");
        this.a = a;
    }

    @Override
    public boolean canUndo() {
        return super.canUndo() && this.offset + this.text.length() <= this.doc.getLength();
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        try {
            this.remove(this.offset, this.text.length());
        }
        catch (BadLocationException ex) {
            throw new CannotUndoException();
        }
    }

    @Override
    public boolean canRedo() {
        return super.canRedo() && this.offset <= this.doc.getLength();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        try {
            this.insertString(this.offset, this.text, this.a);
        }
        catch (BadLocationException ex) {
            throw new CannotRedoException();
        }
    }

    @Override
    public String getPresentationName() {
        return "insert";
    }
}

