/*
 * Decompiled with CFR 0.152.
 */
package de.adrodoc55.minecraft.mpl.ide.gui.dialog.content;

import com.google.common.base.Preconditions;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import org.beanfabrics.model.AbstractPM;
import org.beanfabrics.model.OperationPM;
import org.beanfabrics.model.PMManager;
import org.beanfabrics.model.PresentationModel;
import org.beanfabrics.model.TextPM;
import org.beanfabrics.support.Operation;

public class ContentPM
extends AbstractPM {
    private final Context context;
    final TextPM title = new TextPM();
    final TextPM content = new TextPM();
    final OperationPM copyToClipboard = new OperationPM();
    final OperationPM copyAndClose = new OperationPM();
    final OperationPM close = new OperationPM();

    public ContentPM(String title, String content, Context context) {
        this.context = (Context)Preconditions.checkNotNull((Object)context, (Object)"context == null!");
        this.title.setEditable(false);
        this.content.setEditable(false);
        this.title.setText(title);
        this.content.setText(content);
        PMManager.setup((PresentationModel)this);
    }

    @Operation
    public void copyToClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection contents = new StringSelection(this.content.getText());
        clipboard.setContents(contents, null);
    }

    @Operation
    public void copyAndClose() {
        this.copyToClipboard();
        this.close();
    }

    @Operation
    public void close() {
        this.context.close(this);
    }

    public static interface Context {
        public void close(ContentPM var1);
    }
}

