/*
 * Decompiled with CFR 0.152.
 */
package de.adrodoc55.minecraft.mpl.ide.gui.dialog.compilerexception;

import de.adrodoc55.minecraft.mpl.ide.gui.dialog.compilerexception.ExceptionDialogPM;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.beanfabrics.BnModelObserver;
import org.beanfabrics.IModelProvider;
import org.beanfabrics.Link;
import org.beanfabrics.ModelProvider;
import org.beanfabrics.ModelSubscriber;
import org.beanfabrics.Path;
import org.beanfabrics.View;
import org.beanfabrics.model.PresentationModel;
import org.beanfabrics.swing.BnLabel;
import org.beanfabrics.swing.BnTextArea;

public class ExceptionDialog
extends JDialog
implements View<ExceptionDialogPM>,
ModelSubscriber {
    private final Link link = new Link((View)this);
    private ModelProvider localModelProvider;
    private JLabel lblIcon;
    private BnLabel lblDescription;
    private JScrollPane scrollPane;
    private BnTextArea textArea;
    private JPanel pnlCenter;
    private JPanel pnlBottom;
    private JButton btnOk;
    private BnModelObserver bnModelObserver;

    public ExceptionDialog() {
        this((Window)null);
    }

    public ExceptionDialog(Window parent) {
        super(parent);
        this.init();
        this.setModal(true);
        this.setSize(800, 400);
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getPnlCenter(), "Center");
        this.getContentPane().add((Component)this.getPanel_1(), "South");
        this.getBnModelObserver().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ExceptionDialogPM pModel = ExceptionDialog.this.getPresentationModel();
                if (pModel != null) {
                    ExceptionDialog.this.setTitle(pModel.title.getText());
                }
            }
        });
        this.getRootPane().setDefaultButton(this.getBtnOk());
        InputMap inputMap = this.getRootPane().getInputMap(2);
        ActionMap actionMap = this.getRootPane().getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "close");
        actionMap.put("close", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExceptionDialog.this.dispose();
            }
        });
    }

    protected ModelProvider getLocalModelProvider() {
        if (this.localModelProvider == null) {
            this.localModelProvider = new ModelProvider();
            this.localModelProvider.setPresentationModelType(ExceptionDialogPM.class);
        }
        return this.localModelProvider;
    }

    public ExceptionDialogPM getPresentationModel() {
        return (ExceptionDialogPM)this.getLocalModelProvider().getPresentationModel();
    }

    public void setPresentationModel(ExceptionDialogPM pModel) {
        this.getLocalModelProvider().setPresentationModel((PresentationModel)pModel);
    }

    public IModelProvider getModelProvider() {
        return this.link.getModelProvider();
    }

    public void setModelProvider(IModelProvider modelProvider) {
        this.link.setModelProvider(modelProvider);
    }

    public Path getPath() {
        return this.link.getPath();
    }

    public void setPath(Path path) {
        this.link.setPath(path);
    }

    private JLabel getLblIcon() {
        if (this.lblIcon == null) {
            this.lblIcon = new JLabel();
            this.lblIcon.setIcon(UIManager.getIcon("OptionPane.errorIcon"));
        }
        return this.lblIcon;
    }

    private BnLabel getLblDescription() {
        if (this.lblDescription == null) {
            this.lblDescription = new BnLabel();
            this.lblDescription.setPath(new Path("this.description"));
            this.lblDescription.setModelProvider((IModelProvider)this.getLocalModelProvider());
        }
        return this.lblDescription;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setViewportView((Component)this.getTextArea());
        }
        return this.scrollPane;
    }

    private BnTextArea getTextArea() {
        if (this.textArea == null) {
            this.textArea = new BnTextArea();
            this.textArea.setLineWrap(true);
            this.textArea.setPath(new Path("this.details"));
            this.textArea.setModelProvider((IModelProvider)this.getLocalModelProvider());
        }
        return this.textArea;
    }

    private JPanel getPnlCenter() {
        if (this.pnlCenter == null) {
            this.pnlCenter = new JPanel();
            GridBagLayout gbl_pnlCenter = new GridBagLayout();
            gbl_pnlCenter.columnWidths = new int[]{0};
            gbl_pnlCenter.rowHeights = new int[]{0};
            gbl_pnlCenter.columnWeights = new double[]{0.0, 1.0};
            gbl_pnlCenter.rowWeights = new double[]{0.0, 1.0};
            this.pnlCenter.setLayout(gbl_pnlCenter);
            GridBagConstraints gbc_lblIcon = new GridBagConstraints();
            gbc_lblIcon.insets = new Insets(10, 10, 10, 5);
            gbc_lblIcon.gridx = 0;
            gbc_lblIcon.gridy = 0;
            this.pnlCenter.add((Component)this.getLblIcon(), gbc_lblIcon);
            GridBagConstraints gbc_lblDescription = new GridBagConstraints();
            gbc_lblDescription.insets = new Insets(5, 5, 5, 5);
            gbc_lblDescription.fill = 2;
            gbc_lblDescription.gridx = 1;
            gbc_lblDescription.gridy = 0;
            this.pnlCenter.add((Component)this.getLblDescription(), gbc_lblDescription);
            GridBagConstraints gbc_scrollPane = new GridBagConstraints();
            gbc_scrollPane.gridwidth = 2;
            gbc_scrollPane.insets = new Insets(5, 5, 5, 5);
            gbc_scrollPane.fill = 1;
            gbc_scrollPane.gridx = 0;
            gbc_scrollPane.gridy = 1;
            this.pnlCenter.add((Component)this.getScrollPane(), gbc_scrollPane);
        }
        return this.pnlCenter;
    }

    private JPanel getPanel_1() {
        if (this.pnlBottom == null) {
            this.pnlBottom = new JPanel();
            this.pnlBottom.add(this.getBtnOk());
        }
        return this.pnlBottom;
    }

    private JButton getBtnOk() {
        if (this.btnOk == null) {
            this.btnOk = new JButton("OK");
            this.btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExceptionDialog.this.dispose();
                }
            });
        }
        return this.btnOk;
    }

    private BnModelObserver getBnModelObserver() {
        if (this.bnModelObserver == null) {
            this.bnModelObserver = new BnModelObserver();
            this.bnModelObserver.setPath(new Path("this.title"));
            this.bnModelObserver.setModelProvider((IModelProvider)this.getLocalModelProvider());
        }
        return this.bnModelObserver;
    }

    public static ExceptionDialog create(String title, String message, String details) {
        Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        ExceptionDialog dialog = new ExceptionDialog(activeWindow);
        ExceptionDialogPM dialogPm = new ExceptionDialogPM();
        dialog.setPresentationModel(dialogPm);
        dialogPm.title.setText(title);
        dialogPm.description.setText(message);
        dialogPm.details.setText(details);
        return dialog;
    }
}

