/*
 * Decompiled with CFR 0.152.
 */
package de.adrodoc55.minecraft.mpl.ide.gui;

import de.adrodoc55.minecraft.mpl.compilation.CompilerException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.v4.runtime.Token;
import org.beanfabrics.model.AbstractPM;
import org.beanfabrics.model.PMManager;
import org.beanfabrics.model.PresentationModel;

public class MplSyntaxFilterPM
extends AbstractPM {
    private final List<CompilerExceptionWrapper> errors = new ArrayList<CompilerExceptionWrapper>();
    private final List<CompilerExceptionWrapper> warnings = new ArrayList<CompilerExceptionWrapper>();

    public MplSyntaxFilterPM() {
        PMManager.setup((PresentationModel)this);
    }

    public List<CompilerExceptionWrapper> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public void setErrors(List<CompilerException> errors) {
        this.errors.clear();
        for (CompilerException ex : errors) {
            this.errors.add(new CompilerExceptionWrapper(ex));
        }
        this.getPropertyChangeSupport().firePropertyChange("errors", null, null);
    }

    public List<CompilerExceptionWrapper> getWarnings() {
        return Collections.unmodifiableList(this.warnings);
    }

    public void setWarnings(List<CompilerException> warnings) {
        this.warnings.clear();
        for (CompilerException ex : warnings) {
            this.warnings.add(new CompilerExceptionWrapper(ex));
        }
        this.getPropertyChangeSupport().firePropertyChange("warnings", null, null);
    }

    static class CompilerExceptionWrapper {
        private Token token;
        private int startOffset;
        private int stopOffset;
        private final String message;

        public CompilerExceptionWrapper(CompilerException ex) {
            this.token = ex.getSource().token;
            this.startOffset = 0;
            this.stopOffset = 0;
            this.message = ex.getLocalizedMessage();
        }

        public int getStartIndex() {
            return this.token.getStartIndex() + this.startOffset;
        }

        public int getStopIndex() {
            return this.token.getStopIndex() + 1 + this.stopOffset;
        }

        public void addStartOffset(int offset) {
            this.startOffset += offset;
        }

        public void addStopOffset(int offset) {
            this.stopOffset += offset;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

