/*
 * Decompiled with CFR 0.152.
 */
package de.adrodoc55.minecraft.mpl.ide.autocompletion;

import com.google.common.base.Preconditions;
import de.adrodoc55.commons.DocumentUtils;
import de.adrodoc55.commons.FileUtils;
import de.adrodoc55.commons.Filter;
import de.adrodoc55.minecraft.mpl.ide.autocompletion.AutoCompletionContext;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import org.antlr.v4.runtime.Token;

public abstract class AutoCompletionAction {
    private static final Pattern INSERT = Pattern.compile("(?<!\\$)(\\$+)(?:\\{([^}\\n]*)\\})?");
    private static final String CURSOR = "cursor";
    private static final Filter<String> CURSOR_INSERTS = insert -> CURSOR.equals(insert);
    private static final Filter<String> NON_CURSOR_INSERTS = insert -> !CURSOR.equals(insert);
    private final int startIndex;
    @Nullable
    protected final Token token;

    public AutoCompletionAction(int startIndex, @Nullable Token token) {
        this.startIndex = token != null ? token.getStartIndex() : startIndex;
        this.token = token;
    }

    public void performOn(JTextComponent component) {
        Element root = component.getDocument().getDefaultRootElement();
        Element line = root.getElement(root.getElementIndex(this.startIndex));
        int indentCount = this.startIndex - line.getStartOffset();
        String indent = new String(new char[indentCount]).replace('\u0000', ' ');
        String template = FileUtils.toUnixLineEnding((String)this.getTemplate());
        template = template.replace("\n", "\n" + indent);
        template = this.replaceVariables(template, NON_CURSOR_INSERTS);
        int cursorIndex = this.getCursorIndex(template);
        template = this.replaceVariables(template, CURSOR_INSERTS);
        try {
            int length = this.getLength();
            DocumentUtils.replace(component.getDocument(), this.startIndex, length, template);
            component.getCaret().setDot(this.startIndex + cursorIndex);
        }
        catch (BadLocationException ex) {
            throw new UndeclaredThrowableException(ex);
        }
    }

    private int getCursorIndex(String template) {
        Matcher matcher = INSERT.matcher(template);
        while (matcher.find()) {
            String match = matcher.group(2);
            if (!CURSOR.equals(match)) continue;
            String leadingDollar = matcher.group(1);
            leadingDollar = leadingDollar != null ? leadingDollar : "";
            return matcher.start() + leadingDollar.length() / 2;
        }
        return template.length();
    }

    private String replaceVariables(String template, Filter<String> filter) {
        Matcher matcher = INSERT.matcher(template);
        StringBuffer sb = new StringBuffer(template.length());
        while (matcher.find()) {
            String replacement;
            String type = matcher.group(2);
            if (!filter.matches(type)) continue;
            String dollars = matcher.group(1);
            int dollarCount = dollars.length();
            if (dollarCount % 2 == 0) {
                replacement = matcher.group().substring(dollarCount / 2);
            } else {
                Preconditions.checkState((type != null ? 1 : 0) != 0, (Object)"Template has incomplete variables. Type '$$' to enter the dollar character.");
                replacement = dollars.substring((dollarCount + 1) / 2) + this.getReplacement(type);
            }
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String getReplacement(String variable) {
        switch (variable) {
            case "cursor": {
                return "";
            }
            case "token": {
                return this.getTokenString();
            }
        }
        throw new IllegalArgumentException("Unknown variable '" + variable + "'");
    }

    private String getTokenString() {
        if (this.token != null) {
            return this.token.getText();
        }
        return "";
    }

    private int getLength() {
        if (this.token != null) {
            return this.token.getStopIndex() - this.startIndex + 1;
        }
        return 0;
    }

    protected abstract String getTemplate();

    public abstract String getDisplayName();

    public abstract boolean shouldBeProposed(AutoCompletionContext var1);
}

