/*
 * Decompiled with CFR 0.152.
 */
package de.adrodoc55.minecraft.mpl.ide.autocompletion;

import de.adrodoc55.minecraft.mpl.antlr.MplLexer;
import de.adrodoc55.minecraft.mpl.antlr.MplParser;
import de.adrodoc55.minecraft.mpl.ide.autocompletion.AutoCompletionAction;
import de.adrodoc55.minecraft.mpl.ide.autocompletion.AutoCompletionContext;
import de.adrodoc55.minecraft.mpl.ide.autocompletion.AutoCompletionListener;
import de.adrodoc55.minecraft.mpl.ide.autocompletion.NewDoWhileAction;
import de.adrodoc55.minecraft.mpl.ide.autocompletion.NewIfAction;
import de.adrodoc55.minecraft.mpl.ide.autocompletion.NewIfElseAction;
import de.adrodoc55.minecraft.mpl.ide.autocompletion.NewIncludeAction;
import de.adrodoc55.minecraft.mpl.ide.autocompletion.NewProcessAction;
import de.adrodoc55.minecraft.mpl.ide.autocompletion.NewWhileAction;
import de.adrodoc55.minecraft.mpl.ide.autocompletion.ResultException;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class AutoCompletion {
    private AutoCompletion() throws Throwable {
        throw new Throwable("Utils Classes cannot be instantiated!");
    }

    public static AutoCompletionContext getContext(int index, String text) {
        ANTLRInputStream input = new ANTLRInputStream(text);
        MplLexer lexer = new MplLexer((CharStream)input);
        lexer.removeErrorListeners();
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        MplParser parser = new MplParser((TokenStream)tokens);
        parser.removeErrorListeners();
        MplParser.FileContext ctx = parser.file();
        AutoCompletionListener listener = new AutoCompletionListener(index);
        try {
            new ParseTreeWalker().walk((ParseTreeListener)listener, (ParseTree)ctx);
        }
        catch (ResultException earlyExit) {
            return earlyExit.getResult();
        }
        return null;
    }

    public static List<AutoCompletionAction> getOptions(int index, String text) {
        AutoCompletionContext context = AutoCompletion.getContext(index, text);
        ArrayList<AutoCompletionAction> options = new ArrayList<AutoCompletionAction>();
        if (context == null) {
            return options;
        }
        Token token = context.getToken();
        for (AutoCompletionAction action : AutoCompletion.getAllActions(index, token)) {
            if (!action.shouldBeProposed(context)) continue;
            options.add(action);
        }
        return options;
    }

    private static List<AutoCompletionAction> getAllActions(int index, Token token) {
        ArrayList<AutoCompletionAction> actions = new ArrayList<AutoCompletionAction>();
        actions.add(new NewIncludeAction(index, token));
        actions.add(new NewIfAction(index, token));
        actions.add(new NewIfElseAction(index, token));
        actions.add(new NewWhileAction(index, token));
        actions.add(new NewDoWhileAction(index, token));
        actions.add(new NewProcessAction(index, token));
        return actions;
    }
}

