/*
 * Decompiled with CFR 0.152.
 */
package de.adrodoc55.minecraft.mpl.ide.gui.editor;

import de.adrodoc55.minecraft.mpl.ide.gui.editor.CaretUpdateEvent;
import de.adrodoc55.minecraft.mpl.ide.gui.editor.EditorPM;
import de.adrodoc55.minecraft.mpl.ide.gui.editor.UndoableBnStyledDocument;
import de.adrodoc55.minecraft.mpl.ide.gui.editor.UndoableBnStyledEditorKit;
import de.adrodoc55.minecraft.mpl.ide.gui.utils.NoWrapBnTextPane;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.lang.reflect.UndeclaredThrowableException;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import javax.swing.undo.UndoManager;
import org.beanfabrics.Path;
import org.beanfabrics.swing.internal.BnStyledDocument;

public class BnEditorTextPane
extends NoWrapBnTextPane {
    private static final long serialVersionUID = 1L;
    private final Context context;
    private DocumentListener caretListener;
    private UndoManager undoManager;

    public BnEditorTextPane(Context context) {
        this.context = context;
        this.setFont(new Font("Consolas", 0, 13));
        this.setPath(new Path("this.code"));
        this.initUndo();
        this.initRedo();
        this.initSave();
        this.initDeleteLine();
    }

    @Override
    protected EditorKit createDefaultEditorKit() {
        return new UndoableBnStyledEditorKit();
    }

    @Override
    public UndoableBnStyledDocument getDocument() {
        return (UndoableBnStyledDocument)super.getDocument();
    }

    @Override
    public void setDocument(Document doc) {
        if (doc instanceof UndoableBnStyledDocument) {
            UndoableBnStyledDocument oldDoc = this.getDocument();
            if (oldDoc != null) {
                oldDoc.removeDocumentListener(this.getCaretListener());
                ((AbstractDocument)oldDoc).removeUndoableEditListener(this.getUndoManager());
            }
        } else {
            throw new IllegalArgumentException("Model must be UndoableBnStyledDocument");
        }
        doc.addDocumentListener(this.getCaretListener());
        doc.addUndoableEditListener(this.getUndoManager());
        super.setDocument(doc);
    }

    @Override
    public UndoableBnStyledDocument getStyledDocument() {
        return this.getDocument();
    }

    @Override
    public void setStyledDocument(StyledDocument doc) {
        this.setDocument(doc);
    }

    public DocumentListener getCaretListener() {
        if (this.caretListener == null) {
            this.caretListener = new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    if (e instanceof CaretUpdateEvent) {
                        BnEditorTextPane.this.setCaretPosition(e.getOffset());
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    if (e instanceof CaretUpdateEvent) {
                        BnEditorTextPane.this.setCaretPosition(e.getOffset() + e.getLength());
                    }
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    if (e instanceof CaretUpdateEvent) {
                        BnEditorTextPane.this.setCaretPosition(e.getOffset() + e.getLength());
                    }
                }
            };
        }
        return this.caretListener;
    }

    public UndoManager getUndoManager() {
        if (this.undoManager == null) {
            this.undoManager = new UndoManager();
            this.undoManager.setLimit(-1);
        }
        return this.undoManager;
    }

    public void initUndo() {
        int ctrl = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.getInputMap().put(KeyStroke.getKeyStroke(90, ctrl), "undo");
        this.getActionMap().put("undo", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BnEditorTextPane.this.undoManager.canUndo()) {
                    BnEditorTextPane.this.undoManager.undo();
                }
            }
        });
    }

    public void initRedo() {
        int ctrl = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.getInputMap().put(KeyStroke.getKeyStroke(89, ctrl), "redo");
        this.getActionMap().put("redo", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BnEditorTextPane.this.undoManager.canRedo()) {
                    BnEditorTextPane.this.undoManager.redo();
                }
            }
        });
    }

    public void initSave() {
        int ctrl = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.getInputMap().put(KeyStroke.getKeyStroke(83, ctrl), "save");
        this.getActionMap().put("save", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorPM pm = BnEditorTextPane.this.context.getPresentationModel();
                if (pm != null) {
                    pm.save();
                }
            }
        });
    }

    public void initDeleteLine() {
        int ctrl = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.getInputMap().put(KeyStroke.getKeyStroke(68, ctrl), "delete");
        this.getActionMap().put("delete", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                UndoableBnStyledDocument doc = BnEditorTextPane.this.getDocument();
                Element root = doc.getDefaultRootElement();
                int elementIndex = root.getElementIndex(BnEditorTextPane.this.getCaretPosition());
                Element line = root.getElement(elementIndex);
                int start = line.getStartOffset();
                int length = line.getEndOffset() - start;
                if (doc.getLength() < start + length) {
                    if (start == 0) {
                        --length;
                    } else {
                        --start;
                    }
                }
                try {
                    ((BnStyledDocument)doc).remove(start, length);
                }
                catch (BadLocationException ex) {
                    throw new UndeclaredThrowableException(ex);
                }
            }
        });
    }

    public static interface Context {
        public EditorPM getPresentationModel();
    }
}

