/*
 * Decompiled with CFR 0.152.
 */
package de.adrodoc55.minecraft.mpl.ide.gui.dialog.searchandreplace;

import de.adrodoc55.commons.DocumentUtils;
import de.adrodoc55.commons.RegexUtils;
import de.adrodoc55.commons.StringUnescaper;
import de.adrodoc55.commons.beanfabrics.OptionsUtils;
import java.awt.Toolkit;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.beanfabrics.model.AbstractPM;
import org.beanfabrics.model.BooleanPM;
import org.beanfabrics.model.OperationPM;
import org.beanfabrics.model.Options;
import org.beanfabrics.model.PMManager;
import org.beanfabrics.model.PresentationModel;
import org.beanfabrics.model.TextPM;
import org.beanfabrics.support.Operation;
import org.beanfabrics.support.Validation;
import org.beanfabrics.util.Interval;
import org.beanfabrics.validation.ValidationState;

public class SearchAndReplaceDialogPM
extends AbstractPM {
    private final Context context;
    TextPM search = new TextPM();
    Options<String> searchOptions = new Options();
    TextPM replaceWith = new TextPM();
    Options<String> replaceWithOptions = new Options();
    BooleanPM caseSensitive = new BooleanPM();
    BooleanPM wholeWord = new BooleanPM();
    BooleanPM regex = new BooleanPM();
    BooleanPM wrapSearch = new BooleanPM();
    BooleanPM incremental = new BooleanPM();
    BooleanPM extended = new BooleanPM();
    OperationPM find = new OperationPM();
    OperationPM replace = new OperationPM();
    OperationPM replaceFind = new OperationPM();
    OperationPM replaceAll = new OperationPM();

    public SearchAndReplaceDialogPM(Context context) {
        this.context = context;
        this.searchOptions.put((Object)"", "");
        this.search.setOptions(this.searchOptions);
        this.search.setRestrictedToOptions(false);
        this.replaceWithOptions.put((Object)"", "");
        this.replaceWith.setOptions(this.replaceWithOptions);
        this.replaceWith.setRestrictedToOptions(false);
        this.wrapSearch.setBoolean(Boolean.valueOf(true));
        this.incremental.setBoolean(Boolean.valueOf(true));
        this.search.addPropertyChangeListener("text", e -> {
            if (this.incremental.getBoolean().booleanValue() && this.canFind() == null) {
                this.findIncremental();
            }
        });
        this.regex.addPropertyChangeListener(e -> {
            if (this.regex.getBoolean().booleanValue()) {
                this.wholeWord.setEditable(false);
            } else {
                this.wholeWord.setEditable(true);
            }
        });
        PMManager.setup((PresentationModel)this);
    }

    public JTextComponent getComponent() {
        return this.context.getComponent();
    }

    public void setSearch(String search) {
        if (this.regex.getBoolean().booleanValue()) {
            String escaped = RegexUtils.escape(search);
            this.search.setText(escaped);
        } else {
            this.search.setText(search);
        }
    }

    private String getReplaceWithText() {
        String text = this.replaceWith.getText();
        if (this.extended.getBoolean().booleanValue()) {
            return StringUnescaper.unescape_perl_string(text);
        }
        return text;
    }

    public boolean isWholeWord() {
        return this.wholeWord.isEditable() && this.wholeWord.getBoolean() != false;
    }

    public void findIncremental() {
        this.find.check();
        JTextComponent component = this.getComponent();
        Caret caret = component.getCaret();
        int startIndex = Math.min(caret.getDot(), caret.getMark());
        Document doc = component.getDocument();
        int length = doc.getLength() - startIndex;
        Interval result = this.search(startIndex, length);
        if (result == null && this.wrapSearch.getBoolean().booleanValue()) {
            result = this.search(0, doc.getLength());
        }
        if (result == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        caret.setDot(result.startIndex);
        caret.moveDot(result.endIndex);
        caret.setSelectionVisible(true);
    }

    @Operation
    public void find() {
        this.find.check();
        JTextComponent component = this.getComponent();
        Caret caret = component.getCaret();
        int startIndex = caret.getDot();
        Document doc = component.getDocument();
        int length = doc.getLength() - startIndex;
        Interval result = this.search(startIndex, length);
        if (result == null && this.wrapSearch.getBoolean().booleanValue()) {
            result = this.search(0, doc.getLength());
        }
        if (result == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        caret.setDot(result.startIndex);
        caret.moveDot(result.endIndex);
        caret.setSelectionVisible(true);
        String searchText = this.search.getText();
        OptionsUtils.put(this.searchOptions, searchText);
        this.searchOptions.remove((Object)"");
    }

    private Interval search(int offset, int length) {
        int startIndex;
        int endIndex;
        Pattern pattern;
        String text;
        JTextComponent component = this.getComponent();
        Document doc = component.getDocument();
        try {
            text = doc.getText(offset, length);
        }
        catch (BadLocationException ex) {
            throw new UndeclaredThrowableException(ex);
        }
        String searchText = this.search.getText();
        if (this.regex.getBoolean().booleanValue()) {
            try {
                pattern = this.caseSensitive.getBoolean().booleanValue() ? Pattern.compile(searchText) : Pattern.compile(searchText, 2);
            }
            catch (PatternSyntaxException ex) {
                return null;
            }
            Matcher matcher = pattern.matcher(text);
            do {
                if (!matcher.find()) {
                    startIndex = -1;
                    endIndex = -1;
                    break;
                }
                startIndex = matcher.start();
                endIndex = matcher.end();
            } while (endIndex - startIndex <= 0);
        } else if (this.isWholeWord()) {
            searchText = "\\b" + Pattern.quote(searchText) + "\\b";
            pattern = this.caseSensitive.getBoolean() != false ? Pattern.compile(searchText) : Pattern.compile(searchText, 2);
            Matcher matcher = pattern.matcher(text);
            if (matcher.find()) {
                startIndex = matcher.start();
                endIndex = matcher.end();
            } else {
                startIndex = -1;
                endIndex = -1;
            }
        } else {
            startIndex = this.caseSensitive.getBoolean() != false ? text.indexOf(searchText) : text.toLowerCase().indexOf(searchText.toLowerCase());
            endIndex = startIndex + searchText.length();
        }
        if (startIndex == -1) {
            return null;
        }
        Interval interval = new Interval(startIndex += offset, endIndex += offset);
        return interval;
    }

    @Validation(path={"find", "search"})
    public ValidationState canFind() {
        if (this.search.isEmpty()) {
            return new ValidationState("Cannot search for empty String");
        }
        if (this.regex.getBoolean().booleanValue()) {
            try {
                Pattern.compile(this.search.getText());
            }
            catch (PatternSyntaxException ex) {
                String rawMessage = ex.getLocalizedMessage();
                if (rawMessage.contains("\n")) {
                    rawMessage = "<html>Invalid Regex:<br><pre>" + rawMessage.replaceAll("\r?\n", "<br>") + "</pre></html>";
                }
                return new ValidationState(rawMessage);
            }
        }
        return null;
    }

    @Operation
    public void replace() {
        this.replace.check();
        JTextComponent component = this.getComponent();
        component.replaceSelection(this.getReplaceWithText());
        String replaceWithText = this.replaceWith.getText();
        OptionsUtils.put(this.replaceWithOptions, replaceWithText);
        this.replaceWithOptions.remove((Object)"");
    }

    private ValidationState canReplaceWithText() {
        try {
            this.getReplaceWithText();
        }
        catch (IllegalArgumentException ex) {
            return new ValidationState("Invalid escape: " + ex.getLocalizedMessage());
        }
        return null;
    }

    @Validation(path={"replace"})
    public ValidationState canReplace() {
        JTextComponent component = this.getComponent();
        Caret caret = component.getCaret();
        if (caret.getDot() == caret.getMark()) {
            return new ValidationState("Nothing selected");
        }
        ValidationState canReplaceWithText = this.canReplaceWithText();
        if (canReplaceWithText != null) {
            return canReplaceWithText;
        }
        return null;
    }

    @Operation
    public void replaceFind() throws BadLocationException {
        this.replaceFind.check();
        if (this.canReplace() == null) {
            this.replace();
        }
        this.find();
    }

    @Validation(path={"replaceFind"})
    public ValidationState canReplaceFind() {
        ValidationState canFind = this.canFind();
        if (canFind != null) {
            return canFind;
        }
        ValidationState canReplaceWithText = this.canReplaceWithText();
        if (canReplaceWithText != null) {
            return canReplaceWithText;
        }
        return null;
    }

    @Operation
    public void replaceAll() {
        Interval found;
        this.replaceAll.check();
        Document doc = this.getComponent().getDocument();
        String replaceWithText = this.getReplaceWithText();
        int i = 0;
        while ((found = this.search(i, doc.getLength() - i)) != null) {
            int offset = found.startIndex;
            int length = found.endIndex - offset;
            try {
                DocumentUtils.replace(doc, offset, length, replaceWithText);
            }
            catch (BadLocationException ex) {
                throw new UndeclaredThrowableException(ex);
            }
            i = found.endIndex;
        }
    }

    @Validation(path={"replaceAll"})
    public ValidationState canReplaceAll() {
        return this.canReplaceFind();
    }

    public static interface Context {
        public JTextComponent getComponent();
    }
}

