/*
 * Decompiled with CFR 0.152.
 */
package de.adrodoc55.minecraft.mpl.ide.gui.dialog;

import de.adrodoc55.minecraft.mpl.ide.gui.dialog.WindowView;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import javax.annotation.Nonnull;
import org.beanfabrics.model.PresentationModel;

public abstract class WindowController<V extends WindowView<PM>, PM extends PresentationModel> {
    private V view;
    private PM pm;

    @Nonnull
    public V getView() {
        if (this.view == null) {
            Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            this.view = this.createView(activeWindow);
            this.view.setPresentationModel(this.getPresentationModel());
        }
        return this.view;
    }

    protected abstract V createView(Window var1);

    @Nonnull
    public PM getPresentationModel() {
        if (this.pm == null) {
            this.pm = this.createPM();
        }
        return this.pm;
    }

    protected abstract PM createPM();

    public void dispose() {
        if (this.hasView()) {
            this.getView().dispose();
        }
    }

    public boolean hasView() {
        return this.view != null;
    }

    public void setLocation(Component source, Point location) {
        int fontSize = source.getFont().getSize();
        location.translate(1, fontSize + 3);
        Point screenPos = source.getLocationOnScreen();
        location.translate(screenPos.x, screenPos.y);
        this.getView().setLocation(location);
    }
}

