/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.serviceloader;

import de.adorsys.xs2a.adapter.api.AccountInformationService;
import de.adorsys.xs2a.adapter.api.RequestHeaders;
import de.adorsys.xs2a.adapter.api.RequestParams;
import de.adorsys.xs2a.adapter.api.Response;
import de.adorsys.xs2a.adapter.api.model.AccountList;
import de.adorsys.xs2a.adapter.api.model.Authorisations;
import de.adorsys.xs2a.adapter.api.model.CardAccountList;
import de.adorsys.xs2a.adapter.api.model.CardAccountsTransactionsResponse200;
import de.adorsys.xs2a.adapter.api.model.ConsentInformationResponse200Json;
import de.adorsys.xs2a.adapter.api.model.ConsentStatusResponse200;
import de.adorsys.xs2a.adapter.api.model.Consents;
import de.adorsys.xs2a.adapter.api.model.ConsentsResponse201;
import de.adorsys.xs2a.adapter.api.model.OK200AccountDetails;
import de.adorsys.xs2a.adapter.api.model.OK200CardAccountDetails;
import de.adorsys.xs2a.adapter.api.model.OK200TransactionDetails;
import de.adorsys.xs2a.adapter.api.model.ReadAccountBalanceResponse200;
import de.adorsys.xs2a.adapter.api.model.ReadCardAccountBalanceResponse200;
import de.adorsys.xs2a.adapter.api.model.ScaStatusResponse;
import de.adorsys.xs2a.adapter.api.model.SelectPsuAuthenticationMethod;
import de.adorsys.xs2a.adapter.api.model.SelectPsuAuthenticationMethodResponse;
import de.adorsys.xs2a.adapter.api.model.StartScaprocessResponse;
import de.adorsys.xs2a.adapter.api.model.TransactionAuthorisation;
import de.adorsys.xs2a.adapter.api.model.TransactionsResponse200Json;
import de.adorsys.xs2a.adapter.api.model.UpdatePsuAuthentication;
import de.adorsys.xs2a.adapter.api.model.UpdatePsuAuthenticationResponse;
import de.adorsys.xs2a.adapter.serviceloader.AdapterServiceLoader;

public class AccountInformationServiceImpl
implements AccountInformationService {
    private final AdapterServiceLoader adapterServiceLoader;

    public AccountInformationServiceImpl(AdapterServiceLoader adapterServiceLoader) {
        this.adapterServiceLoader = adapterServiceLoader;
    }

    public Response<ConsentsResponse201> createConsent(RequestHeaders requestHeaders, RequestParams requestParams, Consents consents) {
        return this.getAccountInformationService(requestHeaders).createConsent(requestHeaders, requestParams, consents);
    }

    private AccountInformationService getAccountInformationService(RequestHeaders requestHeaders) {
        return this.adapterServiceLoader.getAccountInformationService(requestHeaders);
    }

    public Response<ConsentInformationResponse200Json> getConsentInformation(String consentId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return this.getAccountInformationService(requestHeaders).getConsentInformation(consentId, requestHeaders, requestParams);
    }

    public Response<Void> deleteConsent(String consentId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return this.getAccountInformationService(requestHeaders).deleteConsent(consentId, requestHeaders, requestParams);
    }

    public Response<ConsentStatusResponse200> getConsentStatus(String consentId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return this.getAccountInformationService(requestHeaders).getConsentStatus(consentId, requestHeaders, requestParams);
    }

    public Response<Authorisations> getConsentAuthorisation(String consentId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return this.getAccountInformationService(requestHeaders).getConsentAuthorisation(consentId, requestHeaders, requestParams);
    }

    public Response<StartScaprocessResponse> startConsentAuthorisation(String consentId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return this.getAccountInformationService(requestHeaders).startConsentAuthorisation(consentId, requestHeaders, requestParams);
    }

    public Response<StartScaprocessResponse> startConsentAuthorisation(String consentId, RequestHeaders requestHeaders, RequestParams requestParams, UpdatePsuAuthentication updatePsuAuthentication) {
        return this.getAccountInformationService(requestHeaders).startConsentAuthorisation(consentId, requestHeaders, requestParams, updatePsuAuthentication);
    }

    public Response<SelectPsuAuthenticationMethodResponse> updateConsentsPsuData(String consentId, String authorisationId, RequestHeaders requestHeaders, RequestParams requestParams, SelectPsuAuthenticationMethod selectPsuAuthenticationMethod) {
        return this.getAccountInformationService(requestHeaders).updateConsentsPsuData(consentId, authorisationId, requestHeaders, requestParams, selectPsuAuthenticationMethod);
    }

    public Response<ScaStatusResponse> updateConsentsPsuData(String consentId, String authorisationId, RequestHeaders requestHeaders, RequestParams requestParams, TransactionAuthorisation transactionAuthorisation) {
        return this.getAccountInformationService(requestHeaders).updateConsentsPsuData(consentId, authorisationId, requestHeaders, requestParams, transactionAuthorisation);
    }

    public Response<UpdatePsuAuthenticationResponse> updateConsentsPsuData(String consentId, String authorisationId, RequestHeaders requestHeaders, RequestParams requestParams, UpdatePsuAuthentication updatePsuAuthentication) {
        return this.getAccountInformationService(requestHeaders).updateConsentsPsuData(consentId, authorisationId, requestHeaders, requestParams, updatePsuAuthentication);
    }

    public Response<AccountList> getAccountList(RequestHeaders requestHeaders, RequestParams requestParams) {
        return this.getAccountInformationService(requestHeaders).getAccountList(requestHeaders, requestParams);
    }

    public Response<OK200AccountDetails> readAccountDetails(String accountId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return this.getAccountInformationService(requestHeaders).readAccountDetails(accountId, requestHeaders, requestParams);
    }

    public Response<TransactionsResponse200Json> getTransactionList(String accountId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return this.getAccountInformationService(requestHeaders).getTransactionList(accountId, requestHeaders, requestParams);
    }

    public Response<OK200TransactionDetails> getTransactionDetails(String accountId, String transactionId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return this.getAccountInformationService(requestHeaders).getTransactionDetails(accountId, transactionId, requestHeaders, requestParams);
    }

    public Response<String> getTransactionListAsString(String accountId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return this.getAccountInformationService(requestHeaders).getTransactionListAsString(accountId, requestHeaders, requestParams);
    }

    public Response<ScaStatusResponse> getConsentScaStatus(String consentId, String authorisationId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return this.getAccountInformationService(requestHeaders).getConsentScaStatus(consentId, authorisationId, requestHeaders, requestParams);
    }

    public Response<ReadAccountBalanceResponse200> getBalances(String accountId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return this.getAccountInformationService(requestHeaders).getBalances(accountId, requestHeaders, requestParams);
    }

    public Response<CardAccountList> getCardAccountList(RequestHeaders requestHeaders, RequestParams requestParams) {
        return this.getAccountInformationService(requestHeaders).getCardAccountList(requestHeaders, requestParams);
    }

    public Response<OK200CardAccountDetails> getCardAccountDetails(String accountId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return this.getAccountInformationService(requestHeaders).getCardAccountDetails(accountId, requestHeaders, requestParams);
    }

    public Response<ReadCardAccountBalanceResponse200> getCardAccountBalances(String accountId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return this.getAccountInformationService(requestHeaders).getCardAccountBalances(accountId, requestHeaders, requestParams);
    }

    public Response<CardAccountsTransactionsResponse200> getCardAccountTransactionList(String accountId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return this.getAccountInformationService(requestHeaders).getCardAccountTransactionList(accountId, requestHeaders, requestParams);
    }
}

