/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.serviceloader;

import de.adorsys.xs2a.adapter.api.AccountInformationService;
import de.adorsys.xs2a.adapter.api.AccountInformationServiceProvider;
import de.adorsys.xs2a.adapter.api.AdapterServiceProvider;
import de.adorsys.xs2a.adapter.api.AspspReadOnlyRepository;
import de.adorsys.xs2a.adapter.api.DownloadService;
import de.adorsys.xs2a.adapter.api.DownloadServiceProvider;
import de.adorsys.xs2a.adapter.api.EmbeddedPreAuthorisationService;
import de.adorsys.xs2a.adapter.api.EmbeddedPreAuthorisationServiceProvider;
import de.adorsys.xs2a.adapter.api.Oauth2Service;
import de.adorsys.xs2a.adapter.api.Oauth2ServiceProvider;
import de.adorsys.xs2a.adapter.api.PaymentInitiationService;
import de.adorsys.xs2a.adapter.api.PaymentInitiationServiceProvider;
import de.adorsys.xs2a.adapter.api.RequestHeaders;
import de.adorsys.xs2a.adapter.api.exception.AdapterNotFoundException;
import de.adorsys.xs2a.adapter.api.exception.AspspRegistrationNotFoundException;
import de.adorsys.xs2a.adapter.api.http.HttpClientFactory;
import de.adorsys.xs2a.adapter.api.link.LinksRewriter;
import de.adorsys.xs2a.adapter.api.model.Aspsp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;
import org.slf4j.MDC;

public class AdapterServiceLoader {
    private static final String EMPTY_STRING = "";
    private final AspspReadOnlyRepository aspspRepository;
    protected final HttpClientFactory httpClientFactory;
    protected final LinksRewriter accountInformationLinksRewriter;
    protected final LinksRewriter paymentInitiationLinksRewriter;
    private final Map<Class<?>, ServiceLoader<? extends AdapterServiceProvider>> serviceLoaders = new HashMap();
    protected final boolean chooseFirstFromMultipleAspsps;
    protected final boolean wiremockValidationEnabled;

    public AdapterServiceLoader(AspspReadOnlyRepository aspspRepository, HttpClientFactory httpClientFactory, LinksRewriter accountInformationLinksRewriter, LinksRewriter paymentInitiationLinksRewriter, boolean chooseFirstFromMultipleAspsps) {
        this(aspspRepository, httpClientFactory, accountInformationLinksRewriter, paymentInitiationLinksRewriter, chooseFirstFromMultipleAspsps, false);
    }

    public AdapterServiceLoader(AspspReadOnlyRepository aspspRepository, HttpClientFactory httpClientFactory, LinksRewriter accountInformationLinksRewriter, LinksRewriter paymentInitiationLinksRewriter, boolean chooseFirstFromMultipleAspsps, boolean wiremockValidationEnabled) {
        this.aspspRepository = aspspRepository;
        this.accountInformationLinksRewriter = accountInformationLinksRewriter;
        this.paymentInitiationLinksRewriter = paymentInitiationLinksRewriter;
        this.chooseFirstFromMultipleAspsps = chooseFirstFromMultipleAspsps;
        this.httpClientFactory = httpClientFactory;
        this.wiremockValidationEnabled = wiremockValidationEnabled;
    }

    public AccountInformationService getAccountInformationService(RequestHeaders requestHeaders) {
        Aspsp aspsp = this.getAspsp(requestHeaders);
        String adapterId = aspsp.getAdapterId();
        AccountInformationServiceProvider provider = this.getServiceProvider(AccountInformationServiceProvider.class, adapterId).orElseThrow(() -> new AdapterNotFoundException(adapterId));
        provider.wiremockValidationEnabled(this.wiremockValidationEnabled);
        return provider.getAccountInformationService(aspsp, this.httpClientFactory, this.accountInformationLinksRewriter);
    }

    protected Aspsp getAspsp(RequestHeaders requestHeaders) {
        List aspsps;
        Optional aspspId = requestHeaders.getAspspId();
        Optional bankCode = requestHeaders.getBankCode();
        Optional bic = requestHeaders.getBic();
        Optional iban = requestHeaders.getIban();
        if (aspspId.isPresent()) {
            return (Aspsp)this.aspspRepository.findById((String)aspspId.get()).orElseThrow(() -> new AspspRegistrationNotFoundException("No ASPSP was found with id: " + (String)aspspId.get()));
        }
        if (!(bankCode.isPresent() || bic.isPresent() || iban.isPresent())) {
            throw new AspspRegistrationNotFoundException("None of X-GTW-ASPSP-ID, X-GTW-BIC, X-GTW-Bank-Code, X-GTW-IBAN headers were provided to identify the ASPSP");
        }
        if (iban.isPresent()) {
            aspsps = this.aspspRepository.findByIban((String)iban.get());
        } else if (bankCode.isPresent() && bic.isPresent()) {
            Aspsp aspsp = new Aspsp();
            aspsp.setBankCode((String)bankCode.get());
            aspsp.setBic((String)bic.get());
            aspsps = this.aspspRepository.findLike(aspsp);
        } else {
            aspsps = bankCode.isPresent() ? this.aspspRepository.findByBankCode((String)bankCode.get()) : this.aspspRepository.findByBic((String)bic.get());
        }
        if (aspsps.isEmpty()) {
            throw new AspspRegistrationNotFoundException(this.buildAspspNotFoundErrorMessage(bankCode.orElse(EMPTY_STRING), bic.orElse(EMPTY_STRING)));
        }
        if (aspsps.size() > 1 && !this.chooseFirstFromMultipleAspsps) {
            throw new AspspRegistrationNotFoundException(this.buildAspspCouldNotBeIdentifiedErrorMessage(aspsps.size(), bankCode.orElse(EMPTY_STRING), bic.orElse(EMPTY_STRING)));
        }
        return (Aspsp)aspsps.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends AdapterServiceProvider> Optional<T> getServiceProvider(Class<T> klass, String adapterId) {
        Optional<AdapterServiceProvider> serviceProvider;
        MDC.put((String)"adapterId", (String)adapterId);
        Map<Class<?>, ServiceLoader<? extends AdapterServiceProvider>> map = this.serviceLoaders;
        synchronized (map) {
            serviceProvider = StreamSupport.stream(this.getServiceLoader(klass).spliterator(), false).filter(provider -> provider.getAdapterId().equalsIgnoreCase(adapterId)).findFirst();
        }
        return serviceProvider;
    }

    private <T extends AdapterServiceProvider> ServiceLoader<T> getServiceLoader(Class<T> klass) {
        return this.serviceLoaders.computeIfAbsent(klass, k -> ServiceLoader.load(klass));
    }

    public PaymentInitiationService getPaymentInitiationService(RequestHeaders requestHeaders) {
        Aspsp aspsp = this.getAspsp(requestHeaders);
        String adapterId = aspsp.getAdapterId();
        PaymentInitiationServiceProvider provider = this.getServiceProvider(PaymentInitiationServiceProvider.class, adapterId).orElseThrow(() -> new AdapterNotFoundException(adapterId));
        provider.wiremockValidationEnabled(this.wiremockValidationEnabled);
        return provider.getPaymentInitiationService(aspsp, this.httpClientFactory, this.paymentInitiationLinksRewriter);
    }

    public Oauth2Service getOauth2Service(RequestHeaders requestHeaders) {
        Aspsp aspsp = this.getAspsp(requestHeaders);
        String adapterId = aspsp.getAdapterId();
        return this.getServiceProvider(Oauth2ServiceProvider.class, adapterId).orElseThrow(() -> new AdapterNotFoundException(adapterId)).getOauth2Service(aspsp, this.httpClientFactory);
    }

    public DownloadService getDownloadService(RequestHeaders requestHeaders) {
        Aspsp aspsp = this.getAspsp(requestHeaders);
        String adapterId = aspsp.getAdapterId();
        String baseUrl = Optional.ofNullable(aspsp.getIdpUrl()).orElseGet(() -> ((Aspsp)aspsp).getUrl());
        return this.getServiceProvider(DownloadServiceProvider.class, adapterId).orElseThrow(() -> new AdapterNotFoundException(adapterId)).getDownloadService(baseUrl, this.httpClientFactory);
    }

    public EmbeddedPreAuthorisationService getEmbeddedPreAuthorisationService(RequestHeaders requestHeaders) {
        Aspsp aspsp = this.getAspsp(requestHeaders);
        String adapterId = aspsp.getAdapterId();
        return this.getServiceProvider(EmbeddedPreAuthorisationServiceProvider.class, adapterId).orElseThrow(() -> new AdapterNotFoundException(adapterId)).getEmbeddedPreAuthorisationService(aspsp, this.httpClientFactory);
    }

    private String buildAspspNotFoundErrorMessage(String bankCode, String bic) {
        return this.appendNotEmptyBankCodeAndBic(new StringBuilder("No ASPSP was found with "), bankCode, bic);
    }

    private String buildAspspCouldNotBeIdentifiedErrorMessage(int numberOfEntries, String bankCode, String bic) {
        return this.appendNotEmptyBankCodeAndBic(new StringBuilder(String.format("The ASPSP could not be identified: %s registry entries found for ", numberOfEntries)), bankCode, bic);
    }

    private String appendNotEmptyBankCodeAndBic(StringBuilder errorMessageBuilder, String bankCode, String bic) {
        if (!bankCode.isEmpty() && !bic.isEmpty()) {
            return errorMessageBuilder.append("bank code ").append(bankCode).append(" and ").append("BIC ").append(bic).toString();
        }
        if (!bankCode.isEmpty()) {
            return errorMessageBuilder.append("bank code ").append(bankCode).toString();
        }
        if (!bic.isEmpty()) {
            return errorMessageBuilder.append("BIC ").append(bic).toString();
        }
        return EMPTY_STRING;
    }
}

