/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.loader;

import de.adorsys.xs2a.adapter.service.AccountInformationService;
import de.adorsys.xs2a.adapter.service.RequestHeaders;
import de.adorsys.xs2a.adapter.service.RequestParams;
import de.adorsys.xs2a.adapter.service.Response;
import de.adorsys.xs2a.adapter.service.exception.BadRequestException;
import de.adorsys.xs2a.adapter.service.loader.mapper.Xs2aPsd2Mapper;
import de.adorsys.xs2a.adapter.service.model.SelectPsuAuthenticationMethod;
import de.adorsys.xs2a.adapter.service.model.TransactionAuthorisation;
import de.adorsys.xs2a.adapter.service.model.UpdatePsuAuthentication;
import de.adorsys.xs2a.adapter.service.psd2.Psd2AccountInformationService;
import de.adorsys.xs2a.adapter.service.psd2.model.AccountList;
import de.adorsys.xs2a.adapter.service.psd2.model.ConsentInformationResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.ConsentStatusResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.Consents;
import de.adorsys.xs2a.adapter.service.psd2.model.ConsentsResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.ReadAccountBalanceResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.ScaStatusResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.StartScaProcessResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.UpdateAuthorisation;
import de.adorsys.xs2a.adapter.service.psd2.model.UpdateAuthorisationResponse;
import java.io.IOException;
import java.util.Map;
import org.mapstruct.factory.Mappers;

class Xs2aPsd2AccountInformationServiceAdapter
implements Psd2AccountInformationService {
    private final AccountInformationService service;
    private final Xs2aPsd2Mapper mapper = (Xs2aPsd2Mapper)Mappers.getMapper(Xs2aPsd2Mapper.class);

    Xs2aPsd2AccountInformationServiceAdapter(AccountInformationService service) {
        this.service = service;
    }

    public Response<AccountList> getAccounts(Map<String, String> queryParameters, Map<String, String> headers) throws IOException {
        return this.service.getAccountList(RequestHeaders.fromMap(headers), RequestParams.fromMap(queryParameters)).map(this.mapper::toAccountList);
    }

    public Response<ReadAccountBalanceResponse> getBalances(String accountId, Map<String, String> queryParameters, Map<String, String> headers) throws IOException {
        return this.service.getBalances(accountId, RequestHeaders.fromMap(headers), RequestParams.fromMap(queryParameters)).map(this.mapper::toReadAccountBalanceResponse);
    }

    public Response getTransactions(String accountId, Map<String, String> queryParameters, Map<String, String> headers) throws IOException {
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        RequestParams requestParams = RequestParams.fromMap(queryParameters);
        if (requestHeaders.isAcceptJson()) {
            return this.service.getTransactionList(accountId, requestHeaders, requestParams).map(this.mapper::toTransactionsResponse);
        }
        return this.service.getTransactionListAsString(accountId, requestHeaders, requestParams);
    }

    public Response<ConsentsResponse> createConsent(Map<String, String> queryParameters, Map<String, String> headers, Consents consents) {
        return this.service.createConsent(RequestHeaders.fromMap(headers), RequestParams.fromMap(queryParameters), this.mapper.map(consents)).map(this.mapper::toConsentsResponse);
    }

    public Response<ConsentInformationResponse> getConsentInformation(String consentId, Map<String, String> queryParameters, Map<String, String> headers) {
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        RequestParams requestParams = RequestParams.fromMap(queryParameters);
        return this.service.getConsentInformation(consentId, requestHeaders, requestParams).map(this.mapper::toConsentInformationResponse);
    }

    public Response<Void> deleteConsent(String consentId, Map<String, String> queryParameters, Map<String, String> headers) {
        return this.service.deleteConsent(consentId, RequestHeaders.fromMap(headers), RequestParams.fromMap(queryParameters));
    }

    public Response<ConsentStatusResponse> getConsentStatus(String consentId, Map<String, String> queryParameters, Map<String, String> headers) {
        RequestParams requestParams = RequestParams.fromMap(queryParameters);
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        return this.service.getConsentStatus(consentId, requestHeaders, requestParams).map(this.mapper::toConsentStatusResponse);
    }

    public Response<ScaStatusResponse> getConsentScaStatus(String consentId, String authorisationId, Map<String, String> queryParameters, Map<String, String> headers) {
        return this.service.getConsentScaStatus(consentId, authorisationId, RequestHeaders.fromMap(headers), RequestParams.fromMap(queryParameters)).map(this.mapper::toScaStatusResponse);
    }

    public Response<StartScaProcessResponse> startConsentAuthorisation(String consentId, Map<String, String> queryParameters, Map<String, String> headers, UpdateAuthorisation updateAuthorisation) {
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        RequestParams requestParams = RequestParams.fromMap(queryParameters);
        if (updateAuthorisation.getPsuData() == null && updateAuthorisation.getAuthenticationMethodId() == null && updateAuthorisation.getScaAuthenticationData() == null) {
            return this.service.startConsentAuthorisation(consentId, requestHeaders, requestParams).map(this.mapper::toStartScaprocessResponse);
        }
        UpdatePsuAuthentication updatePsuAuthentication = this.mapper.map(updateAuthorisation);
        return this.service.startConsentAuthorisation(consentId, requestHeaders, requestParams, updatePsuAuthentication).map(this.mapper::toStartScaprocessResponse);
    }

    public Response<UpdateAuthorisationResponse> updateConsentsPsuData(String consentId, String authorisationId, Map<String, String> queryParameters, Map<String, String> headers, UpdateAuthorisation updateAuthorisation) {
        RequestHeaders requestHeaders = RequestHeaders.fromMap(headers);
        RequestParams requestParams = RequestParams.fromMap(queryParameters);
        if (updateAuthorisation.getAuthenticationMethodId() != null) {
            SelectPsuAuthenticationMethod selectPsuAuthenticationMethod = this.mapper.toSelectPsuAuthenticationMethod(updateAuthorisation);
            return this.service.updateConsentsPsuData(consentId, authorisationId, requestHeaders, requestParams, selectPsuAuthenticationMethod).map(this.mapper::toUpdateAuthorisationResponse);
        }
        if (updateAuthorisation.getPsuData() != null) {
            UpdatePsuAuthentication updatePsuAuthentication = this.mapper.toUpdatePsuAuthentication(updateAuthorisation);
            return this.service.updateConsentsPsuData(consentId, authorisationId, requestHeaders, requestParams, updatePsuAuthentication).map(this.mapper::toUpdateAuthorisationResponse);
        }
        if (updateAuthorisation.getScaAuthenticationData() != null) {
            TransactionAuthorisation transactionAuthorisation = this.mapper.toTransactionAuthorisation(updateAuthorisation);
            return this.service.updateConsentsPsuData(consentId, authorisationId, requestHeaders, requestParams, transactionAuthorisation).map(this.mapper::toUpdateAuthorisationResponse);
        }
        throw new BadRequestException("Request body doesn't match any of the supported schemas");
    }
}

