/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.loader;

import de.adorsys.xs2a.adapter.http.HttpClientFactory;
import de.adorsys.xs2a.adapter.service.AccountInformationService;
import de.adorsys.xs2a.adapter.service.AspspReadOnlyRepository;
import de.adorsys.xs2a.adapter.service.DownloadService;
import de.adorsys.xs2a.adapter.service.Oauth2Service;
import de.adorsys.xs2a.adapter.service.Oauth2ServiceFactory;
import de.adorsys.xs2a.adapter.service.PaymentInitiationService;
import de.adorsys.xs2a.adapter.service.Pkcs12KeyStore;
import de.adorsys.xs2a.adapter.service.RequestHeaders;
import de.adorsys.xs2a.adapter.service.exception.AdapterNotFoundException;
import de.adorsys.xs2a.adapter.service.exception.AspspRegistrationNotFoundException;
import de.adorsys.xs2a.adapter.service.model.Aspsp;
import de.adorsys.xs2a.adapter.service.provider.AccountInformationServiceProvider;
import de.adorsys.xs2a.adapter.service.provider.AdapterServiceProvider;
import de.adorsys.xs2a.adapter.service.provider.DownloadServiceProvider;
import de.adorsys.xs2a.adapter.service.provider.PaymentInitiationServiceProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;
import org.slf4j.MDC;

public class AdapterServiceLoader {
    private static final String EMPTY_STRING = "";
    private final AspspReadOnlyRepository aspspRepository;
    protected final Pkcs12KeyStore keyStore;
    protected final HttpClientFactory httpClientFactory;
    private final Map<Class<?>, ServiceLoader<? extends AdapterServiceProvider>> serviceLoaders = new HashMap();
    protected final boolean chooseFirstFromMultipleAspsps;

    public AdapterServiceLoader(AspspReadOnlyRepository aspspRepository, Pkcs12KeyStore keyStore, HttpClientFactory httpClientFactory, boolean chooseFirstFromMultipleAspsps) {
        this.aspspRepository = aspspRepository;
        this.keyStore = keyStore;
        this.httpClientFactory = httpClientFactory;
        this.chooseFirstFromMultipleAspsps = chooseFirstFromMultipleAspsps;
    }

    public AccountInformationService getAccountInformationService(RequestHeaders requestHeaders) {
        Aspsp aspsp = this.getAspsp(requestHeaders);
        String adapterId = aspsp.getAdapterId();
        return this.getServiceProvider(AccountInformationServiceProvider.class, adapterId).orElseThrow(() -> new AdapterNotFoundException(adapterId)).getAccountInformationService(aspsp, this.httpClientFactory, this.keyStore);
    }

    protected Aspsp getAspsp(RequestHeaders requestHeaders) {
        List aspsps;
        Optional aspspId = requestHeaders.getAspspId();
        Optional bankCode = requestHeaders.getBankCode();
        Optional bic = requestHeaders.getBic();
        Optional iban = requestHeaders.getIban();
        if (aspspId.isPresent()) {
            return (Aspsp)this.aspspRepository.findById((String)aspspId.get()).orElseThrow(() -> new AspspRegistrationNotFoundException("No ASPSP was found with id: " + (String)aspspId.get()));
        }
        if (!(bankCode.isPresent() || bic.isPresent() || iban.isPresent())) {
            throw new AspspRegistrationNotFoundException("None of X-GTW-ASPSP-ID, X-GTW-BIC, X-GTW-Bank-Code, X-GTW-IBAN headers were provided to identify the ASPSP");
        }
        if (iban.isPresent()) {
            aspsps = this.aspspRepository.findByIban((String)iban.get());
        } else if (bankCode.isPresent() && bic.isPresent()) {
            Aspsp aspsp = new Aspsp();
            aspsp.setBankCode((String)bankCode.get());
            aspsp.setBic((String)bic.get());
            aspsps = this.aspspRepository.findLike(aspsp);
        } else {
            aspsps = bankCode.isPresent() ? this.aspspRepository.findByBankCode((String)bankCode.get()) : this.aspspRepository.findByBic((String)bic.get());
        }
        if (aspsps.isEmpty()) {
            throw new AspspRegistrationNotFoundException(this.buildAspspNotFoundErrorMessage(bankCode.orElse(EMPTY_STRING), bic.orElse(EMPTY_STRING)));
        }
        if (aspsps.size() > 1 && !this.chooseFirstFromMultipleAspsps) {
            throw new AspspRegistrationNotFoundException(this.buildAspspCouldNotBeIdentifiedErrorMessage(aspsps.size(), bankCode.orElse(EMPTY_STRING), bic.orElse(EMPTY_STRING)));
        }
        return (Aspsp)aspsps.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends AdapterServiceProvider> Optional<T> getServiceProvider(Class<T> klass, String adapterId) {
        Optional<AdapterServiceProvider> serviceProvider;
        MDC.put((String)"adapterId", (String)adapterId);
        Map<Class<?>, ServiceLoader<? extends AdapterServiceProvider>> map = this.serviceLoaders;
        synchronized (map) {
            serviceProvider = StreamSupport.stream(this.getServiceLoader(klass).spliterator(), false).filter(provider -> provider.getAdapterId().equalsIgnoreCase(adapterId)).findFirst();
        }
        return serviceProvider;
    }

    private <T extends AdapterServiceProvider> ServiceLoader<T> getServiceLoader(Class<T> klass) {
        return this.serviceLoaders.computeIfAbsent(klass, k -> ServiceLoader.load(klass));
    }

    public PaymentInitiationService getPaymentInitiationService(RequestHeaders requestHeaders) {
        Aspsp aspsp = this.getAspsp(requestHeaders);
        String adapterId = aspsp.getAdapterId();
        String baseUrl = aspsp.getUrl();
        return this.getServiceProvider(PaymentInitiationServiceProvider.class, adapterId).orElseThrow(() -> new AdapterNotFoundException(adapterId)).getPaymentInitiationService(baseUrl, this.httpClientFactory, this.keyStore);
    }

    public Oauth2Service getOauth2Service(RequestHeaders requestHeaders) {
        Aspsp aspsp = this.getAspsp(requestHeaders);
        String adapterId = aspsp.getAdapterId();
        return this.getServiceProvider(Oauth2ServiceFactory.class, adapterId).orElseThrow(() -> new AdapterNotFoundException(adapterId)).getOauth2Service(aspsp, this.httpClientFactory, this.keyStore);
    }

    public DownloadService getDownloadService(RequestHeaders requestHeaders) {
        Aspsp aspsp = this.getAspsp(requestHeaders);
        String adapterId = aspsp.getAdapterId();
        String baseUrl = Optional.ofNullable(aspsp.getIdpUrl()).orElseGet(() -> ((Aspsp)aspsp).getUrl());
        return this.getServiceProvider(DownloadServiceProvider.class, adapterId).orElseThrow(() -> new AdapterNotFoundException(adapterId)).getDownloadService(baseUrl, this.httpClientFactory, this.keyStore);
    }

    private String buildAspspNotFoundErrorMessage(String bankCode, String bic) {
        return this.appendNotEmptyBankCodeAndBic(new StringBuilder("No ASPSP was found with "), bankCode, bic);
    }

    private String buildAspspCouldNotBeIdentifiedErrorMessage(int numberOfEntries, String bankCode, String bic) {
        return this.appendNotEmptyBankCodeAndBic(new StringBuilder(String.format("The ASPSP could not be identified: %s registry entries found for ", numberOfEntries)), bankCode, bic);
    }

    private String appendNotEmptyBankCodeAndBic(StringBuilder errorMessageBuilder, String bankCode, String bic) {
        if (!bankCode.isEmpty() && !bic.isEmpty()) {
            return errorMessageBuilder.append("bank code ").append(bankCode).append(" and ").append("BIC ").append(bic).toString();
        }
        if (!bankCode.isEmpty()) {
            return errorMessageBuilder.append("bank code ").append(bankCode).toString();
        }
        if (!bic.isEmpty()) {
            return errorMessageBuilder.append("BIC ").append(bic).toString();
        }
        return EMPTY_STRING;
    }
}

