/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.impl;

import de.adorsys.xs2a.adapter.service.AccountInformationService;
import de.adorsys.xs2a.adapter.service.RequestHeaders;
import de.adorsys.xs2a.adapter.service.RequestParams;
import de.adorsys.xs2a.adapter.service.Response;
import de.adorsys.xs2a.adapter.service.loader.AdapterServiceLoader;
import de.adorsys.xs2a.adapter.service.model.AccountListHolder;
import de.adorsys.xs2a.adapter.service.model.BalanceReport;
import de.adorsys.xs2a.adapter.service.model.ConsentCreationResponse;
import de.adorsys.xs2a.adapter.service.model.ConsentInformation;
import de.adorsys.xs2a.adapter.service.model.ConsentStatusResponse;
import de.adorsys.xs2a.adapter.service.model.Consents;
import de.adorsys.xs2a.adapter.service.model.ScaStatusResponse;
import de.adorsys.xs2a.adapter.service.model.SelectPsuAuthenticationMethod;
import de.adorsys.xs2a.adapter.service.model.SelectPsuAuthenticationMethodResponse;
import de.adorsys.xs2a.adapter.service.model.StartScaProcessResponse;
import de.adorsys.xs2a.adapter.service.model.TransactionAuthorisation;
import de.adorsys.xs2a.adapter.service.model.TransactionDetails;
import de.adorsys.xs2a.adapter.service.model.TransactionsReport;
import de.adorsys.xs2a.adapter.service.model.UpdatePsuAuthentication;
import de.adorsys.xs2a.adapter.service.model.UpdatePsuAuthenticationResponse;

public class AccountInformationServiceImpl
implements AccountInformationService {
    private final AdapterServiceLoader adapterServiceLoader;

    public AccountInformationServiceImpl(AdapterServiceLoader adapterServiceLoader) {
        this.adapterServiceLoader = adapterServiceLoader;
    }

    public Response<ConsentCreationResponse> createConsent(RequestHeaders requestHeaders, Consents consents) {
        return this.getAccountInformationService(requestHeaders).createConsent(requestHeaders, consents);
    }

    private AccountInformationService getAccountInformationService(RequestHeaders requestHeaders) {
        return this.adapterServiceLoader.getAccountInformationService(requestHeaders);
    }

    public Response<ConsentInformation> getConsentInformation(String consentId, RequestHeaders requestHeaders) {
        return this.getAccountInformationService(requestHeaders).getConsentInformation(consentId, requestHeaders);
    }

    public Response<Void> deleteConsent(String consentId, RequestHeaders requestHeaders) {
        return this.getAccountInformationService(requestHeaders).deleteConsent(consentId, requestHeaders);
    }

    public Response<ConsentStatusResponse> getConsentStatus(String consentId, RequestHeaders requestHeaders) {
        return this.getAccountInformationService(requestHeaders).getConsentStatus(consentId, requestHeaders);
    }

    public Response<StartScaProcessResponse> startConsentAuthorisation(String consentId, RequestHeaders requestHeaders) {
        return this.getAccountInformationService(requestHeaders).startConsentAuthorisation(consentId, requestHeaders);
    }

    public Response<StartScaProcessResponse> startConsentAuthorisation(String consentId, RequestHeaders requestHeaders, UpdatePsuAuthentication updatePsuAuthentication) {
        return this.getAccountInformationService(requestHeaders).startConsentAuthorisation(consentId, requestHeaders, updatePsuAuthentication);
    }

    public Response<SelectPsuAuthenticationMethodResponse> updateConsentsPsuData(String consentId, String authorisationId, RequestHeaders requestHeaders, SelectPsuAuthenticationMethod selectPsuAuthenticationMethod) {
        return this.getAccountInformationService(requestHeaders).updateConsentsPsuData(consentId, authorisationId, requestHeaders, selectPsuAuthenticationMethod);
    }

    public Response<ScaStatusResponse> updateConsentsPsuData(String consentId, String authorisationId, RequestHeaders requestHeaders, TransactionAuthorisation transactionAuthorisation) {
        return this.getAccountInformationService(requestHeaders).updateConsentsPsuData(consentId, authorisationId, requestHeaders, transactionAuthorisation);
    }

    public Response<UpdatePsuAuthenticationResponse> updateConsentsPsuData(String consentId, String authorisationId, RequestHeaders requestHeaders, UpdatePsuAuthentication updatePsuAuthentication) {
        return this.getAccountInformationService(requestHeaders).updateConsentsPsuData(consentId, authorisationId, requestHeaders, updatePsuAuthentication);
    }

    public Response<AccountListHolder> getAccountList(RequestHeaders requestHeaders, RequestParams requestParams) {
        return this.getAccountInformationService(requestHeaders).getAccountList(requestHeaders, requestParams);
    }

    public Response<TransactionsReport> getTransactionList(String accountId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return this.getAccountInformationService(requestHeaders).getTransactionList(accountId, requestHeaders, requestParams);
    }

    public Response<TransactionDetails> getTransactionDetails(String accountId, String transactionId, RequestHeaders requestHeaders) {
        return this.getAccountInformationService(requestHeaders).getTransactionDetails(accountId, transactionId, requestHeaders);
    }

    public Response<String> getTransactionListAsString(String accountId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return this.getAccountInformationService(requestHeaders).getTransactionListAsString(accountId, requestHeaders, requestParams);
    }

    public Response<ScaStatusResponse> getConsentScaStatus(String consentId, String authorisationId, RequestHeaders requestHeaders) {
        return this.getAccountInformationService(requestHeaders).getConsentScaStatus(consentId, authorisationId, requestHeaders);
    }

    public Response<BalanceReport> getBalances(String accountId, RequestHeaders requestHeaders) {
        return this.getAccountInformationService(requestHeaders).getBalances(accountId, requestHeaders);
    }
}

