/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.loader.mapper;

import de.adorsys.xs2a.adapter.service.loader.mapper.Xs2aPsd2Mapper;
import de.adorsys.xs2a.adapter.service.model.AccountAccess;
import de.adorsys.xs2a.adapter.service.model.AccountListHolder;
import de.adorsys.xs2a.adapter.service.model.AccountReference;
import de.adorsys.xs2a.adapter.service.model.BalanceReport;
import de.adorsys.xs2a.adapter.service.model.BankTransactionCode;
import de.adorsys.xs2a.adapter.service.model.ConsentCreationResponse;
import de.adorsys.xs2a.adapter.service.model.ConsentInformation;
import de.adorsys.xs2a.adapter.service.model.ConsentStatusResponse;
import de.adorsys.xs2a.adapter.service.model.Consents;
import de.adorsys.xs2a.adapter.service.model.Link;
import de.adorsys.xs2a.adapter.service.model.PurposeCode;
import de.adorsys.xs2a.adapter.service.model.SelectPsuAuthenticationMethod;
import de.adorsys.xs2a.adapter.service.model.SelectPsuAuthenticationMethodResponse;
import de.adorsys.xs2a.adapter.service.model.StartScaProcessResponse;
import de.adorsys.xs2a.adapter.service.model.TransactionAuthorisation;
import de.adorsys.xs2a.adapter.service.model.Transactions;
import de.adorsys.xs2a.adapter.service.model.TransactionsReport;
import de.adorsys.xs2a.adapter.service.model.UpdatePsuAuthentication;
import de.adorsys.xs2a.adapter.service.model.UpdatePsuAuthenticationResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.AccountAccess;
import de.adorsys.xs2a.adapter.service.psd2.model.AccountDetails;
import de.adorsys.xs2a.adapter.service.psd2.model.AccountList;
import de.adorsys.xs2a.adapter.service.psd2.model.AccountReport;
import de.adorsys.xs2a.adapter.service.psd2.model.Amount;
import de.adorsys.xs2a.adapter.service.psd2.model.AuthenticationObject;
import de.adorsys.xs2a.adapter.service.psd2.model.Balance;
import de.adorsys.xs2a.adapter.service.psd2.model.ChallengeData;
import de.adorsys.xs2a.adapter.service.psd2.model.ConsentInformationResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.ConsentsResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.HrefType;
import de.adorsys.xs2a.adapter.service.psd2.model.PsuData;
import de.adorsys.xs2a.adapter.service.psd2.model.ReadAccountBalanceResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.ScaStatusResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.TransactionDetails;
import de.adorsys.xs2a.adapter.service.psd2.model.TransactionsResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.UpdateAuthorisation;
import de.adorsys.xs2a.adapter.service.psd2.model.UpdateAuthorisationResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Xs2aPsd2MapperImpl
implements Xs2aPsd2Mapper {
    @Override
    public AccountList toAccountList(AccountListHolder value) {
        if (value == null) {
            return null;
        }
        AccountList accountList = new AccountList();
        accountList.setAccounts(this.accountDetailsListToAccountDetailsList(value.getAccounts()));
        return accountList;
    }

    @Override
    public ReadAccountBalanceResponse toReadAccountBalanceResponse(BalanceReport value) {
        if (value == null) {
            return null;
        }
        ReadAccountBalanceResponse readAccountBalanceResponse = new ReadAccountBalanceResponse();
        readAccountBalanceResponse.setAccount(this.accountReferenceToAccountReference(value.getAccount()));
        readAccountBalanceResponse.setBalances(this.balanceListToBalanceList(value.getBalances()));
        return readAccountBalanceResponse;
    }

    @Override
    public TransactionsResponse toTransactionsResponse(TransactionsReport value) {
        if (value == null) {
            return null;
        }
        TransactionsResponse transactionsResponse = new TransactionsResponse();
        transactionsResponse.setTransactions(this.accountReportToAccountReport(value.getTransactions()));
        transactionsResponse.setBalances(this.balanceListToBalanceList(value.getBalances()));
        transactionsResponse.setLinks(this.stringLinkMapToStringHrefTypeMap(value.getLinks()));
        return transactionsResponse;
    }

    @Override
    public TransactionDetails map(Transactions value) {
        if (value == null) {
            return null;
        }
        TransactionDetails transactionDetails = new TransactionDetails();
        transactionDetails.setPurposeCode(this.valuePurposeCodeCode(value));
        transactionDetails.setBankTransactionCode(this.valueBankTransactionCodeCode(value));
        transactionDetails.setTransactionId(value.getTransactionId());
        transactionDetails.setEntryReference(value.getEntryReference());
        transactionDetails.setEndToEndId(value.getEndToEndId());
        transactionDetails.setMandateId(value.getMandateId());
        transactionDetails.setCheckId(value.getCheckId());
        transactionDetails.setCreditorId(value.getCreditorId());
        transactionDetails.setBookingDate(value.getBookingDate());
        transactionDetails.setValueDate(value.getValueDate());
        transactionDetails.setTransactionAmount(this.amountToAmount(value.getTransactionAmount()));
        transactionDetails.setCreditorName(value.getCreditorName());
        transactionDetails.setCreditorAccount(this.accountReferenceToAccountReference(value.getCreditorAccount()));
        transactionDetails.setUltimateCreditor(value.getUltimateCreditor());
        transactionDetails.setDebtorName(value.getDebtorName());
        transactionDetails.setDebtorAccount(this.accountReferenceToAccountReference(value.getDebtorAccount()));
        transactionDetails.setUltimateDebtor(value.getUltimateDebtor());
        transactionDetails.setRemittanceInformationUnstructured(value.getRemittanceInformationUnstructured());
        transactionDetails.setRemittanceInformationStructured(value.getRemittanceInformationStructured());
        transactionDetails.setProprietaryBankTransactionCode(value.getProprietaryBankTransactionCode());
        transactionDetails.setLinks(this.stringLinkMapToStringHrefTypeMap(value.getLinks()));
        return transactionDetails;
    }

    @Override
    public Consents map(de.adorsys.xs2a.adapter.service.psd2.model.Consents value) {
        if (value == null) {
            return null;
        }
        Consents consents = new Consents();
        consents.setAccess(this.accountAccessToAccountAccess(value.getAccess()));
        consents.setRecurringIndicator(value.getRecurringIndicator());
        consents.setValidUntil(value.getValidUntil());
        consents.setFrequencyPerDay(value.getFrequencyPerDay());
        consents.setCombinedServiceIndicator(value.getCombinedServiceIndicator());
        return consents;
    }

    @Override
    public ConsentsResponse toConsentsResponse(ConsentCreationResponse value) {
        if (value == null) {
            return null;
        }
        ConsentsResponse consentsResponse = new ConsentsResponse();
        consentsResponse.setConsentStatus(this.map((Enum<?>)value.getConsentStatus()));
        consentsResponse.setConsentId(value.getConsentId());
        consentsResponse.setScaMethods(this.authenticationObjectListToAuthenticationObjectList(value.getScaMethods()));
        consentsResponse.setChosenScaMethod(this.authenticationObjectToAuthenticationObject(value.getChosenScaMethod()));
        consentsResponse.setChallengeData(this.challengeDataToChallengeData(value.getChallengeData()));
        consentsResponse.setLinks(this.stringLinkMapToStringHrefTypeMap(value.getLinks()));
        consentsResponse.setMessage(value.getMessage());
        return consentsResponse;
    }

    @Override
    public ConsentInformationResponse toConsentInformationResponse(ConsentInformation value) {
        if (value == null) {
            return null;
        }
        ConsentInformationResponse consentInformationResponse = new ConsentInformationResponse();
        consentInformationResponse.setAccess(this.accountAccessToAccountAccess1(value.getAccess()));
        consentInformationResponse.setRecurringIndicator(value.getRecurringIndicator());
        consentInformationResponse.setValidUntil(value.getValidUntil());
        consentInformationResponse.setFrequencyPerDay(value.getFrequencyPerDay());
        consentInformationResponse.setLastActionDate(value.getLastActionDate());
        consentInformationResponse.setConsentStatus(this.map((Enum<?>)value.getConsentStatus()));
        consentInformationResponse.setLinks(this.stringLinkMapToStringHrefTypeMap(value.getLinks()));
        return consentInformationResponse;
    }

    @Override
    public de.adorsys.xs2a.adapter.service.psd2.model.ConsentStatusResponse toConsentStatusResponse(ConsentStatusResponse value) {
        if (value == null) {
            return null;
        }
        de.adorsys.xs2a.adapter.service.psd2.model.ConsentStatusResponse consentStatusResponse = new de.adorsys.xs2a.adapter.service.psd2.model.ConsentStatusResponse();
        consentStatusResponse.setConsentStatus(this.map((Enum<?>)value.getConsentStatus()));
        return consentStatusResponse;
    }

    @Override
    public ScaStatusResponse toScaStatusResponse(de.adorsys.xs2a.adapter.service.model.ScaStatusResponse value) {
        if (value == null) {
            return null;
        }
        ScaStatusResponse scaStatusResponse = new ScaStatusResponse();
        scaStatusResponse.setScaStatus(this.map((Enum<?>)value.getScaStatus()));
        return scaStatusResponse;
    }

    @Override
    public UpdatePsuAuthentication map(UpdateAuthorisation value) {
        if (value == null) {
            return null;
        }
        UpdatePsuAuthentication updatePsuAuthentication = new UpdatePsuAuthentication();
        updatePsuAuthentication.setPsuData(this.psuDataToPsuData(value.getPsuData()));
        return updatePsuAuthentication;
    }

    @Override
    public de.adorsys.xs2a.adapter.service.psd2.model.StartScaProcessResponse toStartScaprocessResponse(StartScaProcessResponse value) {
        if (value == null) {
            return null;
        }
        de.adorsys.xs2a.adapter.service.psd2.model.StartScaProcessResponse startScaProcessResponse = new de.adorsys.xs2a.adapter.service.psd2.model.StartScaProcessResponse();
        startScaProcessResponse.setScaStatus(this.map((Enum<?>)value.getScaStatus()));
        startScaProcessResponse.setAuthorisationId(value.getAuthorisationId());
        startScaProcessResponse.setScaMethods(this.authenticationObjectListToAuthenticationObjectList(value.getScaMethods()));
        startScaProcessResponse.setChosenScaMethod(this.authenticationObjectToAuthenticationObject(value.getChosenScaMethod()));
        startScaProcessResponse.setChallengeData(this.challengeDataToChallengeData(value.getChallengeData()));
        startScaProcessResponse.setLinks(this.stringLinkMapToStringHrefTypeMap(value.getLinks()));
        startScaProcessResponse.setPsuMessage(value.getPsuMessage());
        return startScaProcessResponse;
    }

    @Override
    public SelectPsuAuthenticationMethod toSelectPsuAuthenticationMethod(UpdateAuthorisation updateAuthentication) {
        if (updateAuthentication == null) {
            return null;
        }
        SelectPsuAuthenticationMethod selectPsuAuthenticationMethod = new SelectPsuAuthenticationMethod();
        selectPsuAuthenticationMethod.setAuthenticationMethodId(updateAuthentication.getAuthenticationMethodId());
        return selectPsuAuthenticationMethod;
    }

    @Override
    public UpdatePsuAuthentication toUpdatePsuAuthentication(UpdateAuthorisation updateAuthentication) {
        if (updateAuthentication == null) {
            return null;
        }
        UpdatePsuAuthentication updatePsuAuthentication = new UpdatePsuAuthentication();
        updatePsuAuthentication.setPsuData(this.psuDataToPsuData(updateAuthentication.getPsuData()));
        return updatePsuAuthentication;
    }

    @Override
    public TransactionAuthorisation toTransactionAuthorisation(UpdateAuthorisation updateAuthorisation) {
        if (updateAuthorisation == null) {
            return null;
        }
        TransactionAuthorisation transactionAuthorisation = new TransactionAuthorisation();
        transactionAuthorisation.setScaAuthenticationData(updateAuthorisation.getScaAuthenticationData());
        return transactionAuthorisation;
    }

    @Override
    public UpdateAuthorisationResponse toUpdateAuthorisationResponse(SelectPsuAuthenticationMethodResponse value) {
        if (value == null) {
            return null;
        }
        UpdateAuthorisationResponse updateAuthorisationResponse = new UpdateAuthorisationResponse();
        updateAuthorisationResponse.setChosenScaMethod(this.authenticationObjectToAuthenticationObject(value.getChosenScaMethod()));
        updateAuthorisationResponse.setChallengeData(this.challengeDataToChallengeData(value.getChallengeData()));
        updateAuthorisationResponse.setScaStatus(this.map((Enum<?>)value.getScaStatus()));
        updateAuthorisationResponse.setPsuMessage(value.getPsuMessage());
        updateAuthorisationResponse.setLinks(this.stringLinkMapToStringHrefTypeMap(value.getLinks()));
        return updateAuthorisationResponse;
    }

    @Override
    public UpdateAuthorisationResponse toUpdateAuthorisationResponse(UpdatePsuAuthenticationResponse value) {
        if (value == null) {
            return null;
        }
        UpdateAuthorisationResponse updateAuthorisationResponse = new UpdateAuthorisationResponse();
        updateAuthorisationResponse.setChosenScaMethod(this.authenticationObjectToAuthenticationObject(value.getChosenScaMethod()));
        updateAuthorisationResponse.setChallengeData(this.challengeDataToChallengeData(value.getChallengeData()));
        updateAuthorisationResponse.setScaMethods(this.authenticationObjectListToAuthenticationObjectList(value.getScaMethods()));
        updateAuthorisationResponse.setScaStatus(this.map((Enum<?>)value.getScaStatus()));
        updateAuthorisationResponse.setPsuMessage(value.getPsuMessage());
        Map map = value.getLinks();
        if (map != null) {
            updateAuthorisationResponse.setLinks(new HashMap(map));
        }
        return updateAuthorisationResponse;
    }

    @Override
    public UpdateAuthorisationResponse toUpdateAuthorisationResponse(de.adorsys.xs2a.adapter.service.model.ScaStatusResponse value) {
        if (value == null) {
            return null;
        }
        UpdateAuthorisationResponse updateAuthorisationResponse = new UpdateAuthorisationResponse();
        updateAuthorisationResponse.setScaStatus(this.map((Enum<?>)value.getScaStatus()));
        return updateAuthorisationResponse;
    }

    protected Amount amountToAmount(de.adorsys.xs2a.adapter.service.model.Amount amount) {
        if (amount == null) {
            return null;
        }
        Amount amount1 = new Amount();
        amount1.setCurrency(amount.getCurrency());
        amount1.setAmount(amount.getAmount());
        return amount1;
    }

    protected Balance balanceToBalance(de.adorsys.xs2a.adapter.service.model.Balance balance) {
        if (balance == null) {
            return null;
        }
        Balance balance1 = new Balance();
        balance1.setBalanceAmount(this.amountToAmount(balance.getBalanceAmount()));
        balance1.setBalanceType(this.map((Enum<?>)balance.getBalanceType()));
        balance1.setLastChangeDateTime(balance.getLastChangeDateTime());
        balance1.setReferenceDate(balance.getReferenceDate());
        balance1.setLastCommittedTransaction(balance.getLastCommittedTransaction());
        return balance1;
    }

    protected List<Balance> balanceListToBalanceList(List<de.adorsys.xs2a.adapter.service.model.Balance> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Balance> list1 = new ArrayList<Balance>(list.size());
        for (de.adorsys.xs2a.adapter.service.model.Balance balance : list) {
            list1.add(this.balanceToBalance(balance));
        }
        return list1;
    }

    protected HrefType linkToHrefType(Link link) {
        if (link == null) {
            return null;
        }
        HrefType hrefType = new HrefType();
        hrefType.setHref(link.getHref());
        return hrefType;
    }

    protected Map<String, HrefType> stringLinkMapToStringHrefTypeMap(Map<String, Link> map) {
        if (map == null) {
            return null;
        }
        HashMap<String, HrefType> map1 = new HashMap<String, HrefType>(Math.max((int)((float)map.size() / 0.75f) + 1, 16));
        for (Map.Entry<String, Link> entry : map.entrySet()) {
            String key = entry.getKey();
            HrefType value = this.linkToHrefType(entry.getValue());
            map1.put(key, value);
        }
        return map1;
    }

    protected AccountDetails accountDetailsToAccountDetails(de.adorsys.xs2a.adapter.service.model.AccountDetails accountDetails) {
        if (accountDetails == null) {
            return null;
        }
        AccountDetails accountDetails1 = new AccountDetails();
        accountDetails1.setResourceId(accountDetails.getResourceId());
        accountDetails1.setIban(accountDetails.getIban());
        accountDetails1.setBban(accountDetails.getBban());
        accountDetails1.setMsisdn(accountDetails.getMsisdn());
        accountDetails1.setCurrency(accountDetails.getCurrency());
        accountDetails1.setName(accountDetails.getName());
        accountDetails1.setProduct(accountDetails.getProduct());
        accountDetails1.setCashAccountType(this.map((Enum<?>)accountDetails.getCashAccountType()));
        accountDetails1.setStatus(this.map((Enum<?>)accountDetails.getStatus()));
        accountDetails1.setBic(accountDetails.getBic());
        accountDetails1.setLinkedAccounts(accountDetails.getLinkedAccounts());
        accountDetails1.setDetails(accountDetails.getDetails());
        accountDetails1.setBalances(this.balanceListToBalanceList(accountDetails.getBalances()));
        accountDetails1.setLinks(this.stringLinkMapToStringHrefTypeMap(accountDetails.getLinks()));
        return accountDetails1;
    }

    protected List<AccountDetails> accountDetailsListToAccountDetailsList(List<de.adorsys.xs2a.adapter.service.model.AccountDetails> list) {
        if (list == null) {
            return null;
        }
        ArrayList<AccountDetails> list1 = new ArrayList<AccountDetails>(list.size());
        for (de.adorsys.xs2a.adapter.service.model.AccountDetails accountDetails : list) {
            list1.add(this.accountDetailsToAccountDetails(accountDetails));
        }
        return list1;
    }

    protected de.adorsys.xs2a.adapter.service.psd2.model.AccountReference accountReferenceToAccountReference(AccountReference accountReference) {
        if (accountReference == null) {
            return null;
        }
        de.adorsys.xs2a.adapter.service.psd2.model.AccountReference accountReference1 = new de.adorsys.xs2a.adapter.service.psd2.model.AccountReference();
        accountReference1.setIban(accountReference.getIban());
        accountReference1.setBban(accountReference.getBban());
        accountReference1.setPan(accountReference.getPan());
        accountReference1.setMaskedPan(accountReference.getMaskedPan());
        accountReference1.setMsisdn(accountReference.getMsisdn());
        accountReference1.setCurrency(accountReference.getCurrency());
        return accountReference1;
    }

    protected List<TransactionDetails> transactionsListToTransactionDetailsList(List<Transactions> list) {
        if (list == null) {
            return null;
        }
        ArrayList<TransactionDetails> list1 = new ArrayList<TransactionDetails>(list.size());
        for (Transactions transactions : list) {
            list1.add(this.map(transactions));
        }
        return list1;
    }

    protected AccountReport accountReportToAccountReport(de.adorsys.xs2a.adapter.service.model.AccountReport accountReport) {
        if (accountReport == null) {
            return null;
        }
        AccountReport accountReport1 = new AccountReport();
        accountReport1.setBooked(this.transactionsListToTransactionDetailsList(accountReport.getBooked()));
        accountReport1.setPending(this.transactionsListToTransactionDetailsList(accountReport.getPending()));
        accountReport1.setLinks(this.stringLinkMapToStringHrefTypeMap(accountReport.getLinks()));
        return accountReport1;
    }

    private String valuePurposeCodeCode(Transactions transactions) {
        if (transactions == null) {
            return null;
        }
        PurposeCode purposeCode = transactions.getPurposeCode();
        if (purposeCode == null) {
            return null;
        }
        String code = purposeCode.getCode();
        if (code == null) {
            return null;
        }
        return code;
    }

    private String valueBankTransactionCodeCode(Transactions transactions) {
        if (transactions == null) {
            return null;
        }
        BankTransactionCode bankTransactionCode = transactions.getBankTransactionCode();
        if (bankTransactionCode == null) {
            return null;
        }
        String code = bankTransactionCode.getCode();
        if (code == null) {
            return null;
        }
        return code;
    }

    protected AccountReference accountReferenceToAccountReference1(de.adorsys.xs2a.adapter.service.psd2.model.AccountReference accountReference) {
        if (accountReference == null) {
            return null;
        }
        AccountReference accountReference1 = new AccountReference();
        accountReference1.setIban(accountReference.getIban());
        accountReference1.setBban(accountReference.getBban());
        accountReference1.setPan(accountReference.getPan());
        accountReference1.setMaskedPan(accountReference.getMaskedPan());
        accountReference1.setMsisdn(accountReference.getMsisdn());
        accountReference1.setCurrency(accountReference.getCurrency());
        return accountReference1;
    }

    protected List<AccountReference> accountReferenceListToAccountReferenceList(List<de.adorsys.xs2a.adapter.service.psd2.model.AccountReference> list) {
        if (list == null) {
            return null;
        }
        ArrayList<AccountReference> list1 = new ArrayList<AccountReference>(list.size());
        for (de.adorsys.xs2a.adapter.service.psd2.model.AccountReference accountReference : list) {
            list1.add(this.accountReferenceToAccountReference1(accountReference));
        }
        return list1;
    }

    protected de.adorsys.xs2a.adapter.service.model.AccountAccess accountAccessToAccountAccess(AccountAccess accountAccess) {
        if (accountAccess == null) {
            return null;
        }
        de.adorsys.xs2a.adapter.service.model.AccountAccess accountAccess1 = new de.adorsys.xs2a.adapter.service.model.AccountAccess();
        accountAccess1.setAccounts(this.accountReferenceListToAccountReferenceList(accountAccess.getAccounts()));
        accountAccess1.setBalances(this.accountReferenceListToAccountReferenceList(accountAccess.getBalances()));
        accountAccess1.setTransactions(this.accountReferenceListToAccountReferenceList(accountAccess.getTransactions()));
        if (accountAccess.getAvailableAccounts() != null) {
            accountAccess1.setAvailableAccounts(Enum.valueOf(AccountAccess.AvailableAccountsEnum.class, accountAccess.getAvailableAccounts()));
        }
        if (accountAccess.getAllPsd2() != null) {
            accountAccess1.setAllPsd2(Enum.valueOf(AccountAccess.AllPsd2Enum.class, accountAccess.getAllPsd2()));
        }
        return accountAccess1;
    }

    protected AuthenticationObject authenticationObjectToAuthenticationObject(de.adorsys.xs2a.adapter.service.model.AuthenticationObject authenticationObject) {
        if (authenticationObject == null) {
            return null;
        }
        AuthenticationObject authenticationObject1 = new AuthenticationObject();
        authenticationObject1.setAuthenticationType(authenticationObject.getAuthenticationType());
        authenticationObject1.setAuthenticationVersion(authenticationObject.getAuthenticationVersion());
        authenticationObject1.setAuthenticationMethodId(authenticationObject.getAuthenticationMethodId());
        authenticationObject1.setName(authenticationObject.getName());
        authenticationObject1.setExplanation(authenticationObject.getExplanation());
        return authenticationObject1;
    }

    protected List<AuthenticationObject> authenticationObjectListToAuthenticationObjectList(List<de.adorsys.xs2a.adapter.service.model.AuthenticationObject> list) {
        if (list == null) {
            return null;
        }
        ArrayList<AuthenticationObject> list1 = new ArrayList<AuthenticationObject>(list.size());
        for (de.adorsys.xs2a.adapter.service.model.AuthenticationObject authenticationObject : list) {
            list1.add(this.authenticationObjectToAuthenticationObject(authenticationObject));
        }
        return list1;
    }

    protected ChallengeData challengeDataToChallengeData(de.adorsys.xs2a.adapter.service.model.ChallengeData challengeData) {
        List list;
        if (challengeData == null) {
            return null;
        }
        ChallengeData challengeData1 = new ChallengeData();
        byte[] image = challengeData.getImage();
        if (image != null) {
            challengeData1.setImage(Arrays.copyOf(image, image.length));
        }
        if ((list = challengeData.getData()) != null) {
            challengeData1.setData(new ArrayList(list));
        }
        challengeData1.setImageLink(challengeData.getImageLink());
        challengeData1.setOtpMaxLength(challengeData.getOtpMaxLength());
        challengeData1.setOtpFormat(this.map((Enum<?>)challengeData.getOtpFormat()));
        challengeData1.setAdditionalInformation(challengeData.getAdditionalInformation());
        return challengeData1;
    }

    protected List<de.adorsys.xs2a.adapter.service.psd2.model.AccountReference> accountReferenceListToAccountReferenceList1(List<AccountReference> list) {
        if (list == null) {
            return null;
        }
        ArrayList<de.adorsys.xs2a.adapter.service.psd2.model.AccountReference> list1 = new ArrayList<de.adorsys.xs2a.adapter.service.psd2.model.AccountReference>(list.size());
        for (AccountReference accountReference : list) {
            list1.add(this.accountReferenceToAccountReference(accountReference));
        }
        return list1;
    }

    protected AccountAccess accountAccessToAccountAccess1(de.adorsys.xs2a.adapter.service.model.AccountAccess accountAccess) {
        if (accountAccess == null) {
            return null;
        }
        AccountAccess accountAccess1 = new AccountAccess();
        accountAccess1.setAccounts(this.accountReferenceListToAccountReferenceList1(accountAccess.getAccounts()));
        accountAccess1.setBalances(this.accountReferenceListToAccountReferenceList1(accountAccess.getBalances()));
        accountAccess1.setTransactions(this.accountReferenceListToAccountReferenceList1(accountAccess.getTransactions()));
        accountAccess1.setAvailableAccounts(this.map((Enum<?>)accountAccess.getAvailableAccounts()));
        accountAccess1.setAllPsd2(this.map((Enum<?>)accountAccess.getAllPsd2()));
        return accountAccess1;
    }

    protected de.adorsys.xs2a.adapter.service.model.PsuData psuDataToPsuData(PsuData psuData) {
        if (psuData == null) {
            return null;
        }
        de.adorsys.xs2a.adapter.service.model.PsuData psuData1 = new de.adorsys.xs2a.adapter.service.model.PsuData();
        psuData1.setPassword(psuData.getPassword());
        psuData1.setEncryptedPassword(psuData.getEncryptedPassword());
        return psuData1;
    }
}

