/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.loader;

import de.adorsys.xs2a.adapter.service.RequestHeaders;
import de.adorsys.xs2a.adapter.service.Response;
import de.adorsys.xs2a.adapter.service.loader.Psd2AdapterServiceLoader;
import de.adorsys.xs2a.adapter.service.psd2.Psd2AccountInformationService;
import de.adorsys.xs2a.adapter.service.psd2.model.AccountList;
import de.adorsys.xs2a.adapter.service.psd2.model.ConsentInformationResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.ConsentStatusResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.Consents;
import de.adorsys.xs2a.adapter.service.psd2.model.ConsentsResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.ReadAccountBalanceResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.ScaStatusResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.StartScaProcessResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.UpdateAuthorisation;
import de.adorsys.xs2a.adapter.service.psd2.model.UpdateAuthorisationResponse;
import java.io.IOException;
import java.util.Map;

public class Psd2AdapterDelegatingAccountInformationService
implements Psd2AccountInformationService {
    private final Psd2AdapterServiceLoader adapterServiceLoader;

    public Psd2AdapterDelegatingAccountInformationService(Psd2AdapterServiceLoader adapterServiceLoader) {
        this.adapterServiceLoader = adapterServiceLoader;
    }

    public Response<ConsentsResponse> createConsent(Map<String, String> headers, Consents consents) {
        return this.getAccountInformationService(headers).createConsent(headers, consents);
    }

    private Psd2AccountInformationService getAccountInformationService(Map<String, String> headers) {
        return this.adapterServiceLoader.getPsd2AccountInformationService(RequestHeaders.fromMap(headers));
    }

    public Response<ConsentInformationResponse> getConsentInformation(String consentId, Map<String, String> headers) {
        return this.getAccountInformationService(headers).getConsentInformation(consentId, headers);
    }

    public Response<Void> deleteConsent(String consentId, Map<String, String> headers) {
        return this.getAccountInformationService(headers).deleteConsent(consentId, headers);
    }

    public Response<ConsentStatusResponse> getConsentStatus(String consentId, Map<String, String> headers) {
        return this.getAccountInformationService(headers).getConsentStatus(consentId, headers);
    }

    public Response<ScaStatusResponse> getConsentScaStatus(String consentId, String authorisationId, Map<String, String> headers) {
        return this.getAccountInformationService(headers).getConsentScaStatus(consentId, authorisationId, headers);
    }

    public Response<StartScaProcessResponse> startConsentAuthorisation(String consentId, Map<String, String> headers, UpdateAuthorisation updateAuthentication) {
        return this.getAccountInformationService(headers).startConsentAuthorisation(consentId, headers, updateAuthentication);
    }

    public Response<UpdateAuthorisationResponse> updateConsentsPsuData(String consentId, String authorisationId, Map<String, String> headers, UpdateAuthorisation updateAuthentication) {
        return this.getAccountInformationService(headers).updateConsentsPsuData(consentId, authorisationId, headers, updateAuthentication);
    }

    public Response<AccountList> getAccounts(Map<String, String> queryParameters, Map<String, String> headers) throws IOException {
        return this.getAccountInformationService(headers).getAccounts(queryParameters, headers);
    }

    public Response<ReadAccountBalanceResponse> getBalances(String accountId, Map<String, String> queryParameters, Map<String, String> headers) throws IOException {
        return this.getAccountInformationService(headers).getBalances(accountId, queryParameters, headers);
    }

    public Response<?> getTransactions(String accountId, Map<String, String> queryParameters, Map<String, String> headers) throws IOException {
        return this.getAccountInformationService(headers).getTransactions(accountId, queryParameters, headers);
    }
}

