/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.loader;

import de.adorsys.xs2a.adapter.service.AccountInformationService;
import de.adorsys.xs2a.adapter.service.AspspReadOnlyRepository;
import de.adorsys.xs2a.adapter.service.Oauth2Service;
import de.adorsys.xs2a.adapter.service.Oauth2ServiceFactory;
import de.adorsys.xs2a.adapter.service.PaymentInitiationService;
import de.adorsys.xs2a.adapter.service.Pkcs12KeyStore;
import de.adorsys.xs2a.adapter.service.RequestHeaders;
import de.adorsys.xs2a.adapter.service.exception.AdapterNotFoundException;
import de.adorsys.xs2a.adapter.service.exception.AspspRegistrationNotFoundException;
import de.adorsys.xs2a.adapter.service.model.Aspsp;
import de.adorsys.xs2a.adapter.service.provider.AccountInformationServiceProvider;
import de.adorsys.xs2a.adapter.service.provider.AdapterServiceProvider;
import de.adorsys.xs2a.adapter.service.provider.PaymentInitiationServiceProvider;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.StreamSupport;

public class AdapterServiceLoader {
    private final AspspReadOnlyRepository aspspRepository;
    protected final Pkcs12KeyStore keyStore;
    private final ConcurrentMap<Class<?>, ServiceLoader<? extends AdapterServiceProvider>> serviceLoaders = new ConcurrentHashMap();

    public AdapterServiceLoader(AspspReadOnlyRepository aspspRepository, Pkcs12KeyStore keyStore) {
        this.aspspRepository = aspspRepository;
        this.keyStore = keyStore;
    }

    public AccountInformationService getAccountInformationService(RequestHeaders requestHeaders) {
        Aspsp aspsp = this.getAspsp(requestHeaders);
        String adapterId = aspsp.getAdapterId();
        String baseUrl = aspsp.getUrl();
        return this.getServiceProvider(AccountInformationServiceProvider.class, adapterId).orElseThrow(() -> new AdapterNotFoundException(adapterId)).getAccountInformationService(baseUrl);
    }

    protected Aspsp getAspsp(RequestHeaders requestHeaders) {
        Optional aspspId = requestHeaders.getAspspId();
        Optional bankCode = requestHeaders.getBankCode();
        if (aspspId.isPresent()) {
            return (Aspsp)this.aspspRepository.findById((String)aspspId.get()).orElseThrow(() -> new AspspRegistrationNotFoundException("No ASPSP was found with id: " + (String)aspspId.get()));
        }
        if (bankCode.isPresent()) {
            List aspsps = this.aspspRepository.findByBankCode((String)bankCode.get());
            if (aspsps.size() == 0) {
                throw new AspspRegistrationNotFoundException("No ASPSP was found with bank code: " + (String)bankCode.get());
            }
            if (aspsps.size() > 1) {
                throw new AspspRegistrationNotFoundException("The ASPSP could not be identified: " + aspsps.size() + " registry entries found for bank code " + (String)bankCode.get());
            }
            return (Aspsp)aspsps.get(0);
        }
        throw new AspspRegistrationNotFoundException("Neither X-GTW-ASPSP-ID or X-GTW-Bank-Code headers were provided to identify the ASPSP");
    }

    public <T extends AdapterServiceProvider> Optional<T> getServiceProvider(Class<T> klass, String adapterId) {
        ServiceLoader<T> serviceLoader = this.getServiceLoader(klass);
        return StreamSupport.stream(serviceLoader.spliterator(), false).filter(provider -> provider.getAdapterId().equalsIgnoreCase(adapterId)).findFirst();
    }

    private <T extends AdapterServiceProvider> ServiceLoader<T> getServiceLoader(Class<T> klass) {
        return this.serviceLoaders.computeIfAbsent(klass, k -> ServiceLoader.load(klass));
    }

    public PaymentInitiationService getPaymentInitiationService(RequestHeaders requestHeaders) {
        Aspsp aspsp = this.getAspsp(requestHeaders);
        String adapterId = aspsp.getAdapterId();
        String baseUrl = aspsp.getUrl();
        return this.getServiceProvider(PaymentInitiationServiceProvider.class, adapterId).orElseThrow(() -> new AdapterNotFoundException(adapterId)).getPaymentInitiationService(baseUrl);
    }

    public Oauth2Service getOauth2Service(RequestHeaders requestHeaders) {
        Aspsp aspsp = this.getAspsp(requestHeaders);
        String adapterId = aspsp.getAdapterId();
        String baseUrl = aspsp.getUrl();
        return this.getServiceProvider(Oauth2ServiceFactory.class, adapterId).orElseThrow(() -> new AdapterNotFoundException(adapterId)).getOauth2Service(baseUrl, this.keyStore);
    }
}

