/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.impl;

import de.adorsys.xs2a.adapter.service.GeneralResponse;
import de.adorsys.xs2a.adapter.service.RequestHeaders;
import de.adorsys.xs2a.adapter.service.RequestParams;
import de.adorsys.xs2a.adapter.service.StartScaProcessResponse;
import de.adorsys.xs2a.adapter.service.account.AccountListHolder;
import de.adorsys.xs2a.adapter.service.account.BalanceReport;
import de.adorsys.xs2a.adapter.service.account.TransactionsReport;
import de.adorsys.xs2a.adapter.service.ais.AccountInformationService;
import de.adorsys.xs2a.adapter.service.ais.ConsentCreationResponse;
import de.adorsys.xs2a.adapter.service.ais.ConsentInformation;
import de.adorsys.xs2a.adapter.service.ais.ConsentStatusResponse;
import de.adorsys.xs2a.adapter.service.ais.Consents;
import de.adorsys.xs2a.adapter.service.impl.AdapterServiceLoader;
import de.adorsys.xs2a.adapter.service.model.ScaStatusResponse;
import de.adorsys.xs2a.adapter.service.model.SelectPsuAuthenticationMethod;
import de.adorsys.xs2a.adapter.service.model.SelectPsuAuthenticationMethodResponse;
import de.adorsys.xs2a.adapter.service.model.TransactionAuthorisation;
import de.adorsys.xs2a.adapter.service.model.UpdatePsuAuthentication;
import de.adorsys.xs2a.adapter.service.model.UpdatePsuAuthenticationResponse;

public class AccountInformationServiceImpl
implements AccountInformationService {
    private final AdapterServiceLoader adapterServiceLoader;

    public AccountInformationServiceImpl(AdapterServiceLoader adapterServiceLoader) {
        this.adapterServiceLoader = adapterServiceLoader;
    }

    public GeneralResponse<ConsentCreationResponse> createConsent(RequestHeaders requestHeaders, Consents consents) {
        return this.getAccountInformationService(requestHeaders).createConsent(requestHeaders, consents);
    }

    private AccountInformationService getAccountInformationService(RequestHeaders requestHeaders) {
        return this.adapterServiceLoader.getAccountInformationService(requestHeaders);
    }

    public GeneralResponse<ConsentInformation> getConsentInformation(String consentId, RequestHeaders requestHeaders) {
        return this.getAccountInformationService(requestHeaders).getConsentInformation(consentId, requestHeaders);
    }

    public GeneralResponse<Void> deleteConsent(String consentId, RequestHeaders requestHeaders) {
        return this.getAccountInformationService(requestHeaders).deleteConsent(consentId, requestHeaders);
    }

    public GeneralResponse<ConsentStatusResponse> getConsentStatus(String consentId, RequestHeaders requestHeaders) {
        return this.getAccountInformationService(requestHeaders).getConsentStatus(consentId, requestHeaders);
    }

    public GeneralResponse<StartScaProcessResponse> startConsentAuthorisation(String consentId, RequestHeaders requestHeaders) {
        return this.getAccountInformationService(requestHeaders).startConsentAuthorisation(consentId, requestHeaders);
    }

    public GeneralResponse<StartScaProcessResponse> startConsentAuthorisation(String consentId, RequestHeaders requestHeaders, UpdatePsuAuthentication updatePsuAuthentication) {
        return this.getAccountInformationService(requestHeaders).startConsentAuthorisation(consentId, requestHeaders, updatePsuAuthentication);
    }

    public GeneralResponse<SelectPsuAuthenticationMethodResponse> updateConsentsPsuData(String consentId, String authorisationId, RequestHeaders requestHeaders, SelectPsuAuthenticationMethod selectPsuAuthenticationMethod) {
        return this.getAccountInformationService(requestHeaders).updateConsentsPsuData(consentId, authorisationId, requestHeaders, selectPsuAuthenticationMethod);
    }

    public GeneralResponse<ScaStatusResponse> updateConsentsPsuData(String consentId, String authorisationId, RequestHeaders requestHeaders, TransactionAuthorisation transactionAuthorisation) {
        return this.getAccountInformationService(requestHeaders).updateConsentsPsuData(consentId, authorisationId, requestHeaders, transactionAuthorisation);
    }

    public GeneralResponse<UpdatePsuAuthenticationResponse> updateConsentsPsuData(String consentId, String authorisationId, RequestHeaders requestHeaders, UpdatePsuAuthentication updatePsuAuthentication) {
        return this.getAccountInformationService(requestHeaders).updateConsentsPsuData(consentId, authorisationId, requestHeaders, updatePsuAuthentication);
    }

    public GeneralResponse<AccountListHolder> getAccountList(RequestHeaders requestHeaders, RequestParams requestParams) {
        return this.getAccountInformationService(requestHeaders).getAccountList(requestHeaders, requestParams);
    }

    public GeneralResponse<TransactionsReport> getTransactionList(String accountId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return this.getAccountInformationService(requestHeaders).getTransactionList(accountId, requestHeaders, requestParams);
    }

    public GeneralResponse<String> getTransactionListAsString(String accountId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return this.getAccountInformationService(requestHeaders).getTransactionListAsString(accountId, requestHeaders, requestParams);
    }

    public GeneralResponse<ScaStatusResponse> getConsentScaStatus(String consentId, String authorisationId, RequestHeaders requestHeaders) {
        return this.getAccountInformationService(requestHeaders).getConsentScaStatus(consentId, authorisationId, requestHeaders);
    }

    public GeneralResponse<BalanceReport> getBalances(String accountId, RequestHeaders requestHeaders) {
        return this.getAccountInformationService(requestHeaders).getBalances(accountId, requestHeaders);
    }
}

