/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.loader.mapper;

import de.adorsys.xs2a.adapter.service.loader.mapper.Xs2aPsd2Mapper;
import de.adorsys.xs2a.adapter.service.model.AccountAccess;
import de.adorsys.xs2a.adapter.service.model.AccountListHolder;
import de.adorsys.xs2a.adapter.service.model.AccountReference;
import de.adorsys.xs2a.adapter.service.model.Address;
import de.adorsys.xs2a.adapter.service.model.AuthenticationObject;
import de.adorsys.xs2a.adapter.service.model.BalanceReport;
import de.adorsys.xs2a.adapter.service.model.BankTransactionCode;
import de.adorsys.xs2a.adapter.service.model.CardAccountBalanceReport;
import de.adorsys.xs2a.adapter.service.model.CardAccountDetails;
import de.adorsys.xs2a.adapter.service.model.CardAccountDetailsHolder;
import de.adorsys.xs2a.adapter.service.model.CardAccountsTransactions;
import de.adorsys.xs2a.adapter.service.model.CardTransaction;
import de.adorsys.xs2a.adapter.service.model.ConsentCreationResponse;
import de.adorsys.xs2a.adapter.service.model.ConsentInformation;
import de.adorsys.xs2a.adapter.service.model.ConsentStatusResponse;
import de.adorsys.xs2a.adapter.service.model.Consents;
import de.adorsys.xs2a.adapter.service.model.Link;
import de.adorsys.xs2a.adapter.service.model.PaymentInitiationAuthorisationResponse;
import de.adorsys.xs2a.adapter.service.model.PaymentInitiationRequestResponse;
import de.adorsys.xs2a.adapter.service.model.PaymentInitiationScaStatusResponse;
import de.adorsys.xs2a.adapter.service.model.PurposeCode;
import de.adorsys.xs2a.adapter.service.model.ScaStatusResponse;
import de.adorsys.xs2a.adapter.service.model.SelectPsuAuthenticationMethod;
import de.adorsys.xs2a.adapter.service.model.SelectPsuAuthenticationMethodResponse;
import de.adorsys.xs2a.adapter.service.model.SinglePaymentInitiationBody;
import de.adorsys.xs2a.adapter.service.model.SinglePaymentInitiationInformationWithStatusResponse;
import de.adorsys.xs2a.adapter.service.model.StandingOrderDetails;
import de.adorsys.xs2a.adapter.service.model.StartScaProcessResponse;
import de.adorsys.xs2a.adapter.service.model.TransactionAuthorisation;
import de.adorsys.xs2a.adapter.service.model.TransactionDetails;
import de.adorsys.xs2a.adapter.service.model.Transactions;
import de.adorsys.xs2a.adapter.service.model.TransactionsReport;
import de.adorsys.xs2a.adapter.service.model.UpdatePsuAuthentication;
import de.adorsys.xs2a.adapter.service.model.UpdatePsuAuthenticationResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.AccountAccess;
import de.adorsys.xs2a.adapter.service.psd2.model.AccountDetails;
import de.adorsys.xs2a.adapter.service.psd2.model.AccountList;
import de.adorsys.xs2a.adapter.service.psd2.model.AccountReport;
import de.adorsys.xs2a.adapter.service.psd2.model.AdditionalInformationAccess;
import de.adorsys.xs2a.adapter.service.psd2.model.AdditionalInformationStructured;
import de.adorsys.xs2a.adapter.service.psd2.model.Amount;
import de.adorsys.xs2a.adapter.service.psd2.model.Authorisations;
import de.adorsys.xs2a.adapter.service.psd2.model.Balance;
import de.adorsys.xs2a.adapter.service.psd2.model.CardAccountDetailsResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.CardAccountList;
import de.adorsys.xs2a.adapter.service.psd2.model.CardAccountReport;
import de.adorsys.xs2a.adapter.service.psd2.model.CardAccountsTransactionsResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.ChallengeData;
import de.adorsys.xs2a.adapter.service.psd2.model.ConsentInformationResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.ConsentsResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.HrefType;
import de.adorsys.xs2a.adapter.service.psd2.model.PaymentInitiation;
import de.adorsys.xs2a.adapter.service.psd2.model.PaymentInitiationWithStatusResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.PsuData;
import de.adorsys.xs2a.adapter.service.psd2.model.ReadAccountBalanceResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.ReadCardAccountBalanceResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.RemittanceInformationStructured;
import de.adorsys.xs2a.adapter.service.psd2.model.ReportExchangeRate;
import de.adorsys.xs2a.adapter.service.psd2.model.StandingOrderDetails;
import de.adorsys.xs2a.adapter.service.psd2.model.TppMessage;
import de.adorsys.xs2a.adapter.service.psd2.model.TransactionDetailsResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.TransactionsResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.UpdateAuthorisation;
import de.adorsys.xs2a.adapter.service.psd2.model.UpdateAuthorisationResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Xs2aPsd2MapperImpl
implements Xs2aPsd2Mapper {
    @Override
    public AccountList toAccountList(AccountListHolder value) {
        if (value == null) {
            return null;
        }
        AccountList accountList = new AccountList();
        accountList.setAccounts(this.accountDetailsListToAccountDetailsList(value.getAccounts()));
        return accountList;
    }

    @Override
    public ReadAccountBalanceResponse toReadAccountBalanceResponse(BalanceReport value) {
        if (value == null) {
            return null;
        }
        ReadAccountBalanceResponse readAccountBalanceResponse = new ReadAccountBalanceResponse();
        readAccountBalanceResponse.setAccount(this.accountReferenceToAccountReference(value.getAccount()));
        readAccountBalanceResponse.setBalances(this.balanceListToBalanceList(value.getBalances()));
        return readAccountBalanceResponse;
    }

    @Override
    public TransactionsResponse toTransactionsResponse(TransactionsReport value) {
        if (value == null) {
            return null;
        }
        TransactionsResponse transactionsResponse = new TransactionsResponse();
        transactionsResponse.setTransactions(this.accountReportToAccountReport(value.getTransactions()));
        transactionsResponse.setBalances(this.balanceListToBalanceList(value.getBalances()));
        transactionsResponse.setLinks(this.stringLinkMapToStringHrefTypeMap(value.getLinks()));
        return transactionsResponse;
    }

    @Override
    public de.adorsys.xs2a.adapter.service.psd2.model.TransactionDetails map(Transactions value) {
        if (value == null) {
            return null;
        }
        de.adorsys.xs2a.adapter.service.psd2.model.TransactionDetails transactionDetails = new de.adorsys.xs2a.adapter.service.psd2.model.TransactionDetails();
        transactionDetails.setPurposeCode(this.valuePurposeCodeCode(value));
        transactionDetails.setBankTransactionCode(this.valueBankTransactionCodeCode(value));
        transactionDetails.setTransactionId(value.getTransactionId());
        transactionDetails.setEntryReference(value.getEntryReference());
        transactionDetails.setEndToEndId(value.getEndToEndId());
        transactionDetails.setMandateId(value.getMandateId());
        transactionDetails.setCheckId(value.getCheckId());
        transactionDetails.setCreditorId(value.getCreditorId());
        transactionDetails.setBookingDate(value.getBookingDate());
        transactionDetails.setValueDate(value.getValueDate());
        transactionDetails.setTransactionAmount(this.amountToAmount(value.getTransactionAmount()));
        transactionDetails.setCreditorName(value.getCreditorName());
        transactionDetails.setCreditorAgent(value.getCreditorAgent());
        transactionDetails.setCreditorAccount(this.accountReferenceToAccountReference(value.getCreditorAccount()));
        transactionDetails.setUltimateCreditor(value.getUltimateCreditor());
        transactionDetails.setDebtorName(value.getDebtorName());
        transactionDetails.setDebtorAccount(this.accountReferenceToAccountReference(value.getDebtorAccount()));
        transactionDetails.setDebtorAgent(value.getDebtorAgent());
        transactionDetails.setUltimateDebtor(value.getUltimateDebtor());
        transactionDetails.setRemittanceInformationUnstructured(value.getRemittanceInformationUnstructured());
        List list = value.getRemittanceInformationUnstructuredArray();
        if (list != null) {
            transactionDetails.setRemittanceInformationUnstructuredArray(new ArrayList(list));
        }
        transactionDetails.setRemittanceInformationStructured(this.remittanceInformationStructuredToRemittanceInformationStructured(value.getRemittanceInformationStructured()));
        transactionDetails.setRemittanceInformationStructuredArray(this.remittanceInformationStructuredListToRemittanceInformationStructuredList(value.getRemittanceInformationStructuredArray()));
        transactionDetails.setAdditionalInformation(value.getAdditionalInformation());
        transactionDetails.setAdditionalInformationStructured(this.additionalInformationStructuredToAdditionalInformationStructured(value.getAdditionalInformationStructured()));
        transactionDetails.setProprietaryBankTransactionCode(value.getProprietaryBankTransactionCode());
        transactionDetails.setBalanceAfterTransaction(this.balanceToBalance(value.getBalanceAfterTransaction()));
        transactionDetails.setLinks(this.stringLinkMapToStringHrefTypeMap(value.getLinks()));
        return transactionDetails;
    }

    @Override
    public Consents map(de.adorsys.xs2a.adapter.service.psd2.model.Consents value) {
        if (value == null) {
            return null;
        }
        Consents consents = new Consents();
        consents.setAccess(this.accountAccessToAccountAccess(value.getAccess()));
        consents.setRecurringIndicator(value.getRecurringIndicator());
        consents.setValidUntil(value.getValidUntil());
        consents.setFrequencyPerDay(value.getFrequencyPerDay());
        consents.setCombinedServiceIndicator(value.getCombinedServiceIndicator());
        return consents;
    }

    @Override
    public ConsentsResponse toConsentsResponse(ConsentCreationResponse value) {
        if (value == null) {
            return null;
        }
        ConsentsResponse consentsResponse = new ConsentsResponse();
        consentsResponse.setConsentStatus(this.map((Enum<?>)value.getConsentStatus()));
        consentsResponse.setConsentId(value.getConsentId());
        consentsResponse.setScaMethods(this.authenticationObjectListToAuthenticationObjectList(value.getScaMethods()));
        consentsResponse.setChosenScaMethod(this.authenticationObjectToAuthenticationObject(value.getChosenScaMethod()));
        consentsResponse.setChallengeData(this.challengeDataToChallengeData(value.getChallengeData()));
        consentsResponse.setLinks(this.stringLinkMapToStringHrefTypeMap(value.getLinks()));
        consentsResponse.setPsuMessage(value.getPsuMessage());
        return consentsResponse;
    }

    @Override
    public ConsentInformationResponse toConsentInformationResponse(ConsentInformation value) {
        if (value == null) {
            return null;
        }
        ConsentInformationResponse consentInformationResponse = new ConsentInformationResponse();
        consentInformationResponse.setAccess(this.accountAccessToAccountAccess1(value.getAccess()));
        consentInformationResponse.setRecurringIndicator(value.getRecurringIndicator());
        consentInformationResponse.setValidUntil(value.getValidUntil());
        consentInformationResponse.setFrequencyPerDay(value.getFrequencyPerDay());
        consentInformationResponse.setLastActionDate(value.getLastActionDate());
        consentInformationResponse.setConsentStatus(this.map((Enum<?>)value.getConsentStatus()));
        consentInformationResponse.setLinks(this.stringLinkMapToStringHrefTypeMap(value.getLinks()));
        return consentInformationResponse;
    }

    @Override
    public de.adorsys.xs2a.adapter.service.psd2.model.ConsentStatusResponse toConsentStatusResponse(ConsentStatusResponse value) {
        if (value == null) {
            return null;
        }
        de.adorsys.xs2a.adapter.service.psd2.model.ConsentStatusResponse consentStatusResponse = new de.adorsys.xs2a.adapter.service.psd2.model.ConsentStatusResponse();
        consentStatusResponse.setConsentStatus(this.map((Enum<?>)value.getConsentStatus()));
        return consentStatusResponse;
    }

    @Override
    public de.adorsys.xs2a.adapter.service.psd2.model.ScaStatusResponse toScaStatusResponse(ScaStatusResponse value) {
        if (value == null) {
            return null;
        }
        de.adorsys.xs2a.adapter.service.psd2.model.ScaStatusResponse scaStatusResponse = new de.adorsys.xs2a.adapter.service.psd2.model.ScaStatusResponse();
        scaStatusResponse.setScaStatus(this.map((Enum<?>)value.getScaStatus()));
        return scaStatusResponse;
    }

    @Override
    public UpdatePsuAuthentication map(UpdateAuthorisation value) {
        if (value == null) {
            return null;
        }
        UpdatePsuAuthentication updatePsuAuthentication = new UpdatePsuAuthentication();
        updatePsuAuthentication.setPsuData(this.psuDataToPsuData(value.getPsuData()));
        return updatePsuAuthentication;
    }

    @Override
    public de.adorsys.xs2a.adapter.service.psd2.model.StartScaProcessResponse toStartScaprocessResponse(StartScaProcessResponse value) {
        if (value == null) {
            return null;
        }
        de.adorsys.xs2a.adapter.service.psd2.model.StartScaProcessResponse startScaProcessResponse = new de.adorsys.xs2a.adapter.service.psd2.model.StartScaProcessResponse();
        startScaProcessResponse.setScaStatus(this.map((Enum<?>)value.getScaStatus()));
        startScaProcessResponse.setAuthorisationId(value.getAuthorisationId());
        startScaProcessResponse.setScaMethods(this.authenticationObjectListToAuthenticationObjectList(value.getScaMethods()));
        startScaProcessResponse.setChosenScaMethod(this.authenticationObjectToAuthenticationObject(value.getChosenScaMethod()));
        startScaProcessResponse.setChallengeData(this.challengeDataToChallengeData(value.getChallengeData()));
        startScaProcessResponse.setLinks(this.stringLinkMapToStringHrefTypeMap(value.getLinks()));
        startScaProcessResponse.setPsuMessage(value.getPsuMessage());
        return startScaProcessResponse;
    }

    @Override
    public SelectPsuAuthenticationMethod toSelectPsuAuthenticationMethod(UpdateAuthorisation updateAuthentication) {
        if (updateAuthentication == null) {
            return null;
        }
        SelectPsuAuthenticationMethod selectPsuAuthenticationMethod = new SelectPsuAuthenticationMethod();
        selectPsuAuthenticationMethod.setAuthenticationMethodId(updateAuthentication.getAuthenticationMethodId());
        return selectPsuAuthenticationMethod;
    }

    @Override
    public UpdatePsuAuthentication toUpdatePsuAuthentication(UpdateAuthorisation updateAuthentication) {
        if (updateAuthentication == null) {
            return null;
        }
        UpdatePsuAuthentication updatePsuAuthentication = new UpdatePsuAuthentication();
        updatePsuAuthentication.setPsuData(this.psuDataToPsuData(updateAuthentication.getPsuData()));
        return updatePsuAuthentication;
    }

    @Override
    public TransactionAuthorisation toTransactionAuthorisation(UpdateAuthorisation updateAuthorisation) {
        if (updateAuthorisation == null) {
            return null;
        }
        TransactionAuthorisation transactionAuthorisation = new TransactionAuthorisation();
        transactionAuthorisation.setScaAuthenticationData(updateAuthorisation.getScaAuthenticationData());
        return transactionAuthorisation;
    }

    @Override
    public UpdateAuthorisationResponse toUpdateAuthorisationResponse(SelectPsuAuthenticationMethodResponse value) {
        if (value == null) {
            return null;
        }
        UpdateAuthorisationResponse updateAuthorisationResponse = new UpdateAuthorisationResponse();
        updateAuthorisationResponse.setChosenScaMethod(this.authenticationObjectToAuthenticationObject(value.getChosenScaMethod()));
        updateAuthorisationResponse.setChallengeData(this.challengeDataToChallengeData(value.getChallengeData()));
        updateAuthorisationResponse.setScaStatus(this.map((Enum<?>)value.getScaStatus()));
        updateAuthorisationResponse.setPsuMessage(value.getPsuMessage());
        updateAuthorisationResponse.setLinks(this.stringLinkMapToStringHrefTypeMap(value.getLinks()));
        return updateAuthorisationResponse;
    }

    @Override
    public UpdateAuthorisationResponse toUpdateAuthorisationResponse(UpdatePsuAuthenticationResponse value) {
        if (value == null) {
            return null;
        }
        UpdateAuthorisationResponse updateAuthorisationResponse = new UpdateAuthorisationResponse();
        updateAuthorisationResponse.setChosenScaMethod(this.authenticationObjectToAuthenticationObject(value.getChosenScaMethod()));
        updateAuthorisationResponse.setChallengeData(this.challengeDataToChallengeData(value.getChallengeData()));
        updateAuthorisationResponse.setScaMethods(this.authenticationObjectListToAuthenticationObjectList(value.getScaMethods()));
        updateAuthorisationResponse.setScaStatus(this.map((Enum<?>)value.getScaStatus()));
        updateAuthorisationResponse.setPsuMessage(value.getPsuMessage());
        updateAuthorisationResponse.setAuthorisationId(value.getAuthorisationId());
        updateAuthorisationResponse.setLinks(this.stringLinkMapToStringHrefTypeMap(value.getLinks()));
        return updateAuthorisationResponse;
    }

    @Override
    public UpdateAuthorisationResponse toUpdateAuthorisationResponse(ScaStatusResponse value) {
        if (value == null) {
            return null;
        }
        UpdateAuthorisationResponse updateAuthorisationResponse = new UpdateAuthorisationResponse();
        updateAuthorisationResponse.setScaStatus(this.map((Enum<?>)value.getScaStatus()));
        return updateAuthorisationResponse;
    }

    @Override
    public CardAccountList toCardAccountList(de.adorsys.xs2a.adapter.service.model.CardAccountList value) {
        if (value == null) {
            return null;
        }
        CardAccountList cardAccountList = new CardAccountList();
        cardAccountList.setCardAccounts(this.cardAccountDetailsListToCardAccountDetailsList(value.getCardAccounts()));
        return cardAccountList;
    }

    @Override
    public CardAccountDetailsResponse toCardAccountDetailsResponse(CardAccountDetailsHolder value) {
        if (value == null) {
            return null;
        }
        CardAccountDetailsResponse cardAccountDetailsResponse = new CardAccountDetailsResponse();
        cardAccountDetailsResponse.setCardAccount(this.cardAccountDetailsToCardAccountDetails(value.getCardAccount()));
        return cardAccountDetailsResponse;
    }

    @Override
    public ReadCardAccountBalanceResponse toReadCardAccountBalanceResponse(CardAccountBalanceReport value) {
        if (value == null) {
            return null;
        }
        ReadCardAccountBalanceResponse readCardAccountBalanceResponse = new ReadCardAccountBalanceResponse();
        readCardAccountBalanceResponse.setCardAccount(this.accountReferenceToAccountReference(value.getCardAccount()));
        readCardAccountBalanceResponse.setBalances(this.balanceListToBalanceList(value.getBalances()));
        return readCardAccountBalanceResponse;
    }

    @Override
    public CardAccountsTransactionsResponse toCardAccountsTransactionsResponse(CardAccountsTransactions value) {
        if (value == null) {
            return null;
        }
        CardAccountsTransactionsResponse cardAccountsTransactionsResponse = new CardAccountsTransactionsResponse();
        cardAccountsTransactionsResponse.setCardAccount(this.accountReferenceToAccountReference(value.getCardAccount()));
        cardAccountsTransactionsResponse.setCardTransactions(this.cardAccountReportToCardAccountReport(value.getCardTransactions()));
        cardAccountsTransactionsResponse.setBalances(this.balanceListToBalanceList(value.getBalances()));
        cardAccountsTransactionsResponse.setLinks(this.stringLinkMapToStringHrefTypeMap(value.getLinks()));
        return cardAccountsTransactionsResponse;
    }

    @Override
    public de.adorsys.xs2a.adapter.service.psd2.model.PaymentInitiationRequestResponse toPaymentInitiationRequestResponse(PaymentInitiationRequestResponse value) {
        if (value == null) {
            return null;
        }
        de.adorsys.xs2a.adapter.service.psd2.model.PaymentInitiationRequestResponse paymentInitiationRequestResponse = new de.adorsys.xs2a.adapter.service.psd2.model.PaymentInitiationRequestResponse();
        paymentInitiationRequestResponse.setTransactionStatus(this.map(value.getTransactionStatus()));
        paymentInitiationRequestResponse.setPaymentId(value.getPaymentId());
        paymentInitiationRequestResponse.setTransactionFees(this.amountToAmount(value.getTransactionFees()));
        paymentInitiationRequestResponse.setTransactionFeeIndicator(Boolean.valueOf(value.isTransactionFeeIndicator()));
        paymentInitiationRequestResponse.setScaMethods(this.authenticationObjectArrayToAuthenticationObjectList(value.getScaMethods()));
        paymentInitiationRequestResponse.setChallengeData(this.challengeDataToChallengeData(value.getChallengeData()));
        paymentInitiationRequestResponse.setLinks(this.stringLinkMapToStringHrefTypeMap(value.getLinks()));
        paymentInitiationRequestResponse.setPsuMessage(value.getPsuMessage());
        paymentInitiationRequestResponse.setTppMessages(this.tppMessageListToTppMessageList(value.getTppMessages()));
        return paymentInitiationRequestResponse;
    }

    @Override
    public SinglePaymentInitiationBody toSinglePaymentInitiationBody(PaymentInitiation value) {
        if (value == null) {
            return null;
        }
        SinglePaymentInitiationBody singlePaymentInitiationBody = new SinglePaymentInitiationBody();
        singlePaymentInitiationBody.setDebtorAccount(this.accountReferenceToAccountReference1(value.getDebtorAccount()));
        singlePaymentInitiationBody.setInstructedAmount(this.amountToAmount1(value.getInstructedAmount()));
        singlePaymentInitiationBody.setCreditorAccount(this.accountReferenceToAccountReference1(value.getCreditorAccount()));
        singlePaymentInitiationBody.setCreditorName(value.getCreditorName());
        singlePaymentInitiationBody.setCreditorAgent(value.getCreditorAgent());
        singlePaymentInitiationBody.setCreditorAgentName(value.getCreditorAgentName());
        singlePaymentInitiationBody.setCreditorAddress(this.addressToAddress1(value.getCreditorAddress()));
        singlePaymentInitiationBody.setRemittanceInformationUnstructured(value.getRemittanceInformationUnstructured());
        singlePaymentInitiationBody.setEndToEndIdentification(value.getEndToEndIdentification());
        return singlePaymentInitiationBody;
    }

    @Override
    public PaymentInitiationWithStatusResponse toPaymentInitiationWithStatusResponse(SinglePaymentInitiationInformationWithStatusResponse value) {
        if (value == null) {
            return null;
        }
        PaymentInitiationWithStatusResponse paymentInitiationWithStatusResponse = new PaymentInitiationWithStatusResponse();
        paymentInitiationWithStatusResponse.setEndToEndIdentification(value.getEndToEndIdentification());
        paymentInitiationWithStatusResponse.setDebtorAccount(this.accountReferenceToAccountReference(value.getDebtorAccount()));
        paymentInitiationWithStatusResponse.setInstructedAmount(this.amountToAmount(value.getInstructedAmount()));
        paymentInitiationWithStatusResponse.setCreditorAccount(this.accountReferenceToAccountReference(value.getCreditorAccount()));
        paymentInitiationWithStatusResponse.setCreditorAgent(value.getCreditorAgent());
        paymentInitiationWithStatusResponse.setCreditorName(value.getCreditorName());
        paymentInitiationWithStatusResponse.setCreditorAddress(this.addressToAddress(value.getCreditorAddress()));
        paymentInitiationWithStatusResponse.setRemittanceInformationUnstructured(value.getRemittanceInformationUnstructured());
        paymentInitiationWithStatusResponse.setTransactionStatus(this.map(value.getTransactionStatus()));
        return paymentInitiationWithStatusResponse;
    }

    @Override
    public Authorisations toAuthorisations(PaymentInitiationAuthorisationResponse value) {
        if (value == null) {
            return null;
        }
        Authorisations authorisations = new Authorisations();
        List list = value.getAuthorisationIds();
        if (list != null) {
            authorisations.setAuthorisationIds(new ArrayList(list));
        }
        return authorisations;
    }

    @Override
    public de.adorsys.xs2a.adapter.service.psd2.model.ScaStatusResponse toScaStatusResponse(PaymentInitiationScaStatusResponse value) {
        if (value == null) {
            return null;
        }
        de.adorsys.xs2a.adapter.service.psd2.model.ScaStatusResponse scaStatusResponse = new de.adorsys.xs2a.adapter.service.psd2.model.ScaStatusResponse();
        scaStatusResponse.setScaStatus(this.map((Enum<?>)value.getScaStatus()));
        return scaStatusResponse;
    }

    @Override
    public TransactionDetailsResponse toTransactionDetailsResponse(TransactionDetails value) {
        if (value == null) {
            return null;
        }
        TransactionDetailsResponse transactionDetailsResponse = new TransactionDetailsResponse();
        transactionDetailsResponse.setTransactionsDetails(this.map(value.getTransactionsDetails()));
        return transactionDetailsResponse;
    }

    protected Amount amountToAmount(de.adorsys.xs2a.adapter.service.model.Amount amount) {
        if (amount == null) {
            return null;
        }
        Amount amount1 = new Amount();
        amount1.setCurrency(amount.getCurrency());
        amount1.setAmount(amount.getAmount());
        return amount1;
    }

    protected Balance balanceToBalance(de.adorsys.xs2a.adapter.service.model.Balance balance) {
        if (balance == null) {
            return null;
        }
        Balance balance1 = new Balance();
        balance1.setBalanceAmount(this.amountToAmount(balance.getBalanceAmount()));
        balance1.setBalanceType(this.map((Enum<?>)balance.getBalanceType()));
        balance1.setLastChangeDateTime(balance.getLastChangeDateTime());
        balance1.setReferenceDate(balance.getReferenceDate());
        balance1.setLastCommittedTransaction(balance.getLastCommittedTransaction());
        return balance1;
    }

    protected List<Balance> balanceListToBalanceList(List<de.adorsys.xs2a.adapter.service.model.Balance> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Balance> list1 = new ArrayList<Balance>(list.size());
        for (de.adorsys.xs2a.adapter.service.model.Balance balance : list) {
            list1.add(this.balanceToBalance(balance));
        }
        return list1;
    }

    protected HrefType linkToHrefType(Link link) {
        if (link == null) {
            return null;
        }
        HrefType hrefType = new HrefType();
        hrefType.setHref(link.getHref());
        return hrefType;
    }

    protected Map<String, HrefType> stringLinkMapToStringHrefTypeMap(Map<String, Link> map) {
        if (map == null) {
            return null;
        }
        HashMap<String, HrefType> map1 = new HashMap<String, HrefType>(Math.max((int)((float)map.size() / 0.75f) + 1, 16));
        for (Map.Entry<String, Link> entry : map.entrySet()) {
            String key = entry.getKey();
            HrefType value = this.linkToHrefType(entry.getValue());
            map1.put(key, value);
        }
        return map1;
    }

    protected AccountDetails accountDetailsToAccountDetails(de.adorsys.xs2a.adapter.service.model.AccountDetails accountDetails) {
        if (accountDetails == null) {
            return null;
        }
        AccountDetails accountDetails1 = new AccountDetails();
        accountDetails1.setResourceId(accountDetails.getResourceId());
        accountDetails1.setIban(accountDetails.getIban());
        accountDetails1.setBban(accountDetails.getBban());
        accountDetails1.setMsisdn(accountDetails.getMsisdn());
        accountDetails1.setCurrency(accountDetails.getCurrency());
        accountDetails1.setName(accountDetails.getName());
        accountDetails1.setDisplayName(accountDetails.getDisplayName());
        accountDetails1.setProduct(accountDetails.getProduct());
        accountDetails1.setCashAccountType(this.map((Enum<?>)accountDetails.getCashAccountType()));
        accountDetails1.setStatus(this.map((Enum<?>)accountDetails.getStatus()));
        accountDetails1.setBic(accountDetails.getBic());
        accountDetails1.setLinkedAccounts(accountDetails.getLinkedAccounts());
        accountDetails1.setDetails(accountDetails.getDetails());
        accountDetails1.setBalances(this.balanceListToBalanceList(accountDetails.getBalances()));
        accountDetails1.setLinks(this.stringLinkMapToStringHrefTypeMap(accountDetails.getLinks()));
        accountDetails1.setOwnerName(accountDetails.getOwnerName());
        return accountDetails1;
    }

    protected List<AccountDetails> accountDetailsListToAccountDetailsList(List<de.adorsys.xs2a.adapter.service.model.AccountDetails> list) {
        if (list == null) {
            return null;
        }
        ArrayList<AccountDetails> list1 = new ArrayList<AccountDetails>(list.size());
        for (de.adorsys.xs2a.adapter.service.model.AccountDetails accountDetails : list) {
            list1.add(this.accountDetailsToAccountDetails(accountDetails));
        }
        return list1;
    }

    protected de.adorsys.xs2a.adapter.service.psd2.model.AccountReference accountReferenceToAccountReference(AccountReference accountReference) {
        if (accountReference == null) {
            return null;
        }
        de.adorsys.xs2a.adapter.service.psd2.model.AccountReference accountReference1 = new de.adorsys.xs2a.adapter.service.psd2.model.AccountReference();
        accountReference1.setIban(accountReference.getIban());
        accountReference1.setBban(accountReference.getBban());
        accountReference1.setPan(accountReference.getPan());
        accountReference1.setMaskedPan(accountReference.getMaskedPan());
        accountReference1.setMsisdn(accountReference.getMsisdn());
        accountReference1.setCurrency(accountReference.getCurrency());
        return accountReference1;
    }

    protected List<de.adorsys.xs2a.adapter.service.psd2.model.TransactionDetails> transactionsListToTransactionDetailsList(List<Transactions> list) {
        if (list == null) {
            return null;
        }
        ArrayList<de.adorsys.xs2a.adapter.service.psd2.model.TransactionDetails> list1 = new ArrayList<de.adorsys.xs2a.adapter.service.psd2.model.TransactionDetails>(list.size());
        for (Transactions transactions : list) {
            list1.add(this.map(transactions));
        }
        return list1;
    }

    protected AccountReport accountReportToAccountReport(de.adorsys.xs2a.adapter.service.model.AccountReport accountReport) {
        if (accountReport == null) {
            return null;
        }
        AccountReport accountReport1 = new AccountReport();
        accountReport1.setBooked(this.transactionsListToTransactionDetailsList(accountReport.getBooked()));
        accountReport1.setPending(this.transactionsListToTransactionDetailsList(accountReport.getPending()));
        accountReport1.setLinks(this.stringLinkMapToStringHrefTypeMap(accountReport.getLinks()));
        return accountReport1;
    }

    private String valuePurposeCodeCode(Transactions transactions) {
        if (transactions == null) {
            return null;
        }
        PurposeCode purposeCode = transactions.getPurposeCode();
        if (purposeCode == null) {
            return null;
        }
        String code = purposeCode.getCode();
        if (code == null) {
            return null;
        }
        return code;
    }

    private String valueBankTransactionCodeCode(Transactions transactions) {
        if (transactions == null) {
            return null;
        }
        BankTransactionCode bankTransactionCode = transactions.getBankTransactionCode();
        if (bankTransactionCode == null) {
            return null;
        }
        String code = bankTransactionCode.getCode();
        if (code == null) {
            return null;
        }
        return code;
    }

    protected RemittanceInformationStructured remittanceInformationStructuredToRemittanceInformationStructured(de.adorsys.xs2a.adapter.service.model.RemittanceInformationStructured remittanceInformationStructured) {
        if (remittanceInformationStructured == null) {
            return null;
        }
        RemittanceInformationStructured remittanceInformationStructured1 = new RemittanceInformationStructured();
        remittanceInformationStructured1.setReference(remittanceInformationStructured.getReference());
        remittanceInformationStructured1.setReferenceType(remittanceInformationStructured.getReferenceType());
        remittanceInformationStructured1.setReferenceIssuer(remittanceInformationStructured.getReferenceIssuer());
        return remittanceInformationStructured1;
    }

    protected List<RemittanceInformationStructured> remittanceInformationStructuredListToRemittanceInformationStructuredList(List<de.adorsys.xs2a.adapter.service.model.RemittanceInformationStructured> list) {
        if (list == null) {
            return null;
        }
        ArrayList<RemittanceInformationStructured> list1 = new ArrayList<RemittanceInformationStructured>(list.size());
        for (de.adorsys.xs2a.adapter.service.model.RemittanceInformationStructured remittanceInformationStructured : list) {
            list1.add(this.remittanceInformationStructuredToRemittanceInformationStructured(remittanceInformationStructured));
        }
        return list1;
    }

    protected List<String> monthsOfExecutionTOListToStringList(List<StandingOrderDetails.MonthsOfExecutionTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<String> list1 = new ArrayList<String>(list.size());
        for (StandingOrderDetails.MonthsOfExecutionTO monthsOfExecutionTO : list) {
            list1.add(this.map((Enum<?>)monthsOfExecutionTO));
        }
        return list1;
    }

    protected StandingOrderDetails standingOrderDetailsToStandingOrderDetails(de.adorsys.xs2a.adapter.service.model.StandingOrderDetails standingOrderDetails) {
        if (standingOrderDetails == null) {
            return null;
        }
        StandingOrderDetails standingOrderDetails1 = new StandingOrderDetails();
        standingOrderDetails1.setStartDate(standingOrderDetails.getStartDate());
        standingOrderDetails1.setFrequency(this.map((Enum<?>)standingOrderDetails.getFrequency()));
        standingOrderDetails1.setEndDate(standingOrderDetails.getEndDate());
        standingOrderDetails1.setExecutionRule(this.map((Enum<?>)standingOrderDetails.getExecutionRule()));
        standingOrderDetails1.setWithinAMonthFlag(standingOrderDetails.getWithinAMonthFlag());
        standingOrderDetails1.setMonthsOfExecution(this.monthsOfExecutionTOListToStringList(standingOrderDetails.getMonthsOfExecution()));
        standingOrderDetails1.setMultiplicator(standingOrderDetails.getMultiplicator());
        standingOrderDetails1.setDayOfExecution(this.map((Enum<?>)standingOrderDetails.getDayOfExecution()));
        standingOrderDetails1.setLimitAmount(this.amountToAmount(standingOrderDetails.getLimitAmount()));
        return standingOrderDetails1;
    }

    protected AdditionalInformationStructured additionalInformationStructuredToAdditionalInformationStructured(de.adorsys.xs2a.adapter.service.model.AdditionalInformationStructured additionalInformationStructured) {
        if (additionalInformationStructured == null) {
            return null;
        }
        AdditionalInformationStructured additionalInformationStructured1 = new AdditionalInformationStructured();
        additionalInformationStructured1.setStandingOrderDetails(this.standingOrderDetailsToStandingOrderDetails(additionalInformationStructured.getStandingOrderDetails()));
        return additionalInformationStructured1;
    }

    protected AccountReference accountReferenceToAccountReference1(de.adorsys.xs2a.adapter.service.psd2.model.AccountReference accountReference) {
        if (accountReference == null) {
            return null;
        }
        AccountReference accountReference1 = new AccountReference();
        accountReference1.setIban(accountReference.getIban());
        accountReference1.setBban(accountReference.getBban());
        accountReference1.setPan(accountReference.getPan());
        accountReference1.setMaskedPan(accountReference.getMaskedPan());
        accountReference1.setMsisdn(accountReference.getMsisdn());
        accountReference1.setCurrency(accountReference.getCurrency());
        return accountReference1;
    }

    protected List<AccountReference> accountReferenceListToAccountReferenceList(List<de.adorsys.xs2a.adapter.service.psd2.model.AccountReference> list) {
        if (list == null) {
            return null;
        }
        ArrayList<AccountReference> list1 = new ArrayList<AccountReference>(list.size());
        for (de.adorsys.xs2a.adapter.service.psd2.model.AccountReference accountReference : list) {
            list1.add(this.accountReferenceToAccountReference1(accountReference));
        }
        return list1;
    }

    protected de.adorsys.xs2a.adapter.service.model.AdditionalInformationAccess additionalInformationAccessToAdditionalInformationAccess(AdditionalInformationAccess additionalInformationAccess) {
        if (additionalInformationAccess == null) {
            return null;
        }
        de.adorsys.xs2a.adapter.service.model.AdditionalInformationAccess additionalInformationAccess1 = new de.adorsys.xs2a.adapter.service.model.AdditionalInformationAccess();
        additionalInformationAccess1.setOwnerName(this.accountReferenceListToAccountReferenceList(additionalInformationAccess.getOwnerName()));
        return additionalInformationAccess1;
    }

    protected de.adorsys.xs2a.adapter.service.model.AccountAccess accountAccessToAccountAccess(AccountAccess accountAccess) {
        if (accountAccess == null) {
            return null;
        }
        de.adorsys.xs2a.adapter.service.model.AccountAccess accountAccess1 = new de.adorsys.xs2a.adapter.service.model.AccountAccess();
        accountAccess1.setAccounts(this.accountReferenceListToAccountReferenceList(accountAccess.getAccounts()));
        accountAccess1.setBalances(this.accountReferenceListToAccountReferenceList(accountAccess.getBalances()));
        accountAccess1.setTransactions(this.accountReferenceListToAccountReferenceList(accountAccess.getTransactions()));
        accountAccess1.setAdditionalInformation(this.additionalInformationAccessToAdditionalInformationAccess(accountAccess.getAdditionalInformation()));
        if (accountAccess.getAvailableAccounts() != null) {
            accountAccess1.setAvailableAccounts(Enum.valueOf(AccountAccess.AvailableAccountsEnum.class, accountAccess.getAvailableAccounts()));
        }
        if (accountAccess.getAvailableAccountsWithBalance() != null) {
            accountAccess1.setAvailableAccountsWithBalance(Enum.valueOf(AccountAccess.AvailableAccountsWithBalance.class, accountAccess.getAvailableAccountsWithBalance()));
        }
        if (accountAccess.getAllPsd2() != null) {
            accountAccess1.setAllPsd2(Enum.valueOf(AccountAccess.AllPsd2Enum.class, accountAccess.getAllPsd2()));
        }
        return accountAccess1;
    }

    protected de.adorsys.xs2a.adapter.service.psd2.model.AuthenticationObject authenticationObjectToAuthenticationObject(AuthenticationObject authenticationObject) {
        if (authenticationObject == null) {
            return null;
        }
        de.adorsys.xs2a.adapter.service.psd2.model.AuthenticationObject authenticationObject1 = new de.adorsys.xs2a.adapter.service.psd2.model.AuthenticationObject();
        authenticationObject1.setAuthenticationType(authenticationObject.getAuthenticationType());
        authenticationObject1.setAuthenticationVersion(authenticationObject.getAuthenticationVersion());
        authenticationObject1.setAuthenticationMethodId(authenticationObject.getAuthenticationMethodId());
        authenticationObject1.setName(authenticationObject.getName());
        authenticationObject1.setExplanation(authenticationObject.getExplanation());
        return authenticationObject1;
    }

    protected List<de.adorsys.xs2a.adapter.service.psd2.model.AuthenticationObject> authenticationObjectListToAuthenticationObjectList(List<AuthenticationObject> list) {
        if (list == null) {
            return null;
        }
        ArrayList<de.adorsys.xs2a.adapter.service.psd2.model.AuthenticationObject> list1 = new ArrayList<de.adorsys.xs2a.adapter.service.psd2.model.AuthenticationObject>(list.size());
        for (AuthenticationObject authenticationObject : list) {
            list1.add(this.authenticationObjectToAuthenticationObject(authenticationObject));
        }
        return list1;
    }

    protected ChallengeData challengeDataToChallengeData(de.adorsys.xs2a.adapter.service.model.ChallengeData challengeData) {
        List list;
        if (challengeData == null) {
            return null;
        }
        ChallengeData challengeData1 = new ChallengeData();
        byte[] image = challengeData.getImage();
        if (image != null) {
            challengeData1.setImage(Arrays.copyOf(image, image.length));
        }
        if ((list = challengeData.getData()) != null) {
            challengeData1.setData(new ArrayList(list));
        }
        challengeData1.setImageLink(challengeData.getImageLink());
        challengeData1.setOtpMaxLength(challengeData.getOtpMaxLength());
        challengeData1.setOtpFormat(this.map((Enum<?>)challengeData.getOtpFormat()));
        challengeData1.setAdditionalInformation(challengeData.getAdditionalInformation());
        return challengeData1;
    }

    protected List<de.adorsys.xs2a.adapter.service.psd2.model.AccountReference> accountReferenceListToAccountReferenceList1(List<AccountReference> list) {
        if (list == null) {
            return null;
        }
        ArrayList<de.adorsys.xs2a.adapter.service.psd2.model.AccountReference> list1 = new ArrayList<de.adorsys.xs2a.adapter.service.psd2.model.AccountReference>(list.size());
        for (AccountReference accountReference : list) {
            list1.add(this.accountReferenceToAccountReference(accountReference));
        }
        return list1;
    }

    protected AdditionalInformationAccess additionalInformationAccessToAdditionalInformationAccess1(de.adorsys.xs2a.adapter.service.model.AdditionalInformationAccess additionalInformationAccess) {
        if (additionalInformationAccess == null) {
            return null;
        }
        AdditionalInformationAccess additionalInformationAccess1 = new AdditionalInformationAccess();
        additionalInformationAccess1.setOwnerName(this.accountReferenceListToAccountReferenceList1(additionalInformationAccess.getOwnerName()));
        return additionalInformationAccess1;
    }

    protected AccountAccess accountAccessToAccountAccess1(de.adorsys.xs2a.adapter.service.model.AccountAccess accountAccess) {
        if (accountAccess == null) {
            return null;
        }
        AccountAccess accountAccess1 = new AccountAccess();
        accountAccess1.setAccounts(this.accountReferenceListToAccountReferenceList1(accountAccess.getAccounts()));
        accountAccess1.setBalances(this.accountReferenceListToAccountReferenceList1(accountAccess.getBalances()));
        accountAccess1.setTransactions(this.accountReferenceListToAccountReferenceList1(accountAccess.getTransactions()));
        accountAccess1.setAdditionalInformation(this.additionalInformationAccessToAdditionalInformationAccess1(accountAccess.getAdditionalInformation()));
        accountAccess1.setAvailableAccounts(this.map((Enum<?>)accountAccess.getAvailableAccounts()));
        accountAccess1.setAvailableAccountsWithBalance(this.map((Enum<?>)accountAccess.getAvailableAccountsWithBalance()));
        accountAccess1.setAllPsd2(this.map((Enum<?>)accountAccess.getAllPsd2()));
        return accountAccess1;
    }

    protected de.adorsys.xs2a.adapter.service.model.PsuData psuDataToPsuData(PsuData psuData) {
        if (psuData == null) {
            return null;
        }
        de.adorsys.xs2a.adapter.service.model.PsuData psuData1 = new de.adorsys.xs2a.adapter.service.model.PsuData();
        psuData1.setPassword(psuData.getPassword());
        psuData1.setEncryptedPassword(psuData.getEncryptedPassword());
        return psuData1;
    }

    protected de.adorsys.xs2a.adapter.service.psd2.model.CardAccountDetails cardAccountDetailsToCardAccountDetails(CardAccountDetails cardAccountDetails) {
        if (cardAccountDetails == null) {
            return null;
        }
        de.adorsys.xs2a.adapter.service.psd2.model.CardAccountDetails cardAccountDetails1 = new de.adorsys.xs2a.adapter.service.psd2.model.CardAccountDetails();
        cardAccountDetails1.setResourceId(cardAccountDetails.getResourceId());
        cardAccountDetails1.setMaskedPan(cardAccountDetails.getMaskedPan());
        cardAccountDetails1.setCurrency(cardAccountDetails.getCurrency());
        cardAccountDetails1.setOwnerName(cardAccountDetails.getOwnerName());
        cardAccountDetails1.setName(cardAccountDetails.getName());
        cardAccountDetails1.setDisplayName(cardAccountDetails.getDisplayName());
        cardAccountDetails1.setProduct(cardAccountDetails.getProduct());
        cardAccountDetails1.setStatus(this.map((Enum<?>)cardAccountDetails.getStatus()));
        cardAccountDetails1.setUsage(this.map((Enum<?>)cardAccountDetails.getUsage()));
        cardAccountDetails1.setDetails(cardAccountDetails.getDetails());
        cardAccountDetails1.setCreditLimit(this.amountToAmount(cardAccountDetails.getCreditLimit()));
        cardAccountDetails1.setBalances(this.balanceListToBalanceList(cardAccountDetails.getBalances()));
        cardAccountDetails1.setLinks(this.stringLinkMapToStringHrefTypeMap(cardAccountDetails.getLinks()));
        return cardAccountDetails1;
    }

    protected List<de.adorsys.xs2a.adapter.service.psd2.model.CardAccountDetails> cardAccountDetailsListToCardAccountDetailsList(List<CardAccountDetails> list) {
        if (list == null) {
            return null;
        }
        ArrayList<de.adorsys.xs2a.adapter.service.psd2.model.CardAccountDetails> list1 = new ArrayList<de.adorsys.xs2a.adapter.service.psd2.model.CardAccountDetails>(list.size());
        for (CardAccountDetails cardAccountDetails : list) {
            list1.add(this.cardAccountDetailsToCardAccountDetails(cardAccountDetails));
        }
        return list1;
    }

    protected ReportExchangeRate reportExchangeRateToReportExchangeRate(de.adorsys.xs2a.adapter.service.model.ReportExchangeRate reportExchangeRate) {
        if (reportExchangeRate == null) {
            return null;
        }
        ReportExchangeRate reportExchangeRate1 = new ReportExchangeRate();
        reportExchangeRate1.setSourceCurrency(reportExchangeRate.getSourceCurrency());
        reportExchangeRate1.setExchangeRate(reportExchangeRate.getExchangeRate());
        reportExchangeRate1.setUnitCurrency(reportExchangeRate.getUnitCurrency());
        reportExchangeRate1.setTargetCurrency(reportExchangeRate.getTargetCurrency());
        reportExchangeRate1.setQuotationDate(reportExchangeRate.getQuotationDate());
        reportExchangeRate1.setContractIdentification(reportExchangeRate.getContractIdentification());
        return reportExchangeRate1;
    }

    protected List<ReportExchangeRate> reportExchangeRateListToReportExchangeRateList(List<de.adorsys.xs2a.adapter.service.model.ReportExchangeRate> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ReportExchangeRate> list1 = new ArrayList<ReportExchangeRate>(list.size());
        for (de.adorsys.xs2a.adapter.service.model.ReportExchangeRate reportExchangeRate : list) {
            list1.add(this.reportExchangeRateToReportExchangeRate(reportExchangeRate));
        }
        return list1;
    }

    protected de.adorsys.xs2a.adapter.service.psd2.model.Address addressToAddress(Address address) {
        if (address == null) {
            return null;
        }
        de.adorsys.xs2a.adapter.service.psd2.model.Address address1 = new de.adorsys.xs2a.adapter.service.psd2.model.Address();
        address1.setStreetName(address.getStreetName());
        address1.setBuildingNumber(address.getBuildingNumber());
        address1.setTownName(address.getTownName());
        address1.setPostCode(address.getPostCode());
        address1.setCountry(address.getCountry());
        return address1;
    }

    protected de.adorsys.xs2a.adapter.service.psd2.model.CardTransaction cardTransactionToCardTransaction(CardTransaction cardTransaction) {
        if (cardTransaction == null) {
            return null;
        }
        de.adorsys.xs2a.adapter.service.psd2.model.CardTransaction cardTransaction1 = new de.adorsys.xs2a.adapter.service.psd2.model.CardTransaction();
        cardTransaction1.setCardTransactionId(cardTransaction.getCardTransactionId());
        cardTransaction1.setTerminalId(cardTransaction.getTerminalId());
        cardTransaction1.setTransactionDate(cardTransaction.getTransactionDate());
        cardTransaction1.setAcceptorTransactionDateTime(cardTransaction.getAcceptorTransactionDateTime());
        cardTransaction1.setBookingDate(cardTransaction.getBookingDate());
        cardTransaction1.setTransactionAmount(this.amountToAmount(cardTransaction.getTransactionAmount()));
        cardTransaction1.setCurrencyExchange(this.reportExchangeRateListToReportExchangeRateList(cardTransaction.getCurrencyExchange()));
        cardTransaction1.setOriginalAmount(this.amountToAmount(cardTransaction.getOriginalAmount()));
        cardTransaction1.setMarkupFee(this.amountToAmount(cardTransaction.getMarkupFee()));
        cardTransaction1.setMarkupFeePercentage(cardTransaction.getMarkupFeePercentage());
        cardTransaction1.setCardAcceptorId(cardTransaction.getCardAcceptorId());
        cardTransaction1.setCardAcceptorAddress(this.addressToAddress(cardTransaction.getCardAcceptorAddress()));
        cardTransaction1.setCardAcceptorPhone(cardTransaction.getCardAcceptorPhone());
        cardTransaction1.setMerchantCategoryCode(cardTransaction.getMerchantCategoryCode());
        cardTransaction1.setMaskedPAN(cardTransaction.getMaskedPAN());
        cardTransaction1.setTransactionDetails(cardTransaction.getTransactionDetails());
        cardTransaction1.setInvoiced(cardTransaction.getInvoiced());
        cardTransaction1.setProprietaryBankTransactionCode(cardTransaction.getProprietaryBankTransactionCode());
        return cardTransaction1;
    }

    protected List<de.adorsys.xs2a.adapter.service.psd2.model.CardTransaction> cardTransactionListToCardTransactionList(List<CardTransaction> list) {
        if (list == null) {
            return null;
        }
        ArrayList<de.adorsys.xs2a.adapter.service.psd2.model.CardTransaction> list1 = new ArrayList<de.adorsys.xs2a.adapter.service.psd2.model.CardTransaction>(list.size());
        for (CardTransaction cardTransaction : list) {
            list1.add(this.cardTransactionToCardTransaction(cardTransaction));
        }
        return list1;
    }

    protected CardAccountReport cardAccountReportToCardAccountReport(de.adorsys.xs2a.adapter.service.model.CardAccountReport cardAccountReport) {
        if (cardAccountReport == null) {
            return null;
        }
        CardAccountReport cardAccountReport1 = new CardAccountReport();
        cardAccountReport1.setBooked(this.cardTransactionListToCardTransactionList(cardAccountReport.getBooked()));
        cardAccountReport1.setPending(this.cardTransactionListToCardTransactionList(cardAccountReport.getPending()));
        cardAccountReport1.setLinks(this.stringLinkMapToStringHrefTypeMap(cardAccountReport.getLinks()));
        return cardAccountReport1;
    }

    protected List<de.adorsys.xs2a.adapter.service.psd2.model.AuthenticationObject> authenticationObjectArrayToAuthenticationObjectList(AuthenticationObject[] authenticationObjectArray) {
        if (authenticationObjectArray == null) {
            return null;
        }
        ArrayList<de.adorsys.xs2a.adapter.service.psd2.model.AuthenticationObject> list = new ArrayList<de.adorsys.xs2a.adapter.service.psd2.model.AuthenticationObject>(authenticationObjectArray.length);
        for (AuthenticationObject authenticationObject : authenticationObjectArray) {
            list.add(this.authenticationObjectToAuthenticationObject(authenticationObject));
        }
        return list;
    }

    protected TppMessage tppMessageToTppMessage(de.adorsys.xs2a.adapter.service.model.TppMessage tppMessage) {
        if (tppMessage == null) {
            return null;
        }
        TppMessage tppMessage1 = new TppMessage();
        tppMessage1.setCategory(tppMessage.getCategory());
        tppMessage1.setCode(tppMessage.getCode());
        tppMessage1.setPath(tppMessage.getPath());
        tppMessage1.setText(tppMessage.getText());
        return tppMessage1;
    }

    protected List<TppMessage> tppMessageListToTppMessageList(List<de.adorsys.xs2a.adapter.service.model.TppMessage> list) {
        if (list == null) {
            return null;
        }
        ArrayList<TppMessage> list1 = new ArrayList<TppMessage>(list.size());
        for (de.adorsys.xs2a.adapter.service.model.TppMessage tppMessage : list) {
            list1.add(this.tppMessageToTppMessage(tppMessage));
        }
        return list1;
    }

    protected de.adorsys.xs2a.adapter.service.model.Amount amountToAmount1(Amount amount) {
        if (amount == null) {
            return null;
        }
        de.adorsys.xs2a.adapter.service.model.Amount amount1 = new de.adorsys.xs2a.adapter.service.model.Amount();
        amount1.setCurrency(amount.getCurrency());
        amount1.setAmount(amount.getAmount());
        return amount1;
    }

    protected Address addressToAddress1(de.adorsys.xs2a.adapter.service.psd2.model.Address address) {
        if (address == null) {
            return null;
        }
        Address address1 = new Address();
        address1.setStreetName(address.getStreetName());
        address1.setBuildingNumber(address.getBuildingNumber());
        address1.setTownName(address.getTownName());
        address1.setPostCode(address.getPostCode());
        address1.setCountry(address.getCountry());
        return address1;
    }
}

