/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.loader;

import de.adorsys.xs2a.adapter.service.PaymentInitiationService;
import de.adorsys.xs2a.adapter.service.RequestHeaders;
import de.adorsys.xs2a.adapter.service.RequestParams;
import de.adorsys.xs2a.adapter.service.Response;
import de.adorsys.xs2a.adapter.service.exception.BadRequestException;
import de.adorsys.xs2a.adapter.service.loader.mapper.Xs2aPsd2Mapper;
import de.adorsys.xs2a.adapter.service.psd2.Psd2PaymentInitiationService;
import de.adorsys.xs2a.adapter.service.psd2.model.Authorisations;
import de.adorsys.xs2a.adapter.service.psd2.model.PaymentInitiation;
import de.adorsys.xs2a.adapter.service.psd2.model.PaymentInitiationRequestResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.PaymentProduct;
import de.adorsys.xs2a.adapter.service.psd2.model.PaymentService;
import de.adorsys.xs2a.adapter.service.psd2.model.ScaStatusResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.StartScaProcessResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.UpdateAuthorisation;
import de.adorsys.xs2a.adapter.service.psd2.model.UpdateAuthorisationResponse;
import java.util.Map;
import java.util.function.Function;
import org.mapstruct.factory.Mappers;

class Xs2aPsd2PaymentInitiationServiceAdapter
implements Psd2PaymentInitiationService {
    private final PaymentInitiationService paymentInitiationService;
    private final Xs2aPsd2Mapper mapper = (Xs2aPsd2Mapper)Mappers.getMapper(Xs2aPsd2Mapper.class);

    Xs2aPsd2PaymentInitiationServiceAdapter(PaymentInitiationService paymentInitiationService) {
        this.paymentInitiationService = paymentInitiationService;
    }

    public Response<PaymentInitiationRequestResponse> initiatePayment(PaymentService paymentService, PaymentProduct paymentProduct, Map<String, String> queryParameters, Map<String, String> headers, PaymentInitiation body) {
        this.requireSinglePayment(paymentService);
        return this.paymentInitiationService.initiateSinglePayment(paymentProduct.toString(), RequestHeaders.fromMap(headers), RequestParams.fromMap(queryParameters), (Object)this.mapper.toSinglePaymentInitiationBody(body)).map(this.mapper::toPaymentInitiationRequestResponse);
    }

    private void requireSinglePayment(PaymentService paymentService) {
        if (paymentService != PaymentService.PAYMENTS) {
            throw new UnsupportedOperationException();
        }
    }

    public Response<PaymentInitiationRequestResponse> initiatePayment(PaymentService paymentService, PaymentProduct paymentProduct, Map<String, String> queryParameters, Map<String, String> headers, String body) {
        this.requireSinglePayment(paymentService);
        return this.paymentInitiationService.initiateSinglePayment(paymentProduct.toString(), RequestHeaders.fromMap(headers), RequestParams.fromMap(queryParameters), (Object)body).map(this.mapper::toPaymentInitiationRequestResponse);
    }

    public Response<Object> getPaymentInformation(PaymentService paymentService, PaymentProduct paymentProduct, String paymentId, Map<String, String> queryParameters, Map<String, String> headers) {
        this.requireSinglePayment(paymentService);
        return this.paymentInitiationService.getSinglePaymentInformationAsString(paymentProduct.toString(), paymentId, RequestHeaders.fromMap(headers), RequestParams.fromMap(queryParameters)).map(Function.identity());
    }

    public Response<Object> getPaymentInitiationStatus(PaymentService paymentService, PaymentProduct paymentProduct, String paymentId, Map<String, String> queryParameters, Map<String, String> headers) {
        this.requireSinglePayment(paymentService);
        return this.paymentInitiationService.getSinglePaymentInitiationStatusAsString(paymentProduct.toString(), paymentId, RequestHeaders.fromMap(headers), RequestParams.fromMap(queryParameters)).map(Function.identity());
    }

    public Response<Authorisations> getPaymentInitiationAuthorisation(PaymentService paymentService, PaymentProduct paymentProduct, String paymentId, Map<String, String> queryParameters, Map<String, String> headers) {
        return this.paymentInitiationService.getPaymentInitiationAuthorisation(paymentService.toString(), paymentProduct.toString(), paymentId, RequestHeaders.fromMap(headers), RequestParams.fromMap(queryParameters)).map(this.mapper::toAuthorisations);
    }

    public Response<StartScaProcessResponse> startPaymentAuthorisation(PaymentService paymentService, PaymentProduct paymentProduct, String paymentId, Map<String, String> queryParameters, Map<String, String> headers, UpdateAuthorisation body) {
        this.requireSinglePayment(paymentService);
        return this.paymentInitiationService.startSinglePaymentAuthorisation(paymentProduct.toString(), paymentId, RequestHeaders.fromMap(headers), RequestParams.fromMap(queryParameters), this.mapper.toUpdatePsuAuthentication(body)).map(this.mapper::toStartScaprocessResponse);
    }

    public Response<ScaStatusResponse> getPaymentInitiationScaStatus(PaymentService paymentService, PaymentProduct paymentProduct, String paymentId, String authorisationId, Map<String, String> queryParameters, Map<String, String> headers) {
        return this.paymentInitiationService.getPaymentInitiationScaStatus(paymentService.toString(), paymentProduct.toString(), paymentId, authorisationId, RequestHeaders.fromMap(headers), RequestParams.fromMap(queryParameters)).map(this.mapper::toScaStatusResponse);
    }

    public Response<UpdateAuthorisationResponse> updatePaymentPsuData(PaymentService paymentService, PaymentProduct paymentProduct, String paymentId, String authorisationId, Map<String, String> queryParameters, Map<String, String> headers, UpdateAuthorisation body) {
        if (body.getPsuData() != null) {
            return this.paymentInitiationService.updatePaymentPsuData(paymentService.toString(), paymentProduct.toString(), paymentId, authorisationId, RequestHeaders.fromMap(headers), RequestParams.fromMap(queryParameters), this.mapper.toUpdatePsuAuthentication(body)).map(this.mapper::toUpdateAuthorisationResponse);
        }
        if (body.getAuthenticationMethodId() != null) {
            return this.paymentInitiationService.updatePaymentPsuData(paymentService.toString(), paymentProduct.toString(), paymentId, authorisationId, RequestHeaders.fromMap(headers), RequestParams.fromMap(queryParameters), this.mapper.toSelectPsuAuthenticationMethod(body)).map(this.mapper::toUpdateAuthorisationResponse);
        }
        if (body.getScaAuthenticationData() != null) {
            return this.paymentInitiationService.updatePaymentPsuData(paymentService.toString(), paymentProduct.toString(), paymentId, authorisationId, RequestHeaders.fromMap(headers), RequestParams.fromMap(queryParameters), this.mapper.toTransactionAuthorisation(body)).map(this.mapper::toUpdateAuthorisationResponse);
        }
        throw new BadRequestException("Request body doesn't match any of the supported schemas");
    }
}

