/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.loader;

import de.adorsys.xs2a.adapter.http.HttpClientFactory;
import de.adorsys.xs2a.adapter.service.AspspReadOnlyRepository;
import de.adorsys.xs2a.adapter.service.Pkcs12KeyStore;
import de.adorsys.xs2a.adapter.service.RequestHeaders;
import de.adorsys.xs2a.adapter.service.exception.AdapterNotFoundException;
import de.adorsys.xs2a.adapter.service.link.LinksRewriter;
import de.adorsys.xs2a.adapter.service.loader.AdapterServiceLoader;
import de.adorsys.xs2a.adapter.service.loader.Xs2aPsd2AccountInformationServiceAdapter;
import de.adorsys.xs2a.adapter.service.loader.Xs2aPsd2PaymentInitiationServiceAdapter;
import de.adorsys.xs2a.adapter.service.model.Aspsp;
import de.adorsys.xs2a.adapter.service.psd2.Psd2AccountInformationService;
import de.adorsys.xs2a.adapter.service.psd2.Psd2AccountInformationServiceFactory;
import de.adorsys.xs2a.adapter.service.psd2.Psd2PaymentInitiationService;
import de.adorsys.xs2a.adapter.service.psd2.Psd2PaymentInitiationServiceFactory;
import java.util.Optional;

public class Psd2AdapterServiceLoader
extends AdapterServiceLoader {
    public Psd2AdapterServiceLoader(AspspReadOnlyRepository aspspRepository, Pkcs12KeyStore keyStore, HttpClientFactory httpClientFactory, LinksRewriter accountInformationLinksRewriter, LinksRewriter paymentInitiationLinksRewriter, boolean chooseFirstFromMultipleAspsps) {
        super(aspspRepository, keyStore, httpClientFactory, accountInformationLinksRewriter, paymentInitiationLinksRewriter, chooseFirstFromMultipleAspsps);
    }

    public Psd2AccountInformationService getPsd2AccountInformationService(RequestHeaders requestHeaders) {
        Aspsp aspsp = this.getAspsp(requestHeaders);
        String adapterId = aspsp.getAdapterId();
        String baseUrl = aspsp.getUrl();
        Optional<Psd2AccountInformationServiceFactory> serviceProvider = this.getServiceProvider(Psd2AccountInformationServiceFactory.class, adapterId);
        if (!serviceProvider.isPresent()) {
            return new Xs2aPsd2AccountInformationServiceAdapter(this.getAccountInformationService(requestHeaders));
        }
        return serviceProvider.orElseThrow(() -> new AdapterNotFoundException(adapterId)).getAccountInformationService(baseUrl, this.httpClientFactory, this.keyStore, this.accountInformationLinksRewriter);
    }

    public Psd2PaymentInitiationService getPsd2PaymentInitiationService(RequestHeaders requestHeaders) {
        Aspsp aspsp = this.getAspsp(requestHeaders);
        String adapterId = aspsp.getAdapterId();
        String baseUrl = aspsp.getUrl();
        Optional<Psd2PaymentInitiationServiceFactory> serviceProvider = this.getServiceProvider(Psd2PaymentInitiationServiceFactory.class, adapterId);
        if (!serviceProvider.isPresent()) {
            return new Xs2aPsd2PaymentInitiationServiceAdapter(this.getPaymentInitiationService(requestHeaders));
        }
        return serviceProvider.orElseThrow(() -> new AdapterNotFoundException(adapterId)).getPsd2PaymentInitiationService(baseUrl, this.httpClientFactory, this.keyStore, this.paymentInitiationLinksRewriter);
    }
}

