/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.loader;

import de.adorsys.xs2a.adapter.service.RequestHeaders;
import de.adorsys.xs2a.adapter.service.Response;
import de.adorsys.xs2a.adapter.service.loader.Psd2AdapterServiceLoader;
import de.adorsys.xs2a.adapter.service.psd2.Psd2AccountInformationService;
import de.adorsys.xs2a.adapter.service.psd2.model.AccountList;
import de.adorsys.xs2a.adapter.service.psd2.model.CardAccountDetailsResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.CardAccountList;
import de.adorsys.xs2a.adapter.service.psd2.model.CardAccountsTransactionsResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.ConsentInformationResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.ConsentStatusResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.Consents;
import de.adorsys.xs2a.adapter.service.psd2.model.ConsentsResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.ReadAccountBalanceResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.ReadCardAccountBalanceResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.ScaStatusResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.StartScaProcessResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.TransactionDetailsResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.UpdateAuthorisation;
import de.adorsys.xs2a.adapter.service.psd2.model.UpdateAuthorisationResponse;
import java.io.IOException;
import java.util.Map;

public class Psd2AdapterDelegatingAccountInformationService
implements Psd2AccountInformationService {
    private final Psd2AdapterServiceLoader adapterServiceLoader;

    public Psd2AdapterDelegatingAccountInformationService(Psd2AdapterServiceLoader adapterServiceLoader) {
        this.adapterServiceLoader = adapterServiceLoader;
    }

    public Response<ConsentsResponse> createConsent(Map<String, String> queryParameters, Map<String, String> headers, Consents consents) throws IOException {
        return this.getAccountInformationService(headers).createConsent(queryParameters, headers, consents);
    }

    private Psd2AccountInformationService getAccountInformationService(Map<String, String> headers) {
        return this.adapterServiceLoader.getPsd2AccountInformationService(RequestHeaders.fromMap(headers));
    }

    public Response<ConsentInformationResponse> getConsentInformation(String consentId, Map<String, String> queryParameters, Map<String, String> headers) throws IOException {
        return this.getAccountInformationService(headers).getConsentInformation(consentId, queryParameters, headers);
    }

    public Response<Void> deleteConsent(String consentId, Map<String, String> queryParameters, Map<String, String> headers) throws IOException {
        return this.getAccountInformationService(headers).deleteConsent(consentId, queryParameters, headers);
    }

    public Response<ConsentStatusResponse> getConsentStatus(String consentId, Map<String, String> queryParameters, Map<String, String> headers) throws IOException {
        return this.getAccountInformationService(headers).getConsentStatus(consentId, queryParameters, headers);
    }

    public Response<ScaStatusResponse> getConsentScaStatus(String consentId, String authorisationId, Map<String, String> queryParameters, Map<String, String> headers) throws IOException {
        return this.getAccountInformationService(headers).getConsentScaStatus(consentId, authorisationId, queryParameters, headers);
    }

    public Response<CardAccountList> getCardAccountList(Map<String, String> queryParameters, Map<String, String> headers) throws IOException {
        return this.getAccountInformationService(headers).getCardAccountList(queryParameters, headers);
    }

    public Response<CardAccountDetailsResponse> getCardAccountDetails(String accountId, Map<String, String> queryParameters, Map<String, String> headers) throws IOException {
        return this.getAccountInformationService(headers).getCardAccountDetails(accountId, queryParameters, headers);
    }

    public Response<ReadCardAccountBalanceResponse> getCardAccountBalances(String accountId, Map<String, String> queryParameters, Map<String, String> headers) throws IOException {
        return this.getAccountInformationService(headers).getCardAccountBalances(accountId, queryParameters, headers);
    }

    public Response<CardAccountsTransactionsResponse> getCardAccountTransactionList(String accountId, Map<String, String> queryParameters, Map<String, String> headers) throws IOException {
        return this.getAccountInformationService(headers).getCardAccountTransactionList(accountId, queryParameters, headers);
    }

    public Response<StartScaProcessResponse> startConsentAuthorisation(String consentId, Map<String, String> queryParameters, Map<String, String> headers, UpdateAuthorisation updateAuthentication) throws IOException {
        return this.getAccountInformationService(headers).startConsentAuthorisation(consentId, queryParameters, headers, updateAuthentication);
    }

    public Response<UpdateAuthorisationResponse> updateConsentsPsuData(String consentId, String authorisationId, Map<String, String> queryParameters, Map<String, String> headers, UpdateAuthorisation updateAuthentication) throws IOException {
        return this.getAccountInformationService(headers).updateConsentsPsuData(consentId, authorisationId, queryParameters, headers, updateAuthentication);
    }

    public Response<AccountList> getAccounts(Map<String, String> queryParameters, Map<String, String> headers) throws IOException {
        return this.getAccountInformationService(headers).getAccounts(queryParameters, headers);
    }

    public Response<ReadAccountBalanceResponse> getBalances(String accountId, Map<String, String> queryParameters, Map<String, String> headers) throws IOException {
        return this.getAccountInformationService(headers).getBalances(accountId, queryParameters, headers);
    }

    public Response getTransactions(String accountId, Map<String, String> queryParameters, Map<String, String> headers) throws IOException {
        return this.getAccountInformationService(headers).getTransactions(accountId, queryParameters, headers);
    }

    public Response<TransactionDetailsResponse> getTransactionDetails(String accountId, String transactionId, Map<String, String> queryParameters, Map<String, String> headers) throws IOException {
        return this.getAccountInformationService(headers).getTransactionDetails(accountId, transactionId, queryParameters, headers);
    }
}

