/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.api.model;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;

public enum Scope {
    AIS("ais"),
    AIS_BALANCES("ais_balances"),
    AIS_TRANSACTIONS("ais_transactions"),
    PIS("pis");

    private static final EnumSet<Scope> AIS_VALUES;
    private static final EnumSet<Scope> PIS_VALUES;
    private static final Set<String> VALUES;
    private final String value;

    private Scope(String value) {
        this.value = value;
    }

    public static Scope fromValue(String value) {
        for (Scope e : Scope.values()) {
            if (!e.value.equals(value)) continue;
            return e;
        }
        throw new IllegalArgumentException(value);
    }

    public static boolean isAis(Scope scope) {
        return AIS_VALUES.contains((Object)scope);
    }

    public static boolean isPis(Scope scope) {
        return PIS_VALUES.contains((Object)scope);
    }

    private static Set<String> getValues() {
        return Arrays.stream(Scope.values()).map(scope -> scope.value).collect(Collectors.toSet());
    }

    public static boolean contains(String value) {
        return VALUES.contains(value);
    }

    public String toString() {
        return this.value;
    }

    public String getValue() {
        return this.value;
    }

    static {
        AIS_VALUES = EnumSet.of(AIS, AIS_BALANCES, AIS_TRANSACTIONS);
        PIS_VALUES = EnumSet.of(PIS);
        VALUES = Scope.getValues();
    }
}

